/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.SingleChildInstance;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Zoomer
extends AbstractConfigurable
implements GameComponent {
    protected Map map;
    protected LaunchButton zoomInButton;
    protected LaunchButton zoomPickButton;
    protected LaunchButton zoomOutButton;
    protected ZoomMenu zoomMenu;
    protected State state = new State(defaultZoomLevels, 2);
    protected static final double[] defaultZoomLevels = new double[]{0.390625, 0.625, 1.0, 1.6};
    protected static final int defaultInitialZoomLevel = 2;
    protected static final String ZOOM_START = "zoomStart";
    protected static final String ZOOM_LEVELS = "zoomLevels";
    protected static final String ZOOM_IN = "zoomInKey";
    protected static final String IN_TOOLTIP = "inTooltip";
    protected static final String IN_BUTTON_TEXT = "inButtonText";
    protected static final String IN_ICON_NAME = "inIconName";
    protected static final String IN_DEFAULT_ICON = "/images/zoomIn.gif";
    protected static final String ZOOM_PICK = "zoomPickKey";
    protected static final String PICK_TOOLTIP = "pickTooltip";
    protected static final String PICK_BUTTON_TEXT = "pickButtonText";
    protected static final String PICK_ICON_NAME = "pickIconName";
    protected static final String PICK_DEFAULT_ICON = "/images/zoom.png";
    protected static final String ZOOM_OUT = "zoomOutKey";
    protected static final String OUT_TOOLTIP = "outTooltip";
    protected static final String OUT_BUTTON_TEXT = "outButtonText";
    protected static final String OUT_ICON_NAME = "outIconName";
    protected static final String OUT_DEFAULT_ICON = "/images/zoomOut.gif";
    private static final String FACTOR = "factor";
    private static final String MAX = "max";
    private int deprecatedMax = -1;
    private double deprecatedFactor = -1.0;

    public Zoomer() {
        ActionListener zoomIn = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Zoomer.this.zoomIn();
            }
        };
        ActionListener zoomOut = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Zoomer.this.zoomOut();
            }
        };
        this.zoomMenu = new ZoomMenu();
        ActionListener zoomPick = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Zoomer.this.zoomPickButton.isShowing()) {
                    Zoomer.this.zoomMenu.show(Zoomer.this.zoomPickButton, 0, Zoomer.this.zoomPickButton.getHeight());
                }
            }
        };
        this.zoomPickButton = new LaunchButton(null, PICK_TOOLTIP, PICK_BUTTON_TEXT, ZOOM_PICK, PICK_ICON_NAME, zoomPick);
        this.zoomPickButton.setAttribute(PICK_TOOLTIP, Resources.getString("Zoomer.zoom_select"));
        this.zoomPickButton.setAttribute(PICK_ICON_NAME, PICK_DEFAULT_ICON);
        this.zoomInButton = new LaunchButton(null, IN_TOOLTIP, IN_BUTTON_TEXT, ZOOM_IN, IN_ICON_NAME, zoomIn);
        this.zoomInButton.setAttribute(IN_TOOLTIP, Resources.getString("Zoomer.zoom_in"));
        this.zoomInButton.setAttribute(IN_ICON_NAME, IN_DEFAULT_ICON);
        this.zoomOutButton = new LaunchButton(null, OUT_TOOLTIP, OUT_BUTTON_TEXT, ZOOM_OUT, OUT_ICON_NAME, zoomOut);
        this.zoomOutButton.setAttribute(OUT_TOOLTIP, Resources.getString("Zoomer.zoom_out"));
        this.zoomOutButton.setAttribute(OUT_ICON_NAME, OUT_DEFAULT_ICON);
        this.setConfigureName(null);
        this.init();
    }

    protected void init() {
        this.zoomInButton.setEnabled(this.state.hasHigherLevel());
        this.zoomPickButton.setEnabled(true);
        this.zoomOutButton.setEnabled(this.state.hasLowerLevel());
        this.zoomMenu.initZoomItems();
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.Zoom.component_type");
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{ZOOM_START, ZOOM_LEVELS, IN_TOOLTIP, IN_BUTTON_TEXT, IN_ICON_NAME, ZOOM_IN, PICK_TOOLTIP, PICK_BUTTON_TEXT, PICK_ICON_NAME, ZOOM_PICK, OUT_TOOLTIP, OUT_BUTTON_TEXT, OUT_ICON_NAME, ZOOM_OUT};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"", Resources.getString("Editor.Zoom.preset"), Resources.getString("Editor.Zoom.in_tooltip"), Resources.getString("Editor.Zoom.in_button"), Resources.getString("Editor.Zoom.in_icon"), Resources.getString("Editor.Zoom.in_key"), Resources.getString("Editor.Zoom.select_tooltip"), Resources.getString("Editor.Zoom.select_button"), Resources.getString("Editor.Zoom.select_icon"), Resources.getString("Editor.Zoom.select_key"), Resources.getString("Editor.Zoom.out_tooltip"), Resources.getString("Editor.Zoom.out_button"), Resources.getString("Editor.Zoom.out_icon"), Resources.getString("Editor.Zoom.out_key")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{null, LevelConfig.class, String.class, String.class, InIconConfig.class, NamedKeyStroke.class, String.class, String.class, PickIconConfig.class, NamedKeyStroke.class, String.class, String.class, OutIconConfig.class, NamedKeyStroke.class};
    }

    @Override
    public void addTo(Buildable b) {
        GameModule.getGameModule().getGameState().addGameComponent(this);
        this.map = (Map)b;
        this.validator = new SingleChildInstance(this.map, this.getClass());
        this.map.setZoomer(this);
        this.map.getToolBar().add(this.zoomInButton);
        this.map.getToolBar().add(this.zoomPickButton);
        this.map.getToolBar().add(this.zoomOutButton);
    }

    @Override
    public String getAttributeValueString(String key) {
        if (ZOOM_START.equals(key)) {
            return String.valueOf(this.state.getLevelCount() - this.state.getInitialLevel());
        }
        if (ZOOM_LEVELS.equals(key)) {
            List<Double> levels = this.state.getLevels();
            String[] s = new String[levels.size()];
            for (int i = 0; i < s.length; ++i) {
                s[i] = levels.get(i).toString();
            }
            return StringArrayConfigurer.arrayToString(s);
        }
        if (this.zoomInButton.getAttributeValueString(key) != null) {
            return this.zoomInButton.getAttributeValueString(key);
        }
        if (this.zoomPickButton.getAttributeValueString(key) != null) {
            return this.zoomPickButton.getAttributeValueString(key);
        }
        return this.zoomOutButton.getAttributeValueString(key);
    }

    @Override
    public void setAttribute(String key, Object val) {
        if (ZOOM_START.equals(key)) {
            if (val instanceof String) {
                val = Integer.valueOf((String)val);
            }
            if (val != null) {
                List<Double> levels = this.state.getLevels();
                int initial = Math.max(0, Math.min(levels.size() - 1, levels.size() - (Integer)val));
                this.state = new State(levels, initial);
                if (this.deprecatedFactor > 0.0 && this.deprecatedMax > 0) {
                    this.deprecatedFactor = 0.0;
                    this.deprecatedMax = 0;
                }
                this.init();
            }
        } else if (ZOOM_LEVELS.equals(key)) {
            if (val instanceof String) {
                val = StringArrayConfigurer.stringToArray((String)val);
            }
            if (val != null) {
                HashSet<Double> levels = new HashSet<Double>();
                for (String s : val) {
                    levels.add(Double.valueOf(s));
                }
                this.state = new State(levels, Math.min(this.state.getInitialLevel(), levels.size() - 1));
                this.init();
            }
        } else if (FACTOR.equals(key)) {
            if (val instanceof String) {
                val = Double.valueOf((String)val);
            }
            if (val != null) {
                this.deprecatedFactor = (Double)val;
                if (this.deprecatedFactor > 0.0 && this.deprecatedMax > 0) {
                    this.adjustStateForFactorAndMax();
                }
            }
        } else if (MAX.equals(key)) {
            if (val instanceof String) {
                val = Integer.valueOf((String)val);
            }
            if (val != null) {
                this.deprecatedMax = (Integer)val;
                if (this.deprecatedFactor > 0.0 && this.deprecatedMax > 0) {
                    this.adjustStateForFactorAndMax();
                }
            }
        } else {
            this.zoomInButton.setAttribute(key, val);
            this.zoomPickButton.setAttribute(key, val);
            this.zoomOutButton.setAttribute(key, val);
        }
    }

    private void adjustStateForFactorAndMax() {
        double[] levels = new double[this.deprecatedMax + 1];
        for (int i = 0; i < levels.length; ++i) {
            levels[i] = Math.pow(this.deprecatedFactor, -(i - 1));
        }
        int initial = Math.min(this.state.getInitialLevel(), levels.length - 1);
        this.state = new State(levels, initial);
        this.init();
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void removeFrom(Buildable b) {
        this.map = (Map)b;
        this.map.setZoomer(null);
        this.map.getToolBar().remove(this.zoomInButton);
        this.map.getToolBar().remove(this.zoomPickButton);
        this.map.getToolBar().remove(this.zoomOutButton);
    }

    public double getZoomFactor() {
        return this.state.getZoom();
    }

    protected Point getMapCenter() {
        Rectangle r = this.map.getView().getVisibleRect();
        return this.map.componentToMap(new Point(r.x + r.width / 2, r.y + r.height / 2));
    }

    protected void updateZoomer(Point center) {
        this.zoomInButton.setEnabled(this.state.hasHigherLevel());
        this.zoomOutButton.setEnabled(this.state.hasLowerLevel());
        this.zoomMenu.updateZoom();
        Dimension d = this.map.getPreferredSize();
        this.map.getView().setBounds(0, 0, d.width, d.height);
        this.map.centerAt(center);
        this.map.repaint(true);
    }

    public void setZoomLevel(int l) {
        Point center = this.getMapCenter();
        this.state.setLevel(l);
        this.updateZoomer(center);
    }

    public void setZoomFactor(double z) {
        Point center = this.getMapCenter();
        this.state.setZoom(z);
        this.updateZoomer(center);
    }

    public void zoomIn() {
        if (this.state.hasHigherLevel()) {
            Point center = this.getMapCenter();
            this.state.higherLevel();
            this.updateZoomer(center);
        }
    }

    public void zoomOut() {
        if (this.state.hasLowerLevel()) {
            Point center = this.getMapCenter();
            this.state.lowerLevel();
            this.updateZoomer(center);
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "Zoom");
    }

    @Override
    public void setup(boolean gameStarting) {
        if (!gameStarting) {
            this.zoomInButton.setEnabled(this.state.hasHigherLevel());
            this.zoomOutButton.setEnabled(this.state.hasLowerLevel());
        }
        this.zoomPickButton.setEnabled(gameStarting);
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    protected static class State {
        private double custom;
        private final double[] levels;
        private int cur;
        private final int initial;

        public State(double[] levels, int initial) {
            this.levels = levels;
            Arrays.sort(this.levels);
            this.cur = this.initial = initial;
            this.custom = -1.0;
        }

        public State(Collection<Double> l, int initial) {
            this.levels = new double[l.size()];
            int i = 0;
            for (Double d : l) {
                this.levels[i++] = d;
            }
            Arrays.sort(this.levels);
            this.cur = this.initial = initial;
            this.custom = -1.0;
        }

        public double getZoom() {
            return this.custom < 0.0 ? this.levels[this.cur] : this.custom;
        }

        public void setZoom(double z) {
            if (z <= 0.0) {
                z = Double.MIN_VALUE;
            }
            this.cur = Arrays.binarySearch(this.levels, z);
            if (this.cur < 0) {
                this.cur = -this.cur - 1;
                if (this.cur < this.levels.length && Math.abs(z - this.levels[this.cur]) < 0.005) {
                    this.custom = -1.0;
                } else if (this.cur > 0 && Math.abs(z - this.levels[this.cur - 1]) < 0.005) {
                    --this.cur;
                    this.custom = -1.0;
                } else {
                    this.custom = z;
                }
            } else {
                this.custom = -1.0;
            }
        }

        public int getLevel() {
            return this.cur;
        }

        public void setLevel(int l) {
            this.cur = l;
            this.custom = -1.0;
        }

        public int getInitialLevel() {
            return this.initial;
        }

        public int getLevelCount() {
            return this.levels.length;
        }

        public boolean atLevel() {
            return this.custom < 0.0;
        }

        public void lowerLevel() {
            if (this.custom >= 0.0) {
                this.custom = -1.0;
            }
            --this.cur;
        }

        public void higherLevel() {
            if (this.custom < 0.0) {
                ++this.cur;
            } else {
                this.custom = -1.0;
            }
        }

        public boolean hasLowerLevel() {
            return this.cur > 0;
        }

        public boolean hasHigherLevel() {
            return this.custom < 0.0 ? this.cur < this.levels.length - 1 : this.cur < this.levels.length;
        }

        public List<Double> getLevels() {
            ArrayList<Double> l = new ArrayList<Double>(this.levels.length);
            for (double d : this.levels) {
                l.add(d);
            }
            return l;
        }
    }

    protected class ZoomMenu
    extends JPopupMenu
    implements ActionListener {
        protected final JRadioButtonMenuItem other;
        protected final JPopupMenu.Separator sep = new JPopupMenu.Separator();
        protected final ButtonGroup bg;
        private static final String OTHER = "Other...";
        private static final String FIT_WIDTH = "Fit Width";
        private static final String FIT_HEIGHT = "Fit Height";
        private static final String FIT_VISIBLE = "Fit Visible";
        private static final long serialVersionUID = 1L;

        public ZoomMenu() {
            this.add(this.sep);
            this.bg = new ButtonGroup();
            this.other = new JRadioButtonMenuItem(Resources.getString("Zoomer.ZoomMenu.other"));
            this.other.setActionCommand(OTHER);
            this.other.addActionListener(this);
            this.bg.add(this.other);
            this.add(this.other);
            this.addSeparator();
            JMenuItem fw = new JMenuItem(Resources.getString("Zoomer.ZoomMenu.fit_width"));
            fw.setActionCommand(FIT_WIDTH);
            fw.addActionListener(this);
            this.add(fw);
            JMenuItem fh = new JMenuItem(Resources.getString("Zoomer.ZoomMenu.fit_height"));
            fh.setActionCommand(FIT_HEIGHT);
            fh.addActionListener(this);
            this.add(fh);
            JMenuItem fv = new JMenuItem(Resources.getString("Zoomer.ZoomMenu.fit_visible"));
            fv.setActionCommand(FIT_VISIBLE);
            fv.addActionListener(this);
            this.add(fv);
        }

        public void initZoomItems() {
            while (this.getComponent(0) != this.sep) {
                this.remove(0);
            }
            List<Double> levels = Zoomer.this.state.getLevels();
            for (int i = 0; i < levels.size(); ++i) {
                String zs = Math.round(levels.get(i) * 100.0) + "%";
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(zs);
                item.setActionCommand(Integer.toString(i));
                item.addActionListener(this);
                this.bg.add(item);
                this.insert(item, 0);
            }
            ((JRadioButtonMenuItem)this.getComponent(Zoomer.this.state.getLevelCount() - Zoomer.this.state.getLevel() - 1)).setSelected(true);
        }

        @Override
        public void actionPerformed(ActionEvent a) {
            try {
                Zoomer.this.setZoomLevel(Integer.parseInt(a.getActionCommand()));
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String cmd = a.getActionCommand();
                if (OTHER.equals(cmd)) {
                    ZoomDialog dialog = new ZoomDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, Zoomer.this.map.getView()), Resources.getString("Zoomer.ZoomDialog.title"), true);
                    dialog.setVisible(true);
                    double z = dialog.getResult() / 100.0;
                    if (z > 0.0 && z != Zoomer.this.state.getZoom()) {
                        Zoomer.this.setZoomFactor(z);
                    }
                } else if (FIT_WIDTH.equals(cmd)) {
                    Dimension vd = Zoomer.this.map.getView().getVisibleRect().getSize();
                    Dimension md = Zoomer.this.map.mapSize();
                    Zoomer.this.setZoomFactor(vd.getWidth() / md.getWidth());
                } else if (FIT_HEIGHT.equals(cmd)) {
                    Dimension vd = Zoomer.this.map.getView().getVisibleRect().getSize();
                    Dimension md = Zoomer.this.map.mapSize();
                    Zoomer.this.setZoomFactor(vd.getHeight() / md.getHeight());
                } else if (FIT_VISIBLE.equals(cmd)) {
                    Dimension vd = Zoomer.this.map.getView().getVisibleRect().getSize();
                    Dimension md = Zoomer.this.map.mapSize();
                    Zoomer.this.setZoomFactor(Math.min(vd.getWidth() / md.getWidth(), vd.getHeight() / md.getHeight()));
                } else assert (false);
                return;
            }
        }

        public void updateZoom() {
            if (Zoomer.this.state.atLevel()) {
                ((JRadioButtonMenuItem)this.getComponent(Zoomer.this.state.getLevelCount() - Zoomer.this.state.getLevel() - 1)).setSelected(true);
            } else {
                this.other.setSelected(true);
            }
        }
    }

    public static class LevelConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new LevelConfigurer((Zoomer)c, key, name);
        }
    }

    public static class InIconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, Zoomer.IN_DEFAULT_ICON);
        }
    }

    public static class PickIconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, Zoomer.PICK_DEFAULT_ICON);
        }
    }

    public static class OutIconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, Zoomer.OUT_DEFAULT_ICON);
        }
    }

    protected class ZoomDialog
    extends JDialog
    implements ActionListener,
    ChangeListener {
        protected double result;
        protected final JSpinner ratioNumeratorSpinner;
        protected final JSpinner ratioDenominatorSpinner;
        protected final JSpinner percentSpinner;
        protected final SpinnerNumberModel ratioNumeratorModel;
        protected final SpinnerNumberModel ratioDenominatorModel;
        protected final SpinnerNumberModel percentModel;
        protected final JButton okButton;
        private static final long serialVersionUID = 1L;

        public ZoomDialog(Frame owner, String title, boolean modal) {
            super(owner, title, modal);
            int hsep = 5;
            JPanel controlsPane = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            Insets linset = new Insets(0, 0, 11, 11);
            Insets dinset = new Insets(0, 0, 0, 0);
            JLabel ratioLabel = new JLabel(Resources.getString("Zoomer.ZoomDialog.zoom_ratio"));
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = linset;
            c.anchor = 21;
            controlsPane.add((Component)ratioLabel, c);
            Box ratioBox = new Box(0);
            ratioLabel.setLabelFor(ratioBox);
            c.gridx = 1;
            c.gridy = 0;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = dinset;
            c.anchor = 21;
            controlsPane.add((Component)ratioBox, c);
            this.ratioNumeratorModel = new SpinnerNumberModel(1, 1, 256, 1);
            this.ratioNumeratorSpinner = new JSpinner(this.ratioNumeratorModel);
            this.ratioNumeratorSpinner.addChangeListener(this);
            ratioBox.add(this.ratioNumeratorSpinner);
            ratioBox.add(Box.createHorizontalStrut(5));
            JLabel ratioColon = new JLabel(":");
            ratioBox.add(ratioColon);
            ratioBox.add(Box.createHorizontalStrut(5));
            this.ratioDenominatorModel = new SpinnerNumberModel(1, 1, 256, 1);
            this.ratioDenominatorSpinner = new JSpinner(this.ratioDenominatorModel);
            this.ratioDenominatorSpinner.addChangeListener(this);
            ratioBox.add(this.ratioDenominatorSpinner);
            JLabel percentLabel = new JLabel(Resources.getString("Zoomer.ZoomDialog.zoom_percent"));
            c.gridx = 0;
            c.gridy = 1;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.insets = linset;
            c.anchor = 21;
            controlsPane.add((Component)percentLabel, c);
            Box percentBox = new Box(0);
            c.gridx = 1;
            c.gridy = 1;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.insets = dinset;
            c.anchor = 21;
            controlsPane.add((Component)percentBox, c);
            this.percentModel = new SpinnerNumberModel(Zoomer.this.state.getZoom() * 100.0, 0.39, 25600.0, 10.0);
            this.percentSpinner = new JSpinner(this.percentModel);
            percentLabel.setLabelFor(this.percentSpinner);
            this.percentSpinner.addChangeListener(this);
            percentBox.add(this.percentSpinner);
            this.updateRatio();
            percentBox.add(Box.createHorizontalStrut(5));
            JLabel percentSign = new JLabel("%");
            percentBox.add(percentSign);
            Box buttonBox = new Box(0);
            buttonBox.add(Box.createHorizontalGlue());
            this.okButton = new JButton(Resources.getString("General.ok"));
            this.okButton.addActionListener(this);
            this.getRootPane().setDefaultButton(this.okButton);
            buttonBox.add(this.okButton);
            buttonBox.add(Box.createHorizontalStrut(5));
            JButton cancelButton = new JButton(Resources.getString("General.cancel"));
            cancelButton.addActionListener(this);
            buttonBox.add(cancelButton);
            Dimension okDim = this.okButton.getPreferredSize();
            Dimension cancelDim = cancelButton.getPreferredSize();
            Dimension buttonDimension = new Dimension(Math.max(okDim.width, cancelDim.width), Math.max(okDim.height, cancelDim.height));
            this.okButton.setPreferredSize(buttonDimension);
            cancelButton.setPreferredSize(buttonDimension);
            JComponent contentPane = (JComponent)this.getContentPane();
            contentPane.setBorder(new EmptyBorder(12, 12, 11, 11));
            contentPane.setLayout(new BorderLayout(0, 11));
            contentPane.add((Component)controlsPane, "Center");
            contentPane.add((Component)buttonBox, "Last");
            this.setResizable(false);
            this.pack();
        }

        public double getResult() {
            return this.result;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.result = e.getSource() == this.okButton ? this.percentModel.getNumber().doubleValue() : 0.0;
            this.setVisible(false);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() == this.ratioNumeratorSpinner || e.getSource() == this.ratioDenominatorSpinner) {
                this.updatePercent();
            } else if (e.getSource() == this.percentSpinner) {
                this.updateRatio();
            }
        }

        private void updatePercent() {
            this.percentSpinner.removeChangeListener(this);
            this.percentModel.setValue(this.ratioNumeratorModel.getNumber().doubleValue() / this.ratioDenominatorModel.getNumber().doubleValue() * 100.0);
            this.percentSpinner.addChangeListener(this);
        }

        private void updateRatio() {
            double z = this.percentModel.getNumber().doubleValue() / 100.0;
            boolean swapped = false;
            if (z < 1.0) {
                z = 1.0 / z;
                swapped = true;
            }
            int p0 = 1;
            int q0 = 0;
            int p1 = (int)Math.floor(z);
            int q1 = 1;
            double r = z - (double)p1;
            while (Math.abs(r) >= 1.0E-4 && Math.abs((double)p1 / (double)q1 - z) > 1.0E-4) {
                r = 1.0 / r;
                double next_cf = Math.floor(r);
                int p2 = (int)(next_cf * (double)p1 + (double)p0);
                int q2 = (int)(next_cf * (double)q1 + (double)q0);
                if (p2 > 256 || q2 > 256 || p2 > 1 && q2 > 1 && p2 * q2 > 200) break;
                p0 = p1;
                p1 = p2;
                q0 = q1;
                q1 = q2;
                r -= next_cf;
            }
            if ((z = (double)p1 / (double)q1) > 256.0) {
                p1 = 256;
                q1 = 1;
            } else if (z < 0.00390625) {
                p1 = 1;
                q1 = 256;
            }
            if (swapped) {
                int tmp = p1;
                p1 = q1;
                q1 = tmp;
            }
            this.ratioNumeratorSpinner.removeChangeListener(this);
            this.ratioDenominatorSpinner.removeChangeListener(this);
            this.ratioNumeratorModel.setValue(p1);
            this.ratioDenominatorModel.setValue(q1);
            this.ratioNumeratorSpinner.addChangeListener(this);
            this.ratioDenominatorSpinner.addChangeListener(this);
        }
    }

    protected static class LevelConfigurer
    extends Configurer {
        private final Zoomer z;
        private final JPanel panel;
        private final LevelModel model;
        private final JList<String> levelList;
        private final JButton addButton;
        private final JButton removeButton;
        private final JButton initialButton;
        private final JTextField levelField;

        public LevelConfigurer(final Zoomer z, String key, String name) {
            super(key, name);
            this.z = z;
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 0));
            Box leftBox = Box.createVerticalBox();
            Box addBox = Box.createHorizontalBox();
            this.addButton = new JButton(Resources.getString("General.add"));
            this.addButton.addActionListener(e -> this.addLevel());
            this.addButton.setEnabled(false);
            addBox.add(this.addButton);
            this.levelField = new JTextField(8);
            this.levelField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.levelField.getPreferredSize().height));
            this.levelField.getDocument().addDocumentListener(new DocumentListener(){
                private static final String PATTERN = "^(\\d*[1-9]\\d*(/\\d*[1-9]\\d*|\\.\\d*)?|0*\\.\\d*[1-9]\\d*)$";

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.validate();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.validate();
                }

                private void validate() {
                    String text = levelField.getText();
                    addButton.setEnabled(text.matches(PATTERN) && !z.state.getLevels().contains(this.parseLevel(text)));
                }
            });
            this.levelField.addActionListener(e -> {
                if (this.addButton.isEnabled()) {
                    this.addLevel();
                }
            });
            addBox.add(this.levelField);
            leftBox.add(addBox);
            Box buttonBox = Box.createHorizontalBox();
            this.removeButton = new JButton(Resources.getString("General.remove"));
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int new_init;
                    int rm_level = levelList.getSelectedIndex();
                    List<Double> l = z.state.getLevels();
                    if (rm_level == z.state.getInitialLevel()) {
                        new_init = Math.min(rm_level, z.state.getLevelCount() - 2);
                        l.remove(rm_level);
                    } else {
                        Double old_init_val = l.get(z.state.getInitialLevel());
                        l.remove(rm_level);
                        new_init = l.indexOf(old_init_val);
                    }
                    z.state = new State(l, new_init);
                    z.init();
                    model.updateModel();
                    levelList.setSelectedIndex(Math.max(Math.min(rm_level, l.size() - 1), 0));
                    this.updateButtons();
                }
            });
            buttonBox.add(this.removeButton);
            this.initialButton = new JButton(Resources.getString("Editor.zoom.set_initial"));
            this.initialButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int i = levelList.getSelectedIndex();
                    z.state = new State(z.state.getLevels(), i);
                    z.init();
                    model.updateModel();
                    this.updateButtons();
                }
            });
            buttonBox.add(this.initialButton);
            leftBox.add(buttonBox);
            JLabel explanation = new JLabel(Resources.getString("Editor.zoom.initial_zoom"));
            explanation.setAlignmentX(0.5f);
            leftBox.add(Box.createVerticalStrut(explanation.getPreferredSize().height));
            leftBox.add(explanation);
            leftBox.add(Box.createVerticalStrut(explanation.getPreferredSize().height));
            this.model = new LevelModel();
            this.levelList = new JList<String>(this.model);
            this.levelList.setSelectionMode(0);
            this.levelList.setSelectedIndex(0);
            this.levelList.addListSelectionListener(e -> this.updateButtons());
            JSplitPane pane = new JSplitPane(1);
            pane.setLeftComponent(leftBox);
            pane.setRightComponent(new JScrollPane(this.levelList));
            this.panel.add(pane);
            this.panel.setBorder(new TitledBorder(name));
            this.updateButtons();
        }

        protected double parseLevel(String text) {
            String[] s = text.split("/");
            try {
                return s.length > 1 ? Double.parseDouble(s[0]) / Double.parseDouble(s[1]) : Double.parseDouble(s[0]);
            }
            catch (NumberFormatException ex) {
                ErrorDialog.bug(ex);
                return 0.0;
            }
        }

        protected void addLevel() {
            List<Double> l = this.z.state.getLevels();
            Double old_init_val = l.get(this.z.state.getInitialLevel());
            double new_level_val = this.parseLevel(this.levelField.getText());
            l.add(new_level_val);
            Collections.sort(l);
            int new_init = l.indexOf(old_init_val);
            this.z.state = new State(l, new_init);
            this.z.init();
            this.model.updateModel();
            int new_level = l.indexOf(new_level_val);
            this.levelList.setSelectedIndex(new_level);
            this.levelField.setText("");
            this.updateButtons();
        }

        protected void updateButtons() {
            this.removeButton.setEnabled(this.z.state.getLevelCount() > 1);
            this.initialButton.setEnabled(this.levelList.getSelectedIndex() != this.z.state.getInitialLevel());
        }

        @Override
        public Component getControls() {
            return this.panel;
        }

        @Override
        public void setValue(Object o) {
        }

        @Override
        public void setValue(String s) {
        }

        @Override
        public String getValueString() {
            return null;
        }

        protected class LevelModel
        extends AbstractListModel<String> {
            private static final long serialVersionUID = 1L;

            protected LevelModel() {
            }

            public void updateModel() {
                this.fireContentsChanged(this, 0, LevelConfigurer.this.z.state.getLevelCount() - 1);
            }

            @Override
            public String getElementAt(int i) {
                return LevelConfigurer.this.z.state.getLevels().get(i) + (LevelConfigurer.this.z.state.getInitialLevel() == i ? " *" : "");
            }

            @Override
            public int getSize() {
                return LevelConfigurer.this.z.state.getLevelCount();
            }
        }
    }
}

