/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.RegionGrid;
import VASSAL.counters.Labeler;
import VASSAL.i18n.Resources;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import javax.swing.JComponent;

public class Region
extends AbstractConfigurable {
    private Point origin = new Point(0, 0);
    private RegionGrid myGrid;
    private Rectangle selectionRect = new Rectangle();
    private boolean selected = false;
    public static final String NAME = "name";
    public static final String X = "originx";
    public static final String Y = "originy";

    public Region() {
        this.setConfigureName(Resources.getString("Editor.Region.new_region"));
    }

    public Region(Point p) {
        this();
        this.origin = p;
    }

    public Region(Region r) {
        this.setConfigureName(r.getName());
        this.origin.x = r.getOrigin().x;
        this.origin.y = r.getOrigin().y;
        this.myGrid = r.myGrid;
    }

    public String getName() {
        return this.getConfigureName();
    }

    public String getLocalizedName() {
        return this.getLocalizedConfigureName();
    }

    public Rectangle getSelectionRect() {
        return this.selectionRect;
    }

    public Point getOrigin() {
        return this.origin;
    }

    public void setOrigin(Point p) {
        this.origin = p;
    }

    public void moveOrigin(int dx, int dy) {
        this.origin.translate(dx, dy);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, X, Y};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.Region.x_coord"), Resources.getString("Editor.Region.y_coord")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Integer.class, Integer.class};
    }

    @Override
    public void addTo(Buildable b) {
        this.myGrid = (RegionGrid)b;
        this.myGrid.addRegion(this);
    }

    @Override
    public void removeFrom(Buildable b) {
        ((RegionGrid)b).removeRegion(this);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.Region.component_type");
    }

    public boolean contains(Point p) {
        return this.selectionRect.contains(p);
    }

    @Override
    public HelpFile getHelpFile() {
        return null;
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (X.equals(key)) {
            return String.valueOf(this.origin.x);
        }
        if (Y.equals(key)) {
            return String.valueOf(this.origin.y);
        }
        return null;
    }

    @Override
    public void setAttribute(String key, Object val) {
        if (val == null) {
            return;
        }
        if (NAME.equals(key)) {
            this.setConfigureName((String)val);
            if (this.myGrid != null) {
                this.myGrid.addRegion(this);
            }
        } else if (X.equals(key)) {
            if (val instanceof String) {
                val = Integer.valueOf((String)val);
            }
            this.origin.x = (Integer)val;
        } else if (Y.equals(key)) {
            if (val instanceof String) {
                val = Integer.valueOf((String)val);
            }
            this.origin.y = (Integer)val;
        }
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public String locationName() {
        return this.getConfigureName();
    }

    public String localizedLocationName() {
        return this.getLocalizedConfigureName();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean s) {
        this.selected = s;
    }

    public Board getBoard() {
        return this.myGrid.getBoard();
    }

    public void move(int dx, int dy, JComponent c) {
        Point newP = new Point(this.getOrigin());
        newP.translate(dx, dy);
        if (this.myGrid.container.contains(newP)) {
            this.moveOrigin(dx, dy);
        }
    }

    public void draw(Graphics g, Rectangle bounds, Rectangle visibleRect, double scale, boolean reversed) {
        this.draw(g, bounds, visibleRect, scale, reversed, 0, 0);
    }

    public void draw(Graphics g, Rectangle bounds, Rectangle visibleRect, double scale, boolean reversed, int xOffset, int yOffset) {
        if (!bounds.intersects(visibleRect)) {
            return;
        }
        int labelOffset = 7;
        int size = (int)(scale * (double)this.myGrid.getFontSize() + 0.5);
        Font f = new Font("Dialog", 0, size);
        Color fg = this.selected ? Color.white : Color.black;
        Color bg = this.selected ? Color.black : Color.white;
        Rectangle region = bounds.intersection(visibleRect);
        Shape oldClip = g.getClip();
        if (oldClip != null) {
            Area clipArea = new Area(oldClip);
            clipArea.intersect(new Area(region));
            g.setClip(clipArea);
        }
        int posX = (int)(scale * (double)this.origin.x + 0.5) + bounds.x - 1 + xOffset;
        int posY = (int)(scale * (double)this.origin.y + 0.5) + bounds.y - 1 + yOffset;
        Color saveColor = g.getColor();
        g.setColor(bg);
        g.fillRect(posX, posY, 3, 3);
        g.setColor(fg);
        g.drawRect(posX, posY, 3, 3);
        g.setColor(saveColor);
        Labeler.drawLabel(g, this.getLocalizedConfigureName(), posX, posY + 7, f, 0, 3, fg, bg, fg);
        g.setClip(oldClip);
        int width = g.getFontMetrics().stringWidth(this.getConfigureName() + "  ") + 1;
        int height = g.getFontMetrics().getHeight() + 1;
        this.selectionRect.setLocation(posX - width / 2, posY - 1);
        this.selectionRect.setSize(width, height + 7 + 1);
    }
}

