/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.module.gamepieceimage.StringEnumConfigurer;
import VASSAL.build.module.properties.EnumeratedPropertyPrompt;
import VASSAL.build.module.properties.IncrementProperty;
import VASSAL.build.module.properties.NumericPropertyPrompt;
import VASSAL.build.module.properties.PropertyChanger;
import VASSAL.build.module.properties.PropertyPrompt;
import VASSAL.build.module.properties.PropertySetter;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.configure.Configurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.FormattedStringArrayConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class PropertyChangerConfigurer
extends Configurer {
    protected static final String PLAIN_TYPE = "Set value directly";
    protected static final String INCREMENT_TYPE = "Increment numeric value";
    protected static final String PROMPT_TYPE = "Prompt user";
    protected static final String SELECT_TYPE = "Prompt user to select from list";
    protected static final char PLAIN_CODE = 'P';
    protected static final char PROMPT_CODE = 'R';
    protected static final char ENUM_CODE = 'E';
    protected static final char INCR_CODE = 'I';
    protected static final Map<Class<? extends PropertyChanger>, Character> typeToCode = new HashMap<Class<? extends PropertyChanger>, Character>();
    protected static final Map<Class<? extends PropertyChanger>, String> typeToDescription = new HashMap<Class<? extends PropertyChanger>, String>();
    protected static final Map<String, Character> descriptionToCode = new HashMap<String, Character>();
    protected Constraints constraints;
    protected JPanel controls;
    protected StringEnumConfigurer typeConfig;
    protected FormattedExpressionConfigurer valueConfig;
    protected StringConfigurer promptConfig;
    protected FormattedExpressionConfigurer incrConfig;
    protected StringArrayConfigurer validValuesConfig;

    public PropertyChangerConfigurer(String key, String name, Constraints constraints) {
        super(key, name);
        this.constraints = constraints;
        this.setValue(new PropertySetter("", null));
    }

    @Override
    public Component getControls() {
        if (this.controls == null) {
            PropertyChangeListener l = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    PropertyChangerConfigurer.this.updateValue();
                    PropertyChangerConfigurer.this.updateControls();
                }
            };
            this.controls = new JPanel();
            this.controls.setLayout(new BoxLayout(this.controls, 0));
            this.typeConfig = new StringEnumConfigurer(null, "Type:  ", new String[]{PLAIN_TYPE, INCREMENT_TYPE, PROMPT_TYPE, SELECT_TYPE});
            this.typeConfig.addPropertyChangeListener(l);
            this.valueConfig = new FormattedExpressionConfigurer(null, "New Value:  ", "", this.constraints);
            this.valueConfig.addPropertyChangeListener(l);
            this.promptConfig = new StringConfigurer(null, "Prompt:  ");
            this.promptConfig.addPropertyChangeListener(l);
            this.incrConfig = new FormattedExpressionConfigurer(null, "Increment by:  ", "", this.constraints);
            this.incrConfig.addPropertyChangeListener(l);
            this.validValuesConfig = new FormattedStringArrayConfigurer(null, "Valid Values", this.constraints);
            this.validValuesConfig.addPropertyChangeListener(l);
            this.controls.add(this.typeConfig.getControls());
            this.controls.add(this.valueConfig.getControls());
            this.controls.add(this.promptConfig.getControls());
            this.controls.add(this.incrConfig.getControls());
            this.controls.add(this.validValuesConfig.getControls());
            this.updateControls();
        }
        return this.controls;
    }

    protected void updateControls() {
        PropertyChanger pc = this.getPropertyChanger();
        this.typeConfig.setValue(typeToDescription.get(pc.getClass()));
        if (pc instanceof PropertySetter) {
            this.valueConfig.setValue(((PropertySetter)pc).getRawValue());
            this.valueConfig.getControls().setVisible(true);
        } else {
            this.valueConfig.getControls().setVisible(false);
        }
        if (pc instanceof IncrementProperty) {
            this.incrConfig.setValue(String.valueOf(((IncrementProperty)pc).getIncrement()));
            this.incrConfig.getControls().setVisible(true);
        } else {
            this.incrConfig.getControls().setVisible(false);
        }
        if (pc instanceof PropertyPrompt) {
            this.promptConfig.setValue(((PropertyPrompt)pc).getPrompt());
            this.promptConfig.getControls().setVisible(true);
        } else {
            this.promptConfig.getControls().setVisible(false);
        }
        if (pc instanceof EnumeratedPropertyPrompt) {
            this.validValuesConfig.setValue(((EnumeratedPropertyPrompt)pc).getValidValues());
            this.validValuesConfig.getControls().setVisible(true);
        } else {
            this.validValuesConfig.getControls().setVisible(false);
        }
    }

    protected void updateValue() {
        PropertyChanger p;
        switch (descriptionToCode.get(this.typeConfig.getValueString()).charValue()) {
            case 'R': {
                p = new PropertyPrompt(this.constraints, this.promptConfig.getValueString());
                break;
            }
            case 'I': {
                p = new IncrementProperty(this, this.incrConfig.getValueString(), this.constraints);
                break;
            }
            case 'E': {
                p = new EnumeratedPropertyPrompt(this.constraints, this.promptConfig.getValueString(), this.validValuesConfig.getStringArray(), this.constraints);
                break;
            }
            default: {
                p = new PropertySetter(this.valueConfig.getValueString(), this.constraints);
            }
        }
        this.setValue(p);
    }

    @Override
    public String getValueString() {
        PropertyChanger propChanger = this.getPropertyChanger();
        SequenceEncoder se = new SequenceEncoder(',');
        if (propChanger != null) {
            switch (typeToCode.get(propChanger.getClass()).charValue()) {
                case 'R': {
                    se.append('R').append(((PropertyPrompt)propChanger).getPrompt());
                    break;
                }
                case 'I': {
                    se.append('I').append(((IncrementProperty)propChanger).getIncrement());
                    break;
                }
                case 'E': {
                    se.append('E').append(((PropertyPrompt)propChanger).getPrompt()).append(((EnumeratedPropertyPrompt)propChanger).getValidValues());
                    break;
                }
                case 'P': {
                    se.append('P').append(((PropertySetter)propChanger).getRawValue());
                }
            }
        }
        return se.getValue();
    }

    public PropertyChanger getPropertyChanger() {
        return (PropertyChanger)this.getValue();
    }

    @Override
    public void setValue(String s) {
        PropertyChanger p;
        if (s == null || s.length() == 0) {
            s = Character.toString('P');
        }
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ',');
        switch (sd.nextChar('P')) {
            case 'R': {
                p = new PropertyPrompt(this.constraints, sd.nextToken("Enter new value"));
                break;
            }
            case 'I': {
                p = new IncrementProperty(this, sd.nextToken("1"), this.constraints);
                break;
            }
            case 'E': {
                p = new EnumeratedPropertyPrompt(this.constraints, sd.nextToken("Select new value"), sd.nextStringArray(0), this.constraints);
                break;
            }
            default: {
                p = new PropertySetter(sd.nextToken("new value"), this.constraints);
            }
        }
        this.setValue(p);
    }

    static {
        typeToCode.put(PropertySetter.class, Character.valueOf('P'));
        typeToCode.put(PropertyPrompt.class, Character.valueOf('R'));
        typeToCode.put(NumericPropertyPrompt.class, Character.valueOf('R'));
        typeToCode.put(IncrementProperty.class, Character.valueOf('I'));
        typeToCode.put(EnumeratedPropertyPrompt.class, Character.valueOf('E'));
        typeToDescription.put(PropertySetter.class, PLAIN_TYPE);
        typeToDescription.put(PropertyPrompt.class, PROMPT_TYPE);
        typeToDescription.put(NumericPropertyPrompt.class, PROMPT_TYPE);
        typeToDescription.put(IncrementProperty.class, INCREMENT_TYPE);
        typeToDescription.put(EnumeratedPropertyPrompt.class, SELECT_TYPE);
        descriptionToCode.put(PLAIN_TYPE, Character.valueOf('P'));
        descriptionToCode.put(INCREMENT_TYPE, Character.valueOf('I'));
        descriptionToCode.put(PROMPT_TYPE, Character.valueOf('R'));
        descriptionToCode.put(SELECT_TYPE, Character.valueOf('E'));
    }

    public static interface Constraints
    extends PropertyPrompt.Constraints,
    IncrementProperty.Constraints,
    PropertySource {
    }
}

