/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.widget;

import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.GpIdSupport;
import VASSAL.build.Widget;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.build.module.documentation.HelpWindowExtension;
import VASSAL.build.module.map.MenuDisplayer;
import VASSAL.build.module.map.PieceMover;
import VASSAL.build.widget.CardSlot;
import VASSAL.command.AddPiece;
import VASSAL.configure.Configurer;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.DragBuffer;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PieceDefiner;
import VASSAL.counters.PlaceMarker;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PieceSlot
extends Widget
implements MouseListener,
KeyListener {
    public static final String GP_ID = "gpid";
    protected GamePiece c;
    protected GamePiece expanded;
    protected String name;
    protected String pieceDefinition;
    protected static Font FONT = new Font("Dialog", 0, 12);
    protected JPanel panel = new Panel(this);
    protected int width;
    protected int height;
    protected String gpId = "";
    protected GpIdSupport gpidSupport;

    public PieceSlot() {
        this.panel.addMouseListener(this);
        this.panel.addKeyListener(this);
    }

    public PieceSlot(PieceSlot piece) {
        this();
        this.copyFrom(piece);
    }

    public PieceSlot(CardSlot card) {
        this((PieceSlot)card);
    }

    @Override
    public double getScale() {
        Widget w = this;
        while ((w = w.getParent()) != null) {
            if (!w.hasScale()) continue;
            return w.getScale();
        }
        return 1.0;
    }

    protected void copyFrom(PieceSlot piece) {
        this.c = piece.c;
        this.name = piece.name;
        this.pieceDefinition = piece.pieceDefinition;
        this.gpidSupport = piece.gpidSupport;
        this.gpId = piece.gpId;
    }

    public PieceSlot(GamePiece p) {
        this();
        this.setPiece(p);
    }

    public void setPiece(GamePiece p) {
        this.c = p;
        this.clearExpandedPiece();
        if (this.c != null) {
            Dimension size = this.panel.getSize();
            this.c.setPosition(new Point(size.width / 2, size.height / 2));
            this.name = Decorator.getInnermost(this.c).getName();
        }
        this.panel.revalidate();
        this.panel.repaint();
        this.pieceDefinition = this.c == null ? null : GameModule.getGameModule().encode(new AddPiece(this.c));
    }

    protected GamePiece getExpandedPiece() {
        GamePiece p;
        if (this.expanded == null && (p = this.getPiece()) != null) {
            this.expanded = PieceCloner.getInstance().clonePiece(p);
        }
        return this.expanded;
    }

    protected void clearExpandedPiece() {
        this.expanded = null;
    }

    public GamePiece getPiece() {
        if (this.c == null && this.pieceDefinition != null) {
            AddPiece comm = (AddPiece)GameModule.getGameModule().decode(this.pieceDefinition);
            if (comm == null) {
                System.err.println("Couldn't build piece " + this.pieceDefinition);
                this.pieceDefinition = null;
            } else {
                this.c = comm.getTarget();
                this.c.setState(comm.getState());
                Dimension size = this.panel.getSize();
                this.c.setPosition(new Point(size.width / 2, size.height / 2));
            }
        }
        if (this.c != null) {
            this.c.setProperty("PieceId", this.getGpId());
        }
        return this.c;
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
        AffineTransform orig_t = g2d.getTransform();
        g2d.setTransform(SwingUtils.descaleTransform(orig_t));
        Dimension size = this.panel.getSize();
        size.width = (int)((double)size.width * os_scale);
        size.height = (int)((double)size.height * os_scale);
        Color c = g.getColor();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, size.width, size.height);
        g.setColor(c);
        if (this.getExpandedPiece() == null) {
            g2d.addRenderingHints(SwingUtils.FONT_HINTS);
            FontMetrics fm = g.getFontMetrics();
            g.drawRect(0, 0, size.width - 1, size.height - 1);
            g.setFont(FONT.deriveFont((float)((double)FONT.getSize() * os_scale)));
            g.drawString(" nil ", size.width / 2 - fm.stringWidth(" nil ") / 2, size.height / 2);
        } else {
            this.getExpandedPiece().draw(g, size.width / 2, size.height / 2, this.panel, os_scale * this.getScale());
            if (Boolean.TRUE.equals(this.getPiece().getProperty("Selected"))) {
                BasicPiece.getHighlighter().draw(this.getExpandedPiece(), g, size.width / 2, size.height / 2, this.panel, os_scale * this.getScale());
            }
        }
        g2d.setTransform(orig_t);
    }

    public Dimension getPreferredSize() {
        if (this.c != null && this.panel.getGraphics() != null) {
            Dimension bound = this.c.boundingBox().getSize();
            bound.width = (int)((double)bound.width * this.getScale());
            bound.height = (int)((double)bound.height * this.getScale());
            return bound;
        }
        return new Dimension((int)((double)this.width * this.getScale()), (int)((double)this.height * this.getScale()));
    }

    protected void startDrag() {
        Dimension size = this.panel.getSize();
        this.getPiece().setPosition(new Point(size.width / 2, size.height / 2));
        this.getPiece().setProperty("Selected", null);
        this.panel.repaint();
        if (this.getPiece() != null) {
            KeyBuffer.getBuffer().clear();
            DragBuffer.getBuffer().clear();
            GamePiece newPiece = PieceCloner.getInstance().clonePiece(this.getPiece());
            newPiece.setProperty("PieceId", this.getGpId());
            DragBuffer.getBuffer().add(newPiece);
        }
    }

    protected void doPopup(MouseEvent e) {
        JPopupMenu popup = MenuDisplayer.createPopup(this.getPiece());
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
                PieceSlot.this.panel.repaint();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                PieceSlot.this.clearExpandedPiece();
                PieceSlot.this.panel.repaint();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        popup.show(this.panel, e.getX(), e.getY());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.doPopup(e);
        } else if (SwingUtils.isMainMouseButtonDown(e)) {
            KeyBuffer.getBuffer().clear();
            Map.clearActiveMap();
            if (this.getPiece() != null) {
                KeyBuffer.getBuffer().add(this.getPiece());
            }
            this.clearExpandedPiece();
            this.panel.requestFocus();
            this.panel.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        boolean doClear = false;
        if (e.isPopupTrigger()) {
            if (this.getPiece() != null) {
                this.doPopup(e);
            }
            doClear = true;
        } else if (SwingUtils.isMainMouseButtonDown(e)) {
            doClear = true;
        }
        if (doClear) {
            this.clearExpandedPiece();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        KeyBuffer.getBuffer().remove(this.getPiece());
        this.clearExpandedPiece();
        this.panel.repaint();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        KeyBuffer.getBuffer().keyCommand(SwingUtils.getKeyStrokeForEvent(e));
        e.consume();
        this.clearExpandedPiece();
        this.panel.repaint();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        KeyBuffer.getBuffer().keyCommand(SwingUtils.getKeyStrokeForEvent(e));
        e.consume();
        this.clearExpandedPiece();
        this.panel.repaint();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        KeyBuffer.getBuffer().keyCommand(SwingUtils.getKeyStrokeForEvent(e));
        e.consume();
        this.clearExpandedPiece();
        this.panel.repaint();
    }

    public static String getConfigureTypeName() {
        return "Single piece";
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    public void build(Element e) {
        this.gpidSupport = GameModule.getGameModule().getGpIdSupport();
        if (e != null) {
            this.name = e.getAttribute("entryName");
            this.gpId = e.getAttribute(GP_ID);
            if (this.name.length() == 0) {
                this.name = null;
            }
            try {
                this.width = Integer.parseInt(e.getAttribute("width"));
                this.height = Integer.parseInt(e.getAttribute("height"));
            }
            catch (NumberFormatException ex) {
                this.width = 60;
                this.height = 60;
            }
            this.pieceDefinition = Builder.getText(e);
            this.c = null;
        }
    }

    @Override
    public void addTo(Buildable par) {
        if (par instanceof Widget) {
            this.parent = (Widget)par;
        }
        this.panel.setDropTarget(PieceMover.AbstractDragHandler.makeDropTarget(this.panel, 2, null));
        DragGestureListener dragGestureListener = new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                if (SwingUtils.isDragTrigger(dge)) {
                    PieceSlot.this.startDrag();
                    PieceMover.AbstractDragHandler.getTheDragHandler().dragGestureRecognized(dge);
                }
            }
        };
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.panel, 2, dragGestureListener);
    }

    @Override
    public Element getBuildElement(Document doc) {
        Element el = doc.createElement(this.getClass().getName());
        String s = this.getConfigureName();
        if (s != null) {
            el.setAttribute("entryName", s);
        }
        el.setAttribute(GP_ID, this.gpId);
        el.setAttribute("width", "" + this.getPreferredSize().width);
        el.setAttribute("height", "" + this.getPreferredSize().height);
        if (this.c != null || this.pieceDefinition != null) {
            el.appendChild(doc.createTextNode(this.c == null ? this.pieceDefinition : GameModule.getGameModule().encode(new AddPiece(this.c))));
        }
        return el;
    }

    @Override
    public void removeFrom(Buildable parent) {
    }

    @Override
    public String getConfigureName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.getPiece() != null) {
            return Decorator.getInnermost(this.getPiece()).getName();
        }
        return null;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePiece.htm");
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[0];
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[0];
    }

    @Override
    public void setAttribute(String name, Object value) {
    }

    @Override
    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    @Override
    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public String getAttributeValueString(String attr) {
        return this.getI18nData().getLocalUntranslatedValue(attr);
    }

    @Override
    public ComponentI18nData getI18nData() {
        return new ComponentI18nData((Configurable)this, this.getPiece());
    }

    @Override
    public Configurer getConfigurer() {
        return new MyConfigurer(this);
    }

    public void updateGpId(GpIdSupport s) {
        this.gpidSupport = s;
        this.updateGpId();
    }

    public void updateGpId() {
        this.gpId = this.gpidSupport.generateGpId();
        GamePiece piece = this.getPiece();
        this.updateGpId(piece);
        this.setPiece(piece);
    }

    public void updateGpId(GamePiece piece) {
        if (piece == null || piece instanceof BasicPiece) {
            return;
        }
        if (piece instanceof PlaceMarker) {
            ((PlaceMarker)piece).setGpId(this.gpidSupport.generateGpId());
        }
        this.updateGpId(((Decorator)piece).getInner());
    }

    public String getGpId() {
        return this.gpId;
    }

    public void setGpId(String id) {
        this.gpId = id;
    }

    public class Panel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected PieceSlot pieceSlot;

        public Panel(PieceSlot slot) {
            this.setFocusTraversalKeysEnabled(false);
            this.pieceSlot = slot;
        }

        public PieceSlot getPieceSlot() {
            return this.pieceSlot;
        }

        @Override
        public void paint(Graphics g) {
            PieceSlot.this.paint(g);
        }

        @Override
        public Dimension getPreferredSize() {
            return PieceSlot.this.getPreferredSize();
        }
    }

    private static class MyConfigurer
    extends Configurer
    implements HelpWindowExtension {
        private PieceDefiner definer;

        public MyConfigurer(PieceSlot slot) {
            super(null, slot.getConfigureName(), slot);
            this.definer = new PieceDefiner(slot.getGpId(), slot.gpidSupport);
            this.definer.setPiece(slot.getPiece());
        }

        @Override
        @Deprecated
        public void setBaseWindow(HelpWindow w) {
        }

        @Override
        public String getValueString() {
            return null;
        }

        @Override
        public void setValue(String s) {
            throw new UnsupportedOperationException("Cannot set from String");
        }

        @Override
        public Object getValue() {
            PieceSlot slot = (PieceSlot)super.getValue();
            if (slot != null) {
                slot.setPiece(this.definer.getPiece());
            }
            return slot;
        }

        @Override
        public Component getControls() {
            return this.definer;
        }
    }
}

