/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.HybridClient;
import VASSAL.chat.ServerAddressBook;
import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class AddressBookServerConfigurer
extends Configurer {
    private static final String CONNECTED = Resources.getString("Server.please_disconnect");
    private static final String DISCONNECTED = Resources.getString("ServerAddressBook.select_server");
    private static final String ENCODING = "UTF-8";
    protected JComponent controls;
    protected ServerAddressBook addressBook;
    private HybridClient client;
    private JLabel header;

    public AddressBookServerConfigurer(String key, String name, HybridClient client) {
        super(key, name, client);
        this.client = client;
        client.addPropertyChangeListener("Connected", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AddressBookServerConfigurer.this.enableControls(Boolean.TRUE.equals(evt.getNewValue()));
            }
        });
        this.getControls();
        this.setValue(this.addressBook.getDefaultServerProperties());
        client.updateDisplayControls(this.addressBook.getCurrentIcon(), this.addressBook.getCurrentDescription());
    }

    @Override
    public Component getControls() {
        if (this.controls == null) {
            this.controls = new JPanel((LayoutManager)new MigLayout());
            this.header = new JLabel(DISCONNECTED);
            this.controls.add((Component)this.header, "wrap");
            this.addressBook = new ServerAddressBook();
            this.addressBook.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if ("currentServer".equals(e.getPropertyName())) {
                        AddressBookServerConfigurer.this.addressBook.setFrozen(true);
                        AddressBookServerConfigurer.this.setValue(e.getNewValue());
                        AddressBookServerConfigurer.this.addressBook.setFrozen(false);
                    }
                }
            });
            this.controls.add(this.addressBook.getControls());
        }
        return this.controls;
    }

    private void enableControls(boolean connected) {
        this.addressBook.setEnabled(!connected);
        this.header.setText(connected ? CONNECTED : DISCONNECTED);
    }

    @Override
    public void setValue(Object o) {
        super.setValue(o);
        if (!this.noUpdate && o instanceof Properties && this.controls != null) {
            this.addressBook.setCurrentServer((Properties)o);
        }
        if (this.client != null && !CONNECTED.equals(this.header.getText())) {
            this.client.setDelegate(ChatServerFactory.build(this.getServerInfo()));
            this.client.updateDisplayControls(this.addressBook.getCurrentIcon(), this.addressBook.getCurrentDescription());
        }
    }

    private Properties getServerInfo() {
        Properties p = (Properties)this.getValue();
        if (p == null) {
            p = new Properties();
        }
        return p;
    }

    @Override
    public String getValueString() {
        String s = "";
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Properties p = (Properties)this.getValue();
            if (p != null) {
                p.store(out, null);
            }
            s = new String(out.toByteArray(), ENCODING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }

    @Override
    public void setValue(String s) {
        Properties p = new Properties();
        try {
            p.load(new ByteArrayInputStream(s.getBytes(ENCODING)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setValue(p);
    }
}

