/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.node.AsynchronousServerNode;
import VASSAL.chat.node.ConnectionLimiter;
import VASSAL.chat.node.Node;
import VASSAL.chat.node.Protocol;
import VASSAL.chat.node.SocketHandler;
import VASSAL.chat.node.SocketWatcher;
import VASSAL.tools.SequenceEncoder;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;

public class PlayerNode
extends Node
implements SocketWatcher {
    private SocketHandler input;
    protected String id;
    protected String info;
    private AsynchronousServerNode server;
    private static ConnectionLimiter connLimiter = new ConnectionLimiter();

    public PlayerNode(Socket socket, AsynchronousServerNode server) throws IOException {
        super(null, null, null);
        this.input = new SocketHandler(socket, this);
        this.input.start();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public void send(String msg) {
        this.input.writeLine(msg);
    }

    @Override
    public String getInfo() {
        String ip = this.input.getInetAddress().getHostAddress();
        return this.info + (String)(ip.length() > 0 ? "|ip=" + ip : "");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlayerNode)) {
            return false;
        }
        PlayerNode player = (PlayerNode)o;
        return this.id.equals(player.id);
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public void handleMessage(String line) {
        String[] info = Protocol.decodeRegisterCommand(line);
        if (info != null) {
            this.id = info[0];
            this.info = info[2];
            this.server.registerNode(info[1], this);
        } else {
            info = Protocol.decodeJoinCommand(line);
            if (info != null) {
                boolean locked;
                SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(info[0], '/');
                sd.nextToken("");
                String joinRoomName = sd.nextToken("");
                Node room = this.server.getModule(this).getDescendant(joinRoomName);
                if (room != null && (locked = "true".equals(room.getInfoProperty("locked"))) && room.getChildren().length > 0) {
                    String owner = room.getInfoProperty("owner");
                    if (info.length < 2 || !owner.equals(info[1])) {
                        return;
                    }
                }
                this.server.move(this, info[0]);
            } else {
                info = Protocol.decodeForwardCommand(line);
                if (info != null) {
                    this.server.forward(info[0], info[1]);
                } else {
                    info = Protocol.decodeStatsCommand(line);
                    if (info != null) {
                        this.info = info[0];
                        this.server.updateInfo(this);
                    } else {
                        info = Protocol.decodeKickCommand(line);
                        if (info != null) {
                            this.server.kick(this, info[0]);
                        } else {
                            Properties p = Protocol.decodeRoomsInfo(line);
                            if (p != null) {
                                for (String roomName : p.stringPropertyNames()) {
                                    Node target = this.server.getModule(this).getDescendant(roomName);
                                    if (target == null) continue;
                                    target.setInfo(p.getProperty(roomName));
                                    this.server.updateInfo(target);
                                }
                            } else {
                                String cmd = Protocol.decodeLoginCommand(line);
                                if (cmd != null) {
                                    connLimiter.register(cmd, this.input);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void socketClosed(SocketHandler handler) {
        this.server.disconnect(this);
    }
}

