/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;

public class TextClient {
    private boolean reportRooms = true;
    private ChatServerConnection client;

    public TextClient(ChatServerConnection client) {
        this.client = client;
        client.addPropertyChangeListener("AvailableRooms", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TextClient.this.availableRoomsChanged(evt);
            }
        });
        client.addPropertyChangeListener("Msg", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TextClient.this.incomingMessageReceived(evt);
            }
        });
        client.addPropertyChangeListener("Status", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TextClient.this.statusReceived(evt);
            }
        });
        client.setConnected(true);
    }

    public ChatServerConnection getClient() {
        return this.client;
    }

    private void statusReceived(PropertyChangeEvent evt) {
        System.out.println(evt.getNewValue());
    }

    private void incomingMessageReceived(PropertyChangeEvent evt) {
        String msg = (String)evt.getNewValue();
        if (msg.startsWith("CHAT")) {
            System.out.println(msg.substring(4));
        }
    }

    private void availableRoomsChanged(PropertyChangeEvent evt) {
        if (this.reportRooms) {
            System.out.println("----------" + new Date() + "---------");
            System.out.print(TextClient.report((Room[])evt.getNewValue()));
        }
    }

    public static String report(Room[] r) {
        StringBuilder buffer = new StringBuilder();
        for (Room room : r) {
            buffer.append(room.getName() + ": ");
            Player[] p = (Player[])room.getPlayerList().toArray();
            for (int j = 0; j < p.length; ++j) {
                buffer.append(p[j]);
                if (j >= p.length - 1) continue;
                buffer.append(", ");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static class Encoder
    implements CommandEncoder {
        @Override
        public Command decode(String command) {
            ShowText c = null;
            if (command.startsWith("CHAT")) {
                c = new ShowText(command.substring(4));
            }
            return c;
        }

        @Override
        public String encode(Command c) {
            String s = null;
            if (c instanceof ShowText) {
                return "CHAT" + ((ShowText)c).getMessage();
            }
            return s;
        }
    }

    public static class ShowText
    extends Command {
        private String msg;

        public ShowText(String msg) {
            this.msg = msg;
        }

        public String getMessage() {
            return this.msg;
        }

        @Override
        protected void executeCommand() {
            System.out.println(this.msg);
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }
}

