/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.HttpMessageServer;
import VASSAL.chat.ServerStatus;
import VASSAL.chat.messageboard.MessageBoardControls;
import VASSAL.chat.peer2peer.PeerPoolInfo;
import VASSAL.chat.ui.ServerStatusView;
import VASSAL.i18n.Resources;
import VASSAL.tools.menu.MenuManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JToolBar;

public class ShowServerStatusAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static Window frame;

    public ShowServerStatusAction(ServerStatus status, URL iconURL) {
        this(status, iconURL, true);
    }

    public ShowServerStatusAction(ServerStatus status, URL iconURL, boolean includeMessageControls) {
        if (frame == null) {
            frame = new Window(status, includeMessageControls);
        }
        if (iconURL == null) {
            this.putValue("Name", Resources.getString("Chat.server_status"));
        } else {
            this.putValue("SmallIcon", new ImageIcon(iconURL));
        }
        this.putValue("ShortDescription", Resources.getString("Chat.display_connections"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        frame.refresh();
    }

    private static class Window
    extends JFrame
    implements PropertyChangeListener {
        private static final long serialVersionUID = 1L;
        private ServerStatusView view;
        private MessageBoardControls messageMgr;

        public Window(ServerStatus status, boolean includeMessageControls) {
            super(Resources.getString("Chat.server_status"));
            this.setJMenuBar(MenuManager.getInstance().getMenuBarFor(this));
            this.view = new ServerStatusView(status);
            this.view.addPropertyChangeListener("ServerStatusView.selection", this);
            this.add(this.view);
            if (includeMessageControls) {
                this.messageMgr = new MessageBoardControls();
                JToolBar toolbar = new JToolBar();
                toolbar.setFloatable(false);
                toolbar.add(this.messageMgr.getCheckMessagesAction());
                toolbar.add(this.messageMgr.getPostMessageAction());
                this.add((Component)toolbar, "North");
            }
            this.pack();
            this.setSize(Math.max(this.getSize().width, 400), Math.max(this.getSize().height, 300));
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(d.width / 2 - this.getSize().width / 2, d.height / 2 - this.getSize().height / 2);
        }

        public void refresh() {
            if (!this.isVisible()) {
                this.setVisible(true);
            } else {
                this.toFront();
            }
            this.view.refresh();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            HttpMessageServer server = null;
            String name = null;
            if (evt.getNewValue() instanceof ServerStatus.ModuleSummary) {
                final String moduleName = ((ServerStatus.ModuleSummary)evt.getNewValue()).getModuleName();
                server = new HttpMessageServer(new PeerPoolInfo(){

                    @Override
                    public String getModuleName() {
                        return moduleName;
                    }

                    @Override
                    public String getUserName() {
                        return ((ChatServerConnection)GameModule.getGameModule().getServer()).getUserInfo().getName();
                    }
                });
            }
            if (this.messageMgr != null) {
                this.messageMgr.setServer(server, name);
            }
        }
    }
}

