/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Plugin;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.properties.GlobalProperties;
import VASSAL.build.module.properties.GlobalProperty;
import VASSAL.build.module.properties.ZoneProperty;
import VASSAL.build.widget.CardSlot;
import VASSAL.build.widget.PieceSlot;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.EditContainedPiecesAction;
import VASSAL.configure.EditPropertiesAction;
import VASSAL.configure.PropertiesWindow;
import VASSAL.configure.ShowHelpAction;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.MassPieceLoader;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslateAction;
import VASSAL.launch.EditorWindow;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ReflectionUtils;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;

public class ConfigureTree
extends JTree
implements PropertyChangeListener,
MouseListener,
MouseMotionListener,
TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    protected Map<Configurable, DefaultMutableTreeNode> nodes = new HashMap<Configurable, DefaultMutableTreeNode>();
    protected DefaultMutableTreeNode copyData;
    protected DefaultMutableTreeNode cutData;
    protected HelpWindow helpWindow;
    protected EditorWindow editorWindow;
    protected Configurable selected;
    protected int selectedRow;
    protected String searchCmd;
    protected String moveCmd;
    protected String deleteCmd;
    protected String pasteCmd;
    protected String copyCmd;
    protected String cutCmd;
    protected String helpCmd;
    protected String propertiesCmd;
    protected String translateCmd;
    protected KeyStroke cutKey;
    protected KeyStroke copyKey;
    protected KeyStroke pasteKey;
    protected KeyStroke deleteKey;
    protected KeyStroke moveKey;
    protected KeyStroke searchKey;
    protected KeyStroke helpKey;
    protected KeyStroke propertiesKey;
    protected KeyStroke translateKey;
    protected Action cutAction;
    protected Action copyAction;
    protected Action pasteAction;
    protected Action deleteAction;
    protected Action moveAction;
    protected Action searchAction;
    protected Action propertiesAction;
    protected Action translateAction;
    protected Action helpAction;
    private final SearchParameters searchParameters;
    public static Font POPUP_MENU_FONT = new Font("Dialog", 0, 11);
    protected static List<AdditionalComponent> additionalComponents = new ArrayList<AdditionalComponent>();

    public ConfigureTree(Configurable root, HelpWindow helpWindow) {
        this(root, helpWindow, null);
    }

    public ConfigureTree(Configurable root, HelpWindow helpWindow, EditorWindow editorWindow) {
        this.toggleClickCount = 3;
        this.helpWindow = helpWindow;
        this.editorWindow = editorWindow;
        this.setShowsRootHandles(true);
        this.setModel(new DefaultTreeModel(this.buildTreeNode(root)));
        this.setCellRenderer(this.buildRenderer());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addTreeSelectionListener(this);
        this.searchCmd = Resources.getString("Editor.search");
        this.moveCmd = Resources.getString("Editor.move");
        this.deleteCmd = Resources.getString("Editor.delete");
        this.pasteCmd = Resources.getString("Editor.paste");
        this.copyCmd = Resources.getString("Editor.copy");
        this.cutCmd = Resources.getString("Editor.cut");
        this.propertiesCmd = Resources.getString("Editor.ModuleEditor.properties");
        this.translateCmd = Resources.getString("Editor.ModuleEditor.translate");
        this.helpCmd = Resources.getString("Editor.ModuleEditor.component_help");
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        this.cutKey = KeyStroke.getKeyStroke(88, mask);
        this.copyKey = KeyStroke.getKeyStroke(67, mask);
        this.pasteKey = KeyStroke.getKeyStroke(86, mask);
        this.deleteKey = KeyStroke.getKeyStroke(127, 0);
        this.moveKey = KeyStroke.getKeyStroke(77, mask);
        this.searchKey = KeyStroke.getKeyStroke(70, mask);
        this.propertiesKey = KeyStroke.getKeyStroke(80, mask);
        this.translateKey = KeyStroke.getKeyStroke(84, mask);
        this.helpKey = KeyStroke.getKeyStroke(112, 0);
        this.copyAction = new KeyAction(this.copyCmd, this.copyKey);
        this.pasteAction = new KeyAction(this.pasteCmd, this.pasteKey);
        this.cutAction = new KeyAction(this.cutCmd, this.cutKey);
        this.deleteAction = new KeyAction(this.deleteCmd, this.deleteKey);
        this.moveAction = new KeyAction(this.moveCmd, this.moveKey);
        this.searchAction = new KeyAction(this.searchCmd, this.searchKey);
        this.propertiesAction = new KeyAction(this.propertiesCmd, this.propertiesKey);
        this.translateAction = new KeyAction(this.translateCmd, this.translateKey);
        this.helpAction = new KeyAction(this.helpCmd, this.helpKey);
        this.getInputMap().put(this.cutKey, this.cutCmd);
        this.getInputMap().put(this.copyKey, this.copyCmd);
        this.getInputMap().put(this.pasteKey, this.pasteCmd);
        this.getInputMap().put(this.deleteKey, this.deleteCmd);
        this.getActionMap().put(this.cutCmd, this.cutAction);
        this.getActionMap().put(this.copyCmd, this.copyAction);
        this.getActionMap().put(this.pasteCmd, this.pasteAction);
        this.getActionMap().put(this.deleteCmd, this.deleteAction);
        this.getSelectionModel().setSelectionMode(1);
        this.searchParameters = new SearchParameters();
        TreePath path = new TreePath(((DefaultMutableTreeNode)this.getModel().getRoot()).getPath());
        this.setSelectionPath(path);
        this.scrollPathToVisible(path);
    }

    public JFrame getFrame() {
        return this.editorWindow;
    }

    protected Renderer buildRenderer() {
        return new Renderer();
    }

    protected void notifyStateChanged(boolean changed) {
        if (this.editorWindow != null) {
            this.editorWindow.treeStateChanged(changed);
        }
    }

    protected Configurable getTarget(int x, int y) {
        TreePath path = this.getPathForLocation(x, y);
        Configurable target = null;
        if (path != null) {
            target = (Configurable)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
        }
        return target;
    }

    protected DefaultMutableTreeNode buildTreeNode(Configurable c) {
        Configurable[] children;
        c.addPropertyChangeListener(this);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(c);
        for (Configurable child : children = c.getConfigureComponents()) {
            if (child instanceof Plugin) continue;
            node.add(this.buildTreeNode(child));
        }
        this.nodes.put(c, node);
        return node;
    }

    protected void addAction(JPopupMenu menu, Action a) {
        if (a != null) {
            menu.add(a).setFont(POPUP_MENU_FONT);
        }
    }

    private void addActionGroup(JPopupMenu menu, ArrayList<Action> l) {
        boolean empty = true;
        for (Action a : l) {
            if (a == null) continue;
            menu.add(a).setFont(POPUP_MENU_FONT);
            empty = false;
        }
        if (!empty) {
            menu.addSeparator();
        }
        l.clear();
    }

    protected JPopupMenu buildPopupMenu(Configurable target) {
        JPopupMenu popup = new JPopupMenu();
        ArrayList<Action> l = new ArrayList<Action>();
        l.add(this.buildEditAction(target));
        l.add(this.buildEditPiecesAction(target));
        this.addActionGroup(popup, l);
        l.add(this.buildTranslateAction(target));
        this.addActionGroup(popup, l);
        l.add(this.buildHelpAction(target));
        this.addActionGroup(popup, l);
        l.add(this.buildSearchAction(target));
        this.addActionGroup(popup, l);
        l.add(this.buildDeleteAction(target));
        l.add(this.buildCutAction(target));
        l.add(this.buildCopyAction(target));
        l.add(this.buildPasteAction(target));
        l.add(this.buildMoveAction(target));
        this.addActionGroup(popup, l);
        for (Action a : this.buildAddActionsFor(target)) {
            this.addAction(popup, a);
        }
        if (this.hasChild(target, PieceSlot.class) || this.hasChild(target, CardSlot.class)) {
            this.addAction(popup, this.buildMassPieceLoaderAction(target));
        }
        this.addAction(popup, this.buildImportAction(target));
        return popup;
    }

    private List<DefaultMutableTreeNode> getSearchNodes(DefaultMutableTreeNode root) {
        ArrayList<DefaultMutableTreeNode> searchNodes = new ArrayList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> e = root.preorderEnumeration();
        while (e.hasMoreElements()) {
            searchNodes.add((DefaultMutableTreeNode)e.nextElement());
        }
        return searchNodes;
    }

    protected Action buildSearchAction(Configurable target) {
        SearchAction a = new SearchAction(this, this.searchParameters, GameModule.getGameModule().getChatter());
        a.setEnabled(true);
        return a;
    }

    protected Action buildMoveAction(final Configurable target) {
        AbstractAction a = null;
        if (this.getTreeNode(target).getParent() != null) {
            a = new AbstractAction(this.moveCmd){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    final JDialog d = new JDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, ConfigureTree.this), true);
                    d.setTitle((String)(target.getConfigureName() == null ? ConfigureTree.this.moveCmd : ConfigureTree.this.moveCmd + " " + target.getConfigureName()));
                    d.setLayout(new BoxLayout(d.getContentPane(), 1));
                    Box box = Box.createHorizontalBox();
                    box.add(new JLabel("Move to position"));
                    box.add(Box.createHorizontalStrut(10));
                    final JComboBox<CallSite> select = new JComboBox<CallSite>();
                    TreeNode parentNode = ConfigureTree.this.getTreeNode(target).getParent();
                    for (int i = 0; i < parentNode.getChildCount(); ++i) {
                        Configurable c = (Configurable)((DefaultMutableTreeNode)parentNode.getChildAt(i)).getUserObject();
                        String name = (c.getConfigureName() != null ? c.getConfigureName() : "") + " [" + ConfigureTree.getConfigureName(c.getClass()) + "]";
                        select.addItem((CallSite)((Object)(i + 1 + ":  " + name)));
                    }
                    final DefaultMutableTreeNode targetNode = ConfigureTree.this.getTreeNode(target);
                    final int currentIndex = targetNode.getParent().getIndex(targetNode);
                    select.setSelectedIndex(currentIndex);
                    box.add(select);
                    JButton ok = new JButton(Resources.getString("General.ok"));
                    ok.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Configurable parent;
                            int index = select.getSelectedIndex();
                            if (currentIndex != index && ConfigureTree.this.remove(parent = ConfigureTree.this.getParent(targetNode), target)) {
                                ConfigureTree.this.insert(parent, target, index);
                            }
                            d.dispose();
                        }
                    });
                    d.add(box);
                    d.add(ok);
                    d.pack();
                    d.setLocationRelativeTo(d.getParent());
                    d.setVisible(true);
                }
            };
        }
        return a;
    }

    protected Action buildCutAction(final Configurable target) {
        AbstractAction a = null;
        if (this.getTreeNode(target).getParent() != null) {
            a = new AbstractAction(this.cutCmd){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigureTree.this.cutData = ConfigureTree.this.getTreeNode(target);
                    ConfigureTree.this.copyData = null;
                    ConfigureTree.this.updateEditMenu();
                }
            };
        }
        return a;
    }

    protected Action buildCopyAction(final Configurable target) {
        AbstractAction a = null;
        if (this.getTreeNode(target).getParent() != null) {
            a = new AbstractAction(this.copyCmd){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConfigureTree.this.copyData = ConfigureTree.this.getTreeNode(target);
                    ConfigureTree.this.cutData = null;
                    ConfigureTree.this.updateEditMenu();
                }
            };
        }
        return a;
    }

    protected Action buildPasteAction(final Configurable target) {
        AbstractAction a = new AbstractAction(this.pasteCmd){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigureTree.this.cutData != null) {
                    DefaultMutableTreeNode targetNode = ConfigureTree.this.getTreeNode(target);
                    Configurable cutObj = (Configurable)ConfigureTree.this.cutData.getUserObject();
                    Configurable convertedCutObj = ConfigureTree.this.convertChild(target, cutObj);
                    if (ConfigureTree.this.remove(ConfigureTree.this.getParent(ConfigureTree.this.cutData), cutObj)) {
                        ConfigureTree.this.insert(target, convertedCutObj, targetNode.getChildCount());
                    }
                    ConfigureTree.this.copyData = ConfigureTree.this.getTreeNode(convertedCutObj);
                } else if (ConfigureTree.this.copyData != null) {
                    Configurable copyBase = (Configurable)ConfigureTree.this.copyData.getUserObject();
                    Buildable clone = null;
                    try {
                        clone = ConfigureTree.this.convertChild(target, (Configurable)copyBase.getClass().getConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    catch (Throwable t) {
                        ReflectionUtils.handleNewInstanceFailure(t, copyBase.getClass());
                    }
                    if (clone != null) {
                        clone.build(copyBase.getBuildElement(Builder.createNewDocument()));
                        ConfigureTree.this.insert(target, (Configurable)clone, ConfigureTree.this.getTreeNode(target).getChildCount());
                        ConfigureTree.this.updateGpIds((Configurable)clone);
                    }
                }
                ConfigureTree.this.cutData = null;
                ConfigureTree.this.updateEditMenu();
            }
        };
        a.setEnabled(this.isValidPasteTarget(target));
        return a;
    }

    protected boolean isValidPasteTarget(Configurable target) {
        return this.cutData != null && this.isValidParent(target, (Configurable)this.cutData.getUserObject()) || this.copyData != null && this.isValidParent(target, (Configurable)this.copyData.getUserObject());
    }

    protected Configurable convertChild(Configurable parent, Configurable child) {
        if (child.getClass() == PieceSlot.class && this.isAllowedChildClass(parent, CardSlot.class)) {
            return new CardSlot((PieceSlot)child);
        }
        if (child.getClass() == CardSlot.class && this.isAllowedChildClass(parent, PieceSlot.class)) {
            return new PieceSlot((CardSlot)child);
        }
        return child;
    }

    protected boolean isAllowedChildClass(Configurable parent, Class<?> childClass) {
        Class[] allowableClasses;
        for (Class allowableClass : allowableClasses = parent.getAllowableConfigureComponents()) {
            if (allowableClass != childClass) continue;
            return true;
        }
        return false;
    }

    public void updateGpIds(Configurable c) {
        if (c instanceof PieceSlot) {
            ((PieceSlot)c).updateGpId(GameModule.getGameModule());
        } else {
            for (Configurable comp : c.getConfigureComponents()) {
                this.updateGpIds(comp);
            }
        }
    }

    protected Action buildImportAction(final Configurable target) {
        AbstractAction a = new AbstractAction("Add Imported Class"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                final Configurable child = ConfigureTree.this.importConfigurable();
                if (child != null) {
                    try {
                        child.build(null);
                        final Configurable c = target;
                        if (child.getConfigurer() != null) {
                            PropertiesWindow w = new PropertiesWindow((Frame)SwingUtilities.getAncestorOfClass(Frame.class, ConfigureTree.this), false, child, ConfigureTree.this.helpWindow){
                                private static final long serialVersionUID = 1L;

                                @Override
                                public void save() {
                                    super.save();
                                    ConfigureTree.this.insert(c, child, ConfigureTree.this.getTreeNode(c).getChildCount());
                                }

                                @Override
                                public void cancel() {
                                    this.dispose();
                                }
                            };
                            w.setVisible(true);
                        } else {
                            ConfigureTree.this.insert(c, child, ConfigureTree.this.getTreeNode(c).getChildCount());
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(ConfigureTree.this.getTopLevelAncestor(), "Error adding " + ConfigureTree.getConfigureName(child) + " to " + ConfigureTree.getConfigureName(target) + "\n" + ex.getMessage(), "Illegal configuration", 0);
                    }
                }
            }
        };
        return a;
    }

    protected Action buildMassPieceLoaderAction(final Configurable target) {
        AbstractAction a = null;
        final ConfigureTree tree = this;
        if (this.getTreeNode(target).getParent() != null) {
            String desc = "Add Multiple " + (this.hasChild(target, CardSlot.class) ? "Cards" : "Pieces");
            a = new AbstractAction(desc){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    new MassPieceLoader(tree, target).load();
                }
            };
        }
        return a;
    }

    protected boolean hasChild(Configurable parent, Class<?> childClass) {
        for (Class c : parent.getAllowableConfigureComponents()) {
            if (!c.equals(childClass)) continue;
            return true;
        }
        return false;
    }

    protected List<Action> buildAddActionsFor(Configurable target) {
        ArrayList<Action> l = new ArrayList<Action>();
        for (Class newConfig : target.getAllowableConfigureComponents()) {
            l.add(this.buildAddAction(target, newConfig));
        }
        for (AdditionalComponent add : additionalComponents) {
            if (!target.getClass().equals(add.getParent())) continue;
            Class<? extends Buildable> newConfig = add.getChild();
            l.add(this.buildAddAction(target, newConfig));
        }
        return l;
    }

    @Deprecated
    protected Enumeration<Action> buildAddActions(Configurable target) {
        return Collections.enumeration(this.buildAddActionsFor(target));
    }

    protected Action buildAddAction(final Configurable target, final Class<? extends Buildable> newConfig) {
        AbstractAction action = new AbstractAction("Add " + ConfigureTree.getConfigureName(newConfig)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                Configurable ch = null;
                try {
                    ch = (Configurable)newConfig.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    ReflectionUtils.handleNewInstanceFailure(t, newConfig);
                }
                if (ch != null) {
                    final Configurable child = ch;
                    child.build(null);
                    if (child instanceof PieceSlot) {
                        ((PieceSlot)child).updateGpId(GameModule.getGameModule());
                    }
                    final Configurable c = target;
                    if (child.getConfigurer() != null) {
                        if (ConfigureTree.this.insert(target, child, ConfigureTree.this.getTreeNode(target).getChildCount())) {
                            PropertiesWindow w = new PropertiesWindow((Frame)SwingUtilities.getAncestorOfClass(Frame.class, ConfigureTree.this), false, child, ConfigureTree.this.helpWindow){
                                private static final long serialVersionUID = 1L;

                                @Override
                                public void save() {
                                    super.save();
                                }

                                @Override
                                public void cancel() {
                                    ConfigureTree.this.remove(c, child);
                                    this.dispose();
                                }
                            };
                            w.setVisible(true);
                        }
                    } else {
                        ConfigureTree.this.insert(c, child, ConfigureTree.this.getTreeNode(c).getChildCount());
                    }
                }
            }
        };
        return action;
    }

    protected Action buildHelpAction(Configurable target) {
        ShowHelpAction showHelp;
        HelpFile helpFile = target.getHelpFile();
        if (helpFile == null) {
            showHelp = new ShowHelpAction(null, null);
            showHelp.setEnabled(false);
        } else {
            showHelp = new ShowHelpAction(helpFile.getContents(), null);
        }
        return showHelp;
    }

    protected Action buildCloneAction(final Configurable target) {
        final DefaultMutableTreeNode targetNode = this.getTreeNode(target);
        if (targetNode.getParent() != null) {
            return new AbstractAction("Clone"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Configurable clone = null;
                    try {
                        clone = (Configurable)target.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Throwable t) {
                        ReflectionUtils.handleNewInstanceFailure(t, target.getClass());
                    }
                    if (clone != null) {
                        clone.build(target.getBuildElement(Builder.createNewDocument()));
                        ConfigureTree.this.insert(ConfigureTree.this.getParent(targetNode), clone, targetNode.getParent().getIndex(targetNode) + 1);
                    }
                }
            };
        }
        return null;
    }

    protected Configurable getParent(DefaultMutableTreeNode targetNode) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)targetNode.getParent();
        return parentNode == null ? null : (Configurable)parentNode.getUserObject();
    }

    protected Action buildDeleteAction(final Configurable target) {
        DefaultMutableTreeNode targetNode = this.getTreeNode(target);
        final Configurable parent = this.getParent(targetNode);
        if (targetNode.getParent() != null) {
            return new AbstractAction(this.deleteCmd){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int row = ConfigureTree.this.selectedRow;
                    ConfigureTree.this.remove(parent, target);
                    if (row < ConfigureTree.this.getRowCount()) {
                        ConfigureTree.this.setSelectionRow(row);
                    } else {
                        ConfigureTree.this.setSelectionRow(row - 1);
                    }
                }
            };
        }
        return null;
    }

    protected Action buildEditPiecesAction(Configurable target) {
        if (this.canContainGamePiece(target)) {
            return new EditContainedPiecesAction(target);
        }
        return null;
    }

    protected Action buildEditAction(Configurable target) {
        return new EditPropertiesAction(target, this.helpWindow, (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this), this);
    }

    protected Action buildTranslateAction(Configurable target) {
        TranslateAction a = new TranslateAction(target, this.helpWindow, this);
        a.setEnabled(target.getI18nData().isTranslatable());
        return a;
    }

    public boolean canContainGamePiece(Configurable target) {
        boolean canContainPiece = false;
        for (Class c : target.getAllowableConfigureComponents()) {
            if (!PieceSlot.class.isAssignableFrom(c)) continue;
            canContainPiece = true;
            break;
        }
        return canContainPiece;
    }

    protected boolean remove(Configurable parent, Configurable child) {
        try {
            child.removeFrom(parent);
            parent.remove(child);
            ((DefaultTreeModel)this.getModel()).removeNodeFromParent(this.getTreeNode(child));
            this.notifyStateChanged(true);
            return true;
        }
        catch (IllegalBuildException err) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Cannot delete " + ConfigureTree.getConfigureName(child) + " from " + ConfigureTree.getConfigureName(parent) + "\n" + err.getMessage(), "Illegal configuration", 0);
            return false;
        }
    }

    protected boolean insert(Configurable parent, Configurable child, int index) {
        Configurable theChild = child;
        if (parent.getClass() == GlobalProperties.class && child.getClass() == ZoneProperty.class) {
            theChild = new GlobalProperty((GlobalProperty)child);
        }
        if (parent.getClass() == Zone.class && child.getClass() == GlobalProperty.class) {
            theChild = new ZoneProperty((GlobalProperty)child);
        }
        DefaultMutableTreeNode childNode = this.buildTreeNode(theChild);
        DefaultMutableTreeNode parentNode = this.getTreeNode(parent);
        Configurable[] oldContents = parent.getConfigureComponents();
        boolean succeeded = true;
        ArrayList<Configurable> moveToBack = new ArrayList<Configurable>();
        for (int i = index; i < oldContents.length; ++i) {
            try {
                oldContents[i].removeFrom(parent);
                parent.remove(oldContents[i]);
            }
            catch (IllegalBuildException err) {
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Can't insert " + ConfigureTree.getConfigureName(theChild) + " before " + ConfigureTree.getConfigureName(oldContents[i]), "Illegal configuration", 0);
                for (int j = index; j < i; ++j) {
                    parent.add(oldContents[j]);
                    oldContents[j].addTo(parent);
                }
                return false;
            }
            moveToBack.add(oldContents[i]);
        }
        try {
            theChild.addTo(parent);
            parent.add(theChild);
            parentNode.insert(childNode, index);
            int[] childI = new int[]{index};
            ((DefaultTreeModel)this.getModel()).nodesWereInserted(parentNode, childI);
        }
        catch (IllegalBuildException err) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Can't add " + ConfigureTree.getConfigureName(child) + "\n" + err.getMessage(), "Illegal configuration", 0);
            succeeded = false;
        }
        for (Configurable c : moveToBack) {
            parent.add(c);
            c.addTo(parent);
        }
        this.notifyStateChanged(true);
        return succeeded;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        DefaultMutableTreeNode newValue = this.getTreeNode((Configurable)evt.getSource());
        ((DefaultTreeModel)this.getModel()).nodeChanged(newValue);
    }

    public static String getConfigureName(Class<?> c) {
        try {
            return (String)c.getMethod("getConfigureTypeName", new Class[0]).invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException e) {
            ErrorDialog.bug(e);
        }
        return c.getName().substring(c.getName().lastIndexOf(".") + 1);
    }

    public static String getConfigureName(Configurable c) {
        if (c.getConfigureName() != null && c.getConfigureName().length() > 0) {
            return c.getConfigureName();
        }
        return ConfigureTree.getConfigureName(c.getClass());
    }

    protected Configurable importConfigurable() {
        String className = JOptionPane.showInputDialog(this.getTopLevelAncestor(), (Object)"Enter fully-qualified name of Java class to import");
        if (className == null) {
            return null;
        }
        Object o = null;
        try {
            o = GameModule.getGameModule().getDataArchive().loadClass(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            ReflectionUtils.handleImportClassFailure(t, className);
        }
        if (o == null) {
            return null;
        }
        if (o instanceof Configurable) {
            return o;
        }
        ErrorDialog.show("Error.not_a_configurable", className);
        return null;
    }

    protected void maybePopup(MouseEvent e) {
        Configurable target = this.getTarget(e.getX(), e.getY());
        if (target == null) {
            return;
        }
        this.setSelectionRow(this.getClosestRowForLocation(e.getX(), e.getY()));
        JPopupMenu popup = this.buildPopupMenu(target);
        popup.show(this, e.getX(), e.getY());
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
                ConfigureTree.this.repaint();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                ConfigureTree.this.repaint();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.maybePopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.maybePopup(e);
        } else if (e.getClickCount() == 2 && SwingUtils.isMainMouseButtonDown(e)) {
            Action a;
            Configurable target = this.getTarget(e.getX(), e.getY());
            if (target == null) {
                return;
            }
            if (target.getConfigurer() != null && (a = this.buildEditAction(target)) != null) {
                a.actionPerformed(new ActionEvent(e.getSource(), 1001, "Edit"));
            }
        }
    }

    public DefaultMutableTreeNode getTreeNode(Configurable target) {
        return this.nodes.get(target);
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
    }

    protected boolean isValidParent(Configurable parent, Configurable child) {
        if (parent != null && child != null) {
            Class[] c;
            for (Class aClass : c = parent.getAllowableConfigureComponents()) {
                if (!aClass.isAssignableFrom(child.getClass()) && (aClass != CardSlot.class || child.getClass() != PieceSlot.class) && (aClass != ZoneProperty.class || child.getClass() != GlobalProperty.class)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void nodeUpdated(Configurable target) {
        DefaultMutableTreeNode node = this.getTreeNode(target);
        Configurable parent = this.getParent(node);
        if (this.remove(parent, target)) {
            this.insert(parent, target, 0);
        }
    }

    public void externalInsert(Configurable parent, Configurable child) {
        this.insert(parent, child, this.getTreeNode(parent).getChildCount());
    }

    public Action getHelpAction() {
        return this.helpAction;
    }

    public void populateEditMenu(EditorWindow ew) {
        MenuManager mm = MenuManager.getInstance();
        mm.addAction("Editor.delete", this.deleteAction);
        mm.addAction("Editor.cut", this.cutAction);
        mm.addAction("Editor.copy", this.copyAction);
        mm.addAction("Editor.paste", this.pasteAction);
        mm.addAction("Editor.move", this.moveAction);
        mm.addAction("Editor.search", this.searchAction);
        mm.addAction("Editor.ModuleEditor.properties", this.propertiesAction);
        mm.addAction("Editor.ModuleEditor.translate", this.translateAction);
        this.updateEditMenu();
    }

    protected void doKeyAction(String action) {
        DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (targetNode != null) {
            Configurable target = (Configurable)targetNode.getUserObject();
            Action a = null;
            if (this.cutCmd.equals(action)) {
                a = this.buildCutAction(target);
            } else if (this.copyCmd.equals(action)) {
                a = this.buildCopyAction(target);
            } else if (this.pasteCmd.equals(action) || action.equals(Character.valueOf(this.pasteKey.getKeyChar()))) {
                a = this.buildPasteAction(target);
            } else if (this.deleteCmd.equals(action)) {
                a = this.buildDeleteAction(target);
            } else if (this.moveCmd.equals(action)) {
                a = this.buildMoveAction(target);
            } else if (this.searchCmd.equals(action)) {
                a = this.buildSearchAction(target);
            } else if (this.propertiesCmd.equals(action)) {
                a = this.buildEditAction(target);
            } else if (this.translateCmd.equals(action)) {
                a = this.buildTranslateAction(target);
            } else if (this.helpCmd.equals(action)) {
                a = this.buildHelpAction(target);
            }
            if (a != null) {
                a.actionPerformed(null);
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.selected = null;
        TreePath path = e.getPath();
        if (path != null) {
            this.selected = (Configurable)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            this.selectedRow = this.getRowForPath(path);
            this.updateEditMenu();
        }
    }

    protected void updateEditMenu() {
        this.deleteAction.setEnabled(this.selected != null);
        this.cutAction.setEnabled(this.selected != null);
        this.copyAction.setEnabled(this.selected != null);
        this.pasteAction.setEnabled(this.selected != null && this.isValidPasteTarget(this.selected));
        this.moveAction.setEnabled(this.selected != null);
        this.searchAction.setEnabled(true);
        this.propertiesAction.setEnabled(this.selected != null && this.selected.getConfigurer() != null);
        this.translateAction.setEnabled(this.selected != null);
    }

    protected Configurable getParent(Configurable target) {
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.getTreeNode(target).getParent();
        return (Configurable)parentNode.getUserObject();
    }

    public String getSearchCmd() {
        return this.searchCmd;
    }

    public static void addAdditionalComponent(Class<? extends Buildable> parent, Class<? extends Buildable> child) {
        additionalComponents.add(new AdditionalComponent(parent, child));
    }

    static class Renderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        Renderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Configurable c;
            if (value instanceof DefaultMutableTreeNode && (c = (Configurable)((DefaultMutableTreeNode)value).getUserObject()) != null) {
                leaf = c.getAllowableConfigureComponents().length == 0;
                value = (c.getConfigureName() != null ? c.getConfigureName() : "") + " [" + ConfigureTree.getConfigureName(c.getClass()) + "]";
            }
            return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        }
    }

    class KeyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        protected String actionName;

        public KeyAction(String name, KeyStroke key) {
            super(name);
            this.actionName = name;
            this.putValue("AcceleratorKey", key);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigureTree.this.doKeyAction(this.actionName);
        }
    }

    private static class SearchParameters {
        public static final String SEARCH_STRING = "searchString";
        public static final String MATCH_CASE = "matchCase";
        public static final String MATCH_NAMES = "matchNames";
        public static final String MATCH_TYPES = "matchTypes";
        private String searchString;
        private boolean matchCase;
        private boolean matchNames;
        private boolean matchTypes;
        private static Prefs prefs;

        public SearchParameters() {
            prefs = GameModule.getGameModule().getPrefs();
            prefs.addOption(null, new StringConfigurer(SEARCH_STRING, null, ""));
            prefs.addOption(null, new BooleanConfigurer(MATCH_CASE, null, false));
            prefs.addOption(null, new BooleanConfigurer(MATCH_NAMES, null, true));
            prefs.addOption(null, new BooleanConfigurer(MATCH_TYPES, null, true));
            this.searchString = (String)prefs.getValue(SEARCH_STRING);
            this.matchCase = (Boolean)prefs.getValue(MATCH_CASE);
            this.matchNames = (Boolean)prefs.getValue(MATCH_NAMES);
            this.matchTypes = (Boolean)prefs.getValue(MATCH_TYPES);
        }

        public SearchParameters(String searchString, boolean matchCase, boolean matchNames, boolean matchTypes) {
            this.searchString = searchString;
            this.matchCase = matchCase;
            this.matchNames = matchNames;
            this.matchTypes = matchTypes;
        }

        public String getSearchString() {
            return this.searchString;
        }

        public void setSearchString(String searchString) {
            this.searchString = searchString;
            this.writePrefs();
        }

        public boolean isMatchCase() {
            return this.matchCase;
        }

        public void setMatchCase(boolean matchCase) {
            this.matchCase = matchCase;
            this.writePrefs();
        }

        public boolean isMatchNames() {
            return this.matchNames;
        }

        public void setMatchNames(boolean matchNames) {
            this.matchNames = matchNames;
            this.writePrefs();
        }

        public boolean isMatchTypes() {
            return this.matchTypes;
        }

        public void setMatchTypes(boolean matchTypes) {
            this.matchTypes = matchTypes;
            this.writePrefs();
        }

        public void setFrom(SearchParameters searchParameters) {
            this.searchString = searchParameters.getSearchString();
            this.matchCase = searchParameters.isMatchCase();
            this.matchNames = searchParameters.isMatchNames();
            this.matchTypes = searchParameters.isMatchTypes();
            this.writePrefs();
        }

        public void writePrefs() {
            if (prefs != null) {
                prefs.setValue(SEARCH_STRING, this.searchString);
                prefs.setValue(MATCH_CASE, this.matchCase);
                prefs.setValue(MATCH_NAMES, this.matchNames);
                prefs.setValue(MATCH_TYPES, this.matchTypes);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SearchParameters that = (SearchParameters)o;
            return this.isMatchCase() == that.isMatchCase() && this.isMatchNames() == that.isMatchNames() && this.isMatchTypes() == that.isMatchTypes() && this.getSearchString().equals(that.getSearchString());
        }

        public int hashCode() {
            return Objects.hash(this.getSearchString(), this.isMatchCase(), this.isMatchNames(), this.isMatchTypes());
        }
    }

    private static class SearchAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final ConfigureTree configureTree;
        private final SearchParameters searchParameters;
        private final Chatter chatter;

        public SearchAction(ConfigureTree configureTree, SearchParameters searchParameters, Chatter chatter) {
            super(configureTree.getSearchCmd());
            this.configureTree = configureTree;
            this.searchParameters = searchParameters;
            this.chatter = chatter;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JDialog d = new JDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.configureTree), true);
            d.setTitle(this.configureTree.getSearchCmd());
            JLabel searchLabel = new JLabel("String to find: ");
            final JTextField search = new JTextField(this.searchParameters.getSearchString(), 32);
            search.select(0, this.searchParameters.getSearchString().length());
            searchLabel.setLabelFor(search);
            final JCheckBox sensitive = new JCheckBox(Resources.getString("Editor.search_case"), this.searchParameters.isMatchCase());
            final JCheckBox names = new JCheckBox(Resources.getString("Editor.search_names"), this.searchParameters.isMatchNames());
            final JCheckBox types = new JCheckBox(Resources.getString("Editor.search_types"), this.searchParameters.isMatchTypes());
            JButton find = new JButton(Resources.getString("Editor.search_next"));
            find.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean anyChanges;
                    SearchParameters parametersSetInDialog = new SearchParameters(search.getText(), sensitive.isSelected(), names.isSelected(), types.isSelected());
                    boolean bl = anyChanges = !searchParameters.equals(parametersSetInDialog);
                    if (anyChanges) {
                        searchParameters.setFrom(parametersSetInDialog);
                    }
                    if (!searchParameters.isMatchNames() && !searchParameters.isMatchTypes()) {
                        searchParameters.setMatchNames(true);
                        names.setSelected(true);
                        this.chat(Resources.getString("Editor.search_all_off"));
                    }
                    if (!searchParameters.getSearchString().isEmpty()) {
                        DefaultMutableTreeNode node;
                        if (anyChanges) {
                            int matches = this.getNumMatches(searchParameters.getSearchString());
                            this.chat(matches + " " + Resources.getString("Editor.search_count") + searchParameters.getSearchString());
                        }
                        if ((node = this.findNode(searchParameters.getSearchString())) != null) {
                            TreePath path = new TreePath(node.getPath());
                            configureTree.setSelectionPath(path);
                            configureTree.scrollPathToVisible(path);
                        } else {
                            this.chat(Resources.getString("Editor.search_none_found") + searchParameters.getSearchString());
                        }
                    }
                }
            });
            JButton cancel = new JButton(Resources.getString("General.cancel"));
            cancel.addActionListener(e1 -> d.dispose());
            d.setLayout((LayoutManager)new MigLayout("insets dialog, nogrid", "", "[]unrel[]unrel:push[]"));
            d.add((Component)searchLabel, "align right, gapx rel");
            d.add((Component)search, "pushx, growx, wrap");
            d.add((Component)sensitive, "align center, gapx unrel, span");
            d.add((Component)names, "gapx unrel");
            d.add((Component)types, "wrap");
            d.add((Component)find, "tag ok, split");
            d.add((Component)cancel, "tag cancel");
            d.getRootPane().setDefaultButton(find);
            KeyStroke k = KeyStroke.getKeyStroke(27, 0);
            int w = 2;
            d.getRootPane().registerKeyboardAction(ee -> d.dispose(), k, w);
            search.requestFocus();
            d.pack();
            d.setLocationRelativeTo(d.getParent());
            d.setVisible(true);
        }

        private DefaultMutableTreeNode findNode(String searchString) {
            List<DefaultMutableTreeNode> searchNodes = this.configureTree.getSearchNodes((DefaultMutableTreeNode)this.configureTree.getModel().getRoot());
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)this.configureTree.getLastSelectedPathComponent();
            int bookmark = -1;
            if (currentNode != null) {
                bookmark = IntStream.range(0, searchNodes.size()).filter(i -> searchNodes.get(i) == currentNode).findFirst().orElse(-1);
            }
            Predicate<DefaultMutableTreeNode> nodeMatchesSearchString = node -> this.checkNode((DefaultMutableTreeNode)node, searchString);
            DefaultMutableTreeNode foundNode = searchNodes.stream().skip(bookmark + 1).filter(nodeMatchesSearchString).findFirst().orElse(null);
            if (foundNode != null) {
                return foundNode;
            }
            return searchNodes.stream().limit(bookmark).filter(nodeMatchesSearchString).findFirst().orElse(null);
        }

        private int getNumMatches(String searchString) {
            List<DefaultMutableTreeNode> searchNodes = this.configureTree.getSearchNodes((DefaultMutableTreeNode)this.configureTree.getModel().getRoot());
            return (int)searchNodes.stream().filter(node -> this.checkNode((DefaultMutableTreeNode)node, searchString)).count();
        }

        private boolean checkNode(DefaultMutableTreeNode node, String searchString) {
            String className;
            String objectName;
            Configurable c = (Configurable)node.getUserObject();
            if (this.searchParameters.isMatchNames() && (objectName = c.getConfigureName()) != null && this.checkString(objectName, searchString)) {
                return true;
            }
            return this.searchParameters.isMatchTypes() && (className = ConfigureTree.getConfigureName(c.getClass())) != null && this.checkString(className, searchString);
        }

        private boolean checkString(String target, String searchString) {
            if (this.searchParameters.isMatchCase()) {
                return target.contains(searchString);
            }
            return target.toLowerCase().contains(searchString.toLowerCase());
        }

        private void chat(String text) {
            if (this.chatter != null) {
                this.chatter.show("- " + text);
            }
        }
    }

    protected static class AdditionalComponent {
        Class<? extends Buildable> parent;
        Class<? extends Buildable> child;

        public AdditionalComponent(Class<? extends Buildable> p, Class<? extends Buildable> c) {
            this.parent = p;
            this.child = c;
        }

        public Class<? extends Buildable> getParent() {
            return this.parent;
        }

        public Class<? extends Buildable> getChild() {
            return this.child;
        }
    }

    public static interface Mutable {
    }
}

