/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.tools.SequenceEncoder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public abstract class ListConfigurer
extends Configurer
implements PropertyChangeListener {
    protected Box controls;
    protected Box configControls;
    protected JPanel panel;
    protected Dimension fixedSize;
    protected List<Configurer> configurers = new ArrayList<Configurer>();

    public ListConfigurer(String key, String name) {
        super(key, name, new ArrayList());
    }

    public ListConfigurer(String key, String name, List<?> val) {
        super(key, name, val);
    }

    @Override
    public String getValueString() {
        if (this.getListValue().isEmpty()) {
            return "";
        }
        Configurer c = this.buildChildConfigurer();
        SequenceEncoder se = new SequenceEncoder(',');
        for (Object value : this.getListValue()) {
            c.setValue(value);
            se.append(c.getValueString());
        }
        return se.getValue();
    }

    @Override
    public void setValue(String s) {
        this.getListValue().clear();
        if (s.length() > 0) {
            Configurer c = this.buildChildConfigurer();
            SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ',');
            while (sd.hasMoreTokens()) {
                c.setValue(sd.nextToken());
                this.getListValue().add(c.getValue());
            }
        }
        this.updateControls();
    }

    protected void updateValue() {
        this.noUpdate = true;
        ArrayList<Object> newArray = new ArrayList<Object>();
        for (Configurer c : this.configurers) {
            newArray.add(c.getValue());
        }
        this.setValue(newArray);
        this.noUpdate = false;
    }

    @Override
    public void setValue(Object o) {
        if (o == null) {
            o = new ArrayList();
        }
        super.setValue(o);
        if (!this.noUpdate) {
            this.updateControls();
        }
    }

    @Override
    public Component getControls() {
        if (this.panel == null) {
            this.panel = new JPanel(new BorderLayout());
            this.controls = Box.createVerticalBox();
            JScrollPane scroll = new JScrollPane(this.controls);
            this.controls.setBorder(BorderFactory.createTitledBorder(this.getName()));
            this.configControls = Box.createVerticalBox();
            JButton addButton = new JButton("New");
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Configurer c = ListConfigurer.this.buildChildConfigurer();
                    ListConfigurer.this.getListValue().add(c.getValue());
                    ListConfigurer.this.updateControls();
                }
            });
            this.controls.add(addButton);
            this.controls.add(this.configControls);
            this.panel.add((Component)scroll, "Center");
            this.updateControls();
        }
        return this.panel;
    }

    public List<Object> getListValue() {
        return (List)this.getValue();
    }

    protected abstract Configurer buildChildConfigurer();

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.updateValue();
    }

    protected void updateControls() {
        if (this.controls != null) {
            for (Configurer c : this.configurers) {
                c.removePropertyChangeListener(this);
            }
            this.configurers.clear();
            this.configControls.removeAll();
            for (Object value : this.getListValue()) {
                final Configurer c = this.buildChildConfigurer();
                c.setValue(value);
                c.addPropertyChangeListener(this);
                this.configurers.add(c);
                Box b = Box.createHorizontalBox();
                JButton delButton = new JButton("Remove");
                delButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ListConfigurer.this.getListValue().remove(c.getValue());
                        ListConfigurer.this.updateControls();
                        ListConfigurer.this.repack();
                    }
                });
                b.add(delButton);
                b.add(c.getControls());
                this.configControls.add(b);
                if (this.configurers.size() > 5) {
                    if (this.fixedSize == null) {
                        this.fixedSize = new Dimension(this.panel.getPreferredSize().width + 20, 210);
                    }
                    this.panel.setPreferredSize(this.fixedSize);
                    continue;
                }
                this.panel.setPreferredSize(null);
            }
            this.repack();
        }
    }

    public void repack() {
        Window w = SwingUtilities.getWindowAncestor(this.controls);
        if (w != null) {
            w.pack();
        }
    }

    public int hashCode() {
        String valueString = this.getValueString();
        int prime = 31;
        int result = 1;
        result = 31 * result + (valueString == null ? 0 : valueString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListConfigurer other = (ListConfigurer)obj;
        String valueString = this.getValueString();
        String otherValueString = other.getValueString();
        return !(valueString == null ? otherValueString != null : !valueString.equals(otherValueString));
    }
}

