/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.ImportMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.i18n.Resources;
import VASSAL.launch.AbstractLaunchAction;
import VASSAL.launch.BasicModule;
import VASSAL.launch.CreateModuleAction;
import VASSAL.launch.EditExtensionAction;
import VASSAL.launch.EditModuleAction;
import VASSAL.launch.EditorWindow;
import VASSAL.launch.LaunchRequest;
import VASSAL.launch.Launcher;
import VASSAL.launch.ModuleManagerWindow;
import VASSAL.launch.NewExtensionAction;
import VASSAL.launch.PlayerWindow;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ThrowableUtils;
import VASSAL.tools.WarningDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.imports.ImportAction;
import VASSAL.tools.menu.MacOSXMenuManager;
import VASSAL.tools.menu.MenuBarProxy;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.version.VersionUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Editor
extends Launcher {
    private static final Logger logger = LoggerFactory.getLogger(Editor.class);

    public static void main(String[] args) {
        new Editor(args);
    }

    protected Editor(String[] args) {
        super(args);
    }

    @Override
    protected MenuManager createMenuManager() {
        return SystemUtils.IS_OS_MAC_OSX ? new MacOSXMenuManager() : new EditorMenuManager();
    }

    @Override
    protected void launch() throws IOException {
        AbstractLaunchAction.LaunchRequestMessage msg = null;
        switch (this.lr.mode) {
            case EDIT: {
                new EditModuleAction(this.lr.module).loadModule(this.lr.module);
                msg = new AbstractLaunchAction.NotifyOpenModuleOk(this.lr);
                break;
            }
            case IMPORT: {
                new ImportAction(null).loadModule(this.lr.importFile);
                msg = new AbstractLaunchAction.NotifyImportModuleOk(this.lr);
                break;
            }
            case NEW: {
                new CreateModuleAction(null).performAction(null);
                msg = new AbstractLaunchAction.NotifyNewModuleOk(this.lr);
                break;
            }
            case EDIT_EXT: {
                GameModule.init(new BasicModule(new DataArchive(this.lr.module.getPath())));
                GameModule.getGameModule().getPlayerWindow().setVisible(true);
                new EditExtensionAction(this.lr.extension).performAction(null);
                msg = new AbstractLaunchAction.NotifyOpenModuleOk(this.lr);
                break;
            }
            case NEW_EXT: {
                GameModule.init(new BasicModule(new DataArchive(this.lr.module.getPath())));
                PlayerWindow f = GameModule.getGameModule().getPlayerWindow();
                f.setVisible(true);
                new NewExtensionAction(f).performAction(null);
                msg = new AbstractLaunchAction.NotifyOpenModuleOk(this.lr);
            }
        }
        if (this.ipc != null) {
            try {
                this.ipc.send(msg);
            }
            catch (IOException e) {
                ErrorDialog.showDetails(e, ThrowableUtils.getStackTrace(e), "Error.socket_error", new Object[0]);
            }
        }
    }

    private static class EditorMenuManager
    extends MenuManager {
        private final MenuBarProxy editorBar = new MenuBarProxy();
        private final MenuBarProxy playerBar = new MenuBarProxy();

        private EditorMenuManager() {
        }

        @Override
        public JMenuBar getMenuBarFor(JFrame fc) {
            if (fc instanceof PlayerWindow) {
                return this.playerBar.createPeer();
            }
            if (fc instanceof EditorWindow) {
                return this.editorBar.createPeer();
            }
            return null;
        }

        @Override
        public MenuBarProxy getMenuBarProxyFor(JFrame fc) {
            if (fc instanceof PlayerWindow) {
                return this.playerBar;
            }
            if (fc instanceof EditorWindow) {
                return this.editorBar;
            }
            return null;
        }
    }

    public static class PromptLaunchAction
    extends LaunchAction {
        private static final long serialVersionUID = 1L;

        public PromptLaunchAction(ModuleManagerWindow mm) {
            super(mm, null);
            this.putValue("Name", Resources.getString("Main.edit_module"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.promptForFile() == null) {
                return;
            }
            super.actionPerformed(e);
        }
    }

    public static class ListLaunchAction
    extends LaunchAction {
        private static final long serialVersionUID = 1L;

        public ListLaunchAction(ModuleManagerWindow mm, File module) {
            super(mm, module);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            this.setEnabled(false);
        }
    }

    public static class LaunchAction
    extends AbstractLaunchAction {
        private static final long serialVersionUID = 1L;

        public LaunchAction(ModuleManagerWindow mm, File module) {
            super(Resources.getString("Main.edit_module_specific"), mm, Editor.class.getName(), new LaunchRequest(LaunchRequest.Mode.EDIT, module));
            this.setEnabled(!editing.contains(module) && !using.containsKey(module));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractMetaData data = MetaDataFactory.buildMetaData(this.lr.module);
            if (data != null) {
                ModuleMetaData md;
                String vv = data.getVassalVersion();
                if (Info.isModuleTooNew(vv)) {
                    ErrorDialog.show("Error.module_too_new", this.lr.module.getPath(), vv, Info.getVersion());
                    return;
                }
                if (data instanceof ModuleMetaData && VersionUtils.compareVersions((md = (ModuleMetaData)data).getVassalVersion(), "3.3.0") < 0) {
                    if ("VASL".equals(md.getName())) {
                        ErrorDialog.show("Error.VASL_too_old", Info.getVersion());
                        return;
                    }
                    if ("VSQL".equals(md.getName())) {
                        ErrorDialog.show("Error.VSQL_too_old", Info.getVersion());
                        return;
                    }
                }
                if (Info.hasOldFormat(vv)) {
                    WarningDialog.show("Warning.module_will_be_updated", this.lr.module.getPath(), Info.getVersion(), "3.2");
                }
            }
            if (editing.contains(this.lr.module) || using.containsKey(this.lr.module)) {
                return;
            }
            editing.add(this.lr.module);
            super.actionPerformed(e);
        }

        @Override
        protected AbstractLaunchAction.LaunchTask getLaunchTask() {
            return new AbstractLaunchAction.LaunchTask(){

                @Override
                protected void done() {
                    super.done();
                    AbstractLaunchAction.editing.remove(this.lr.module);
                    this.setEnabled(true);
                }
            };
        }
    }

    public static class PromptImportLaunchAction
    extends ImportLaunchAction {
        private static final long serialVersionUID = 1L;

        public PromptImportLaunchAction(ModuleManagerWindow mm) {
            super(mm, null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.promptForFile() == null) {
                return;
            }
            super.actionPerformed(e);
        }

        @Override
        protected File promptForFile() {
            FileChooser fc = ImportAction.getFileChooser(this.window);
            if (fc.showOpenDialog() == 0) {
                this.lr.importFile = fc.getSelectedFile();
                if (this.lr.importFile != null) {
                    if (this.lr.importFile.exists()) {
                        AbstractMetaData metadata = MetaDataFactory.buildMetaData(this.lr.importFile);
                        if (metadata == null || !(metadata instanceof ImportMetaData)) {
                            ErrorDialog.show("Error.invalid_import_file", this.lr.importFile.getAbsolutePath());
                            logger.error("Import of " + this.lr.importFile.getAbsolutePath() + " failed: unrecognized import type");
                            this.lr.importFile = null;
                        }
                    } else {
                        this.lr.importFile = null;
                    }
                }
            }
            return this.lr.importFile;
        }
    }

    public static class ImportLaunchAction
    extends AbstractLaunchAction {
        private static final long serialVersionUID = 1L;

        public ImportLaunchAction(ModuleManagerWindow mm, File module) {
            super(Resources.getString("Main.import_module"), mm, Editor.class.getName(), new LaunchRequest(LaunchRequest.Mode.IMPORT, module));
        }

        @Override
        protected AbstractLaunchAction.LaunchTask getLaunchTask() {
            return new AbstractLaunchAction.LaunchTask(this);
        }
    }

    public static class NewModuleLaunchAction
    extends AbstractLaunchAction {
        private static final long serialVersionUID = 1L;

        public NewModuleLaunchAction(ModuleManagerWindow mm) {
            super(Resources.getString("Main.new_module"), mm, Editor.class.getName(), new LaunchRequest(LaunchRequest.Mode.NEW));
        }

        @Override
        protected AbstractLaunchAction.LaunchTask getLaunchTask() {
            return new AbstractLaunchAction.LaunchTask(this);
        }
    }
}

