/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.tools.concurrent.listener.EventListener;

class TileProgressPumpStateMachine {
    protected final EventListener<String> nameListener;
    protected final EventListener<Integer> progListener;
    public static final int INIT = 0;
    public static final int NAME = 1;
    public static final int NAME_LF = 2;
    public static final int DOTS = 3;
    public static final int DOTS_LF = 4;
    public static final int DONE = 5;

    public TileProgressPumpStateMachine(EventListener<String> nameListener, EventListener<Integer> progListener) {
        this.nameListener = nameListener;
        this.progListener = progListener;
    }

    protected void appendName(StringBuilder sb, byte[] buf, int beg, int end) {
        sb.append(new String(buf, beg, end - beg));
    }

    protected boolean hasName(StringBuilder sb) {
        return sb.length() > 0;
    }

    protected void sendName(StringBuilder sb) {
        this.nameListener.receive(this, sb.toString());
        sb.setLength(0);
    }

    protected void sendProgress(int prog) {
        this.progListener.receive(this, prog);
    }

    protected int[] runName(byte[] buf, int beg, int end, StringBuilder sb) {
        for (int pos = beg; pos < end; ++pos) {
            if (buf[pos] != 13 && buf[pos] != 10) continue;
            if (pos == beg && !this.hasName(sb)) {
                return new int[]{5, end};
            }
            this.appendName(sb, buf, beg, pos);
            this.sendName(sb);
            if (buf[pos] == 13) {
                return new int[]{2, pos + 1};
            }
            return new int[]{3, pos + 1};
        }
        this.appendName(sb, buf, beg, end);
        return new int[]{1, end};
    }

    protected int[] runNameLF(byte[] buf, int beg, int end, StringBuilder sb) {
        switch (buf[beg]) {
            case 10: {
                return new int[]{3, beg + 1};
            }
        }
        throw new IllegalStateException("found '" + buf[beg] + "', expecting '\\n'");
    }

    protected int[] runDots(byte[] buf, int beg, int end, StringBuilder sb) {
        block4: for (int pos = beg; pos < end; ++pos) {
            switch (buf[pos]) {
                case 10: 
                case 13: {
                    this.sendProgress(pos - beg);
                    if (buf[pos] == 13) {
                        return new int[]{4, pos + 1};
                    }
                    return new int[]{1, pos + 1};
                }
                case 46: {
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("found '" + buf[pos] + "', expecting '.'");
                }
            }
        }
        this.sendProgress(end - beg);
        return new int[]{3, end};
    }

    protected int[] runDotsLF(byte[] buf, int beg, int end, StringBuilder sb) {
        switch (buf[beg]) {
            case 10: {
                return new int[]{1, beg + 1};
            }
        }
        throw new IllegalStateException("found '" + buf[beg] + "', expecting '\\n'");
    }

    public int run(int state, byte[] buf, int beg, int end, StringBuilder sb) {
        if (state == 5) {
            throw new IllegalArgumentException("DONE is terminal");
        }
        if (state == 0) {
            state = 1;
        }
        while (beg < end) {
            int[] result;
            switch (state) {
                case 1: {
                    result = this.runName(buf, beg, end, sb);
                    break;
                }
                case 2: {
                    result = this.runNameLF(buf, beg, end, sb);
                    break;
                }
                case 3: {
                    result = this.runDots(buf, beg, end, sb);
                    break;
                }
                case 4: {
                    result = this.runDotsLF(buf, beg, end, sb);
                    break;
                }
                default: {
                    throw new IllegalStateException("state == " + state);
                }
            }
            state = result[0];
            beg = result[1];
        }
        return state;
    }
}

