/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.preferences;

import VASSAL.build.BadDataReport;
import VASSAL.configure.Configurer;
import VASSAL.tools.ErrorDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.StringTokenizer;

public class PositionOption
extends Configurer
implements ComponentListener {
    public static String key = "BoundsOf";
    private static Point initialPos = new Point(0, 0);
    protected Window theFrame;
    protected Rectangle bounds;
    protected Rectangle defaultValue;
    protected Rectangle previousBounds;

    public PositionOption(String key, Window f, Rectangle defaultValue) {
        super(key, null, defaultValue);
        PositionOption.adjustInitialOffset();
        this.theFrame = f;
        this.theFrame.pack();
        this.setFrameBounds();
        this.defaultValue = defaultValue;
        this.theFrame.addComponentListener(this);
    }

    private static void adjustInitialOffset() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        if (PositionOption.initialPos.x >= d.width - 30 || PositionOption.initialPos.y >= d.height - 30) {
            initialPos.move(0, 0);
        } else {
            initialPos.translate(30, 30);
        }
    }

    public PositionOption(String key, Window f) {
        this(key, f, new Rectangle(initialPos, new Dimension(0, 0)));
    }

    @Override
    public Object getValue() {
        return this.bounds;
    }

    @Override
    public void setValue(Object o) {
        if (o instanceof Rectangle) {
            this.bounds = new Rectangle((Rectangle)o);
            if (this.theFrame != null) {
                this.setFrameBounds();
            }
        }
        super.setValue(o);
    }

    @Override
    public Component getControls() {
        return null;
    }

    @Override
    public void setValue(String in) {
        StringTokenizer st = new StringTokenizer(in, ",");
        try {
            this.setValue(new Rectangle(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken())));
        }
        catch (NumberFormatException e) {
            if (in.indexOf(9) > 0) {
                ErrorDialog.dataError(new BadDataReport("Map or Chart window with same name as piece Palette", this.getKey(), e));
            }
            ErrorDialog.bug(e);
        }
    }

    @Override
    public String getValueString() {
        return this.bounds.x + "," + this.bounds.y + "," + this.bounds.width + "," + this.bounds.height;
    }

    private boolean isOnScreen(Point p) {
        return p.x < Toolkit.getDefaultToolkit().getScreenSize().width && p.y < Toolkit.getDefaultToolkit().getScreenSize().height;
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        Point p;
        if (this.theFrame.isShowing() && this.isOnScreen(p = this.theFrame.getLocationOnScreen())) {
            this.previousBounds = new Rectangle(this.bounds);
            this.bounds.setLocation(p);
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.theFrame.isShowing()) {
            if (this.theFrame instanceof Frame && this.previousBounds != null && (((Frame)this.theFrame).getExtendedState() & 6) == 6) {
                this.bounds.setBounds(this.previousBounds);
            } else {
                this.bounds.setSize(this.theFrame.getSize());
            }
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    protected void setFrameBounds() {
        Rectangle desktopBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        if (this.bounds.width != 0 && this.bounds.height != 0) {
            this.theFrame.setSize(new Dimension(Math.abs(this.bounds.width), Math.abs(this.bounds.height)));
        }
        this.theFrame.setLocation(this.bounds.getLocation());
        int width = Math.min(this.theFrame.getSize().width, desktopBounds.width);
        int height = Math.min(this.theFrame.getSize().height, desktopBounds.height);
        if (width != this.theFrame.getSize().width || height != this.theFrame.getSize().height) {
            this.theFrame.setSize(width, height);
        }
        int x = this.theFrame.getLocation().x;
        int y = this.theFrame.getLocation().y;
        if (x < desktopBounds.x) {
            x = desktopBounds.x;
        }
        if (y < desktopBounds.y) {
            y = desktopBounds.y;
        }
        if (x + this.theFrame.getSize().width > desktopBounds.x + desktopBounds.width) {
            x = desktopBounds.x + desktopBounds.width - this.theFrame.getSize().width;
        }
        if (y + this.theFrame.getSize().height > desktopBounds.y + desktopBounds.height) {
            y = desktopBounds.y + desktopBounds.height - this.theFrame.getSize().height;
        }
        if (x != this.theFrame.getLocation().x || y != this.theFrame.getLocation().y) {
            this.theFrame.setLocation(x, y);
        }
    }
}

