/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.preferences;

import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import VASSAL.tools.SplashScreen;
import VASSAL.tools.WriteErrorDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;

public class PrefsEditor {
    private JDialog dialog;
    private List<Configurer> options = new ArrayList<Configurer>();
    private List<Configurer> extras = new ArrayList<Configurer>();
    private boolean iterating = false;
    private Map<Configurer, Object> savedValues = new HashMap<Configurer, Object>();
    private List<Prefs> prefs = new ArrayList<Prefs>();
    private JTabbedPane optionsTab = new JTabbedPane();
    private JDialog setupDialog;
    private File pfile;
    private Action editAction;

    public void initDialog(Frame parent) {
        if (this.dialog == null) {
            this.dialog = new JDialog(parent, true);
            this.dialog.setTitle(Resources.getString("Prefs.preferences"));
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    PrefsEditor.this.cancel();
                }
            });
            JButton ok = new JButton(Resources.getString("General.ok"));
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrefsEditor.this.save();
                }
            });
            JButton cancel = new JButton(Resources.getString("General.cancel"));
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrefsEditor.this.cancel();
                }
            });
            this.dialog.setLayout((LayoutManager)new MigLayout("insets dialog"));
            this.dialog.add((Component)this.optionsTab, "push, grow, wrap unrelated");
            this.dialog.add((Component)ok, "tag ok, split");
            this.dialog.add((Component)cancel, "tag cancel");
        }
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void addPrefs(Prefs p) {
        this.prefs.add(p);
    }

    public void addOption(String category, Configurer c, String prompt) {
        if (prompt != null) {
            if (this.setupDialog == null) {
                this.setupDialog = new JDialog((Frame)null, true);
                this.setupDialog.setTitle(Resources.getString("Prefs.initial_setup"));
                this.setupDialog.setLayout(new BoxLayout(this.setupDialog.getContentPane(), 1));
                this.setupDialog.setDefaultCloseOperation(0);
                this.setupDialog.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentShown(ComponentEvent e) {
                        SplashScreen.sendAllToBack();
                    }
                });
            }
            JPanel p = new JPanel();
            p.add(new JLabel(prompt));
            this.setupDialog.add(p);
            this.setupDialog.add(c.getControls());
            JButton b = new JButton(Resources.getString("General.ok"));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PrefsEditor.this.setupDialog.setVisible(false);
                }
            });
            p = new JPanel();
            p.add(b);
            this.setupDialog.add(p);
            this.setupDialog.pack();
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.setupDialog.setLocation(d.width / 2 - this.setupDialog.getSize().width / 2, d.height / 2 - this.setupDialog.getSize().height / 2);
            this.setupDialog.setVisible(true);
            this.setupDialog.removeAll();
        }
        this.addOption(category, c);
    }

    public synchronized void addOption(String category, Configurer c) {
        if (category == null) {
            category = Resources.getString("Prefs.general_tab");
        }
        JPanel pan = null;
        int i = this.optionsTab.indexOfTab(category);
        if (i == -1) {
            pan = new JPanel();
            pan.setLayout(new BoxLayout(pan, 1));
            this.optionsTab.addTab(category, pan);
        } else {
            pan = (JPanel)this.optionsTab.getComponentAt(i);
        }
        if (this.iterating) {
            this.extras.add(c);
        } else {
            this.options.add(c);
        }
        Box b = Box.createHorizontalBox();
        b.add(c.getControls());
        b.add(Box.createHorizontalGlue());
        pan.add(b);
    }

    private synchronized void storeValues() {
        this.savedValues.clear();
        for (Configurer c : this.options) {
            c.setFrozen(true);
            if (c.getValue() == null) continue;
            this.savedValues.put(c, c.getValue());
        }
    }

    protected synchronized void cancel() {
        for (Configurer c : this.options) {
            c.setValue(this.savedValues.get(c));
            c.setFrozen(false);
        }
        this.dialog.setVisible(false);
    }

    protected synchronized void save() {
        this.iterating = true;
        for (Configurer c : this.options) {
            if (this.savedValues.get(c) == null && c.getValue() != null || this.savedValues.get(c) != null && !this.savedValues.get(c).equals(c.getValue())) {
                c.fireUpdate();
            }
            c.setFrozen(false);
        }
        this.iterating = false;
        this.options.addAll(this.extras);
        this.extras.clear();
        this.write();
        this.dialog.setVisible(false);
    }

    public Action getEditAction() {
        if (this.editAction == null) {
            this.editAction = new AbstractAction(Resources.getString("Prefs.edit_preferences")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrefsEditor.this.storeValues();
                    PrefsEditor.this.dialog.pack();
                    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                    PrefsEditor.this.dialog.setLocation(d.width / 2 - PrefsEditor.this.dialog.getWidth() / 2, 0);
                    PrefsEditor.this.dialog.setVisible(true);
                }
            };
            this.editAction.putValue("MnemonicKey", Resources.getString("Prefs.edit_preferences").charAt(0));
        }
        return this.editAction;
    }

    public void write() {
        for (Prefs p : this.prefs) {
            try {
                p.save();
            }
            catch (IOException e) {
                WriteErrorDialog.error(e, p.getFile());
            }
        }
    }

    public void close() {
        this.write();
    }
}

