/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.GameModule;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.launch.Launcher;
import VASSAL.preferences.Prefs;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.image.svg.SVGImageUtils;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.io.FileArchive;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.io.ZipArchive;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipFile;

public class ArchiveWriter
extends DataArchive {
    private String archiveName;
    private boolean isTempArchive = false;

    public ArchiveWriter(String zipName) {
        this.archiveName = zipName;
        if (this.archiveName == null) {
            this.isTempArchive = true;
            try {
                this.archiveName = File.createTempFile("tmp", ".zip").getPath();
            }
            catch (IOException e) {
                WriteErrorDialog.error(e, this.archiveName);
            }
        }
        File f = new File(this.archiveName);
        try {
            if (f.exists()) {
                try {
                    this.archive = new ZipArchive(this.archiveName);
                }
                catch (IOException e1) {
                    this.archive = new ZipArchive(this.archiveName, true);
                }
            } else {
                this.archive = new ZipArchive(this.archiveName);
            }
        }
        catch (IOException e) {
            this.archive = null;
            WriteErrorDialog.error(e, this.archiveName);
        }
    }

    public ArchiveWriter(FileArchive archive) {
        this.archiveName = archive.getName();
        this.archive = archive;
    }

    @Deprecated
    public ArchiveWriter(ZipFile archive) {
        this.archiveName = archive.getName();
        try {
            this.archive = new ZipArchive(this.archiveName);
        }
        catch (IOException e) {
            archive = null;
            WriteErrorDialog.error(e, this.archiveName);
        }
    }

    public void addImage(String path, String name) {
        if (name.toLowerCase().endsWith(".svg")) {
            List<String> exrefs = null;
            try {
                exrefs = SVGImageUtils.getExternalReferences(path);
            }
            catch (IOException e) {
                ReadErrorDialog.error(e, name);
                return;
            }
            for (String s : exrefs) {
                File f = new File(s);
                byte[] buf = null;
                try {
                    buf = SVGImageUtils.relativizeExternalReferences(s);
                }
                catch (IOException e) {
                    ReadErrorDialog.error(e, f);
                    continue;
                }
                this.addFile(this.imageDir + f.getName(), buf);
            }
        } else {
            this.addFile(path, this.imageDir + name);
        }
        Op.load(name).update();
        this.localImages = null;
    }

    public void addImage(String name, byte[] contents) {
        this.addFile(this.imageDir + name, contents);
        this.localImages = null;
    }

    public void addSound(String path, String fileName) {
        this.addFile(path, this.soundDir + fileName);
    }

    @Deprecated
    public boolean isImageAdded(String name) {
        try {
            return this.archive.contains(this.imageDir + name);
        }
        catch (IOException e) {
            return false;
        }
    }

    public void removeImage(String name) {
        try {
            this.archive.remove(this.imageDir + name);
        }
        catch (IOException e) {
            WriteErrorDialog.error(e, this.archive.getName());
        }
        this.localImages = null;
    }

    public void addFile(String path, String fileName) {
        try {
            this.archive.add(fileName, path);
        }
        catch (IOException e) {
            WriteErrorDialog.error(e, this.archive.getName());
        }
    }

    public void addFile(String fileName, InputStream in) {
        try (OutputStream out = this.archive.getOutputStream(fileName);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            WriteErrorDialog.error(e, this.archive.getName());
        }
    }

    public void addFile(String fileName, byte[] content) {
        try {
            this.archive.add(fileName, content);
        }
        catch (IOException e) {
            WriteErrorDialog.error(e, this.archive.getName());
        }
    }

    public void save() throws IOException {
        this.save(false);
    }

    public void save(boolean notifyModuleManager) throws IOException {
        if (this.isTempArchive) {
            this.saveAs(notifyModuleManager);
        } else {
            this.write(this.archive, notifyModuleManager);
        }
    }

    public void saveAs() throws IOException {
        this.saveAs(false);
    }

    protected void write(FileArchive fa, boolean notifyModuleManager) throws IOException {
        fa.flush();
        if (notifyModuleManager) {
            Launcher.getInstance().sendSaveCmd(fa.getFile());
        }
    }

    public void saveAs(boolean notifyModuleManager) throws IOException {
        FileChooser fc = FileChooser.createFileChooser(GameModule.getGameModule().getPlayerWindow(), (DirectoryConfigurer)Prefs.getGlobalPrefs().getOption("modulesDir"));
        if (fc.showSaveDialog() != 0) {
            return;
        }
        String filename = fc.getSelectedFile().getPath();
        if (filename != this.archive.getName()) {
            FileArchive tmp = this.archive;
            this.archive = new ZipArchive(tmp, filename);
            this.archiveName = filename;
            this.archive.flush();
            tmp.revert();
            tmp.close();
            this.write(this.archive, notifyModuleManager);
            if (this.isTempArchive) {
                tmp.getFile().delete();
                this.isTempArchive = false;
            }
        } else {
            this.write(this.archive, notifyModuleManager);
        }
    }

    @Deprecated
    public void write() throws IOException {
        this.write(false);
    }

    @Deprecated
    public void write(boolean notifyModuleManager) throws IOException {
        this.save(notifyModuleManager);
    }
}

