/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.Info;
import VASSAL.tools.HTTPPostBuilder;
import VASSAL.tools.io.IOUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class BugUtils {
    public static void sendBugReport(String email, String description, String errorLog, Throwable t) throws IOException {
        HTTPPostBuilder pb = new HTTPPostBuilder();
        String url = "http://www.vassalengine.org/util/bug.php";
        pb.setParameter("version", Info.getVersion());
        pb.setParameter("email", email);
        pb.setParameter("summary", BugUtils.getSummary(t));
        pb.setParameter("description", description);
        pb.setParameter("log", "errorLog", errorLog);
        try (InputStream in = pb.post("http://www.vassalengine.org/util/bug.php");){
            String result = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            try {
                if (Integer.parseInt(result) != 0) {
                    throw new NumberFormatException("Bad result: " + result);
                }
            }
            catch (NumberFormatException e) {
                throw new IOException(e);
            }
        }
    }

    private static String getSummary(Throwable t) {
        Object summary;
        if (t == null) {
            summary = "Automated Bug Report";
        } else {
            String tc = t.getClass().getName();
            summary = tc.substring(tc.lastIndexOf(46) + 1);
            if (t.getMessage() != null) {
                summary = (String)summary + ": " + t.getMessage();
            }
        }
        return summary;
    }

    public static String getErrorLog() {
        String log = null;
        File f = new File(Info.getConfDir(), "errorLog");
        try (FileReader r = new FileReader(f);){
            log = IOUtils.toString((Reader)r);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return log;
    }
}

