/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.AudioClip;
import VASSAL.tools.AudioSystemClip;
import VASSAL.tools.ImprovedAveragingScaleFilter;
import VASSAL.tools.Mp3AudioClip;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.URLUtils;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.image.svg.SVGImageUtils;
import VASSAL.tools.image.svg.SVGRenderer;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.io.FileArchive;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.io.ZipArchive;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;

public class DataArchive
extends SecureClassLoader
implements Closeable {
    protected FileArchive archive;
    protected List<DataArchive> extensions = new ArrayList<DataArchive>();
    private final Map<String, AudioClip> soundCache = new HashMap<String, AudioClip>();
    protected SortedSet<String> localImages = null;
    public static final String IMAGE_DIR = "images/";
    protected String imageDir = "images/";
    public static final String SOUND_DIR = "sounds/";
    protected String soundDir = "sounds/";
    public static final String ICON_DIR = "icons/";
    private static final CodeSource cs = new CodeSource(null, (Certificate[])null);
    @Deprecated
    public static final String SOUNDS_DIR = "sounds/";
    @Deprecated
    protected String soundsDir = "sounds/";
    @Deprecated
    protected String[] imageNames;

    protected DataArchive() {
        super(DataArchive.class.getClassLoader());
    }

    public DataArchive(String zipName, String imageDir) throws IOException {
        this();
        this.archive = new ZipArchive(zipName);
        this.imageDir = imageDir;
    }

    public DataArchive(String zipName) throws IOException {
        this(zipName, IMAGE_DIR);
    }

    @Override
    public String getName() {
        return this.archive == null ? "data archive" : this.archive.getName();
    }

    public FileArchive getArchive() {
        return this.archive;
    }

    public String getImagePrefix() {
        return this.imageDir;
    }

    public AudioClip getCachedAudioClip(String name) throws IOException {
        String path = this.soundDir + name;
        AudioClip clip = this.soundCache.get(path);
        if (clip == null) {
            if (name.toLowerCase().endsWith(".mp3")) {
                clip = new Mp3AudioClip(path);
            } else {
                try (InputStream stream = this.getInputStream(path);){
                    clip = new AudioSystemClip(stream);
                }
            }
            this.soundCache.put(path, clip);
        }
        return clip;
    }

    @Deprecated
    public InputStream getImageInputStream(String fileName) throws IOException, FileNotFoundException {
        if (fileName.startsWith("/")) {
            InputStream in2 = this.getClass().getResourceAsStream(fileName);
            if (in2 != null) {
                return in2;
            }
            throw new FileNotFoundException("Resource not found: " + fileName);
        }
        try {
            return this.getInputStream(this.imageDir + fileName);
        }
        catch (FileNotFoundException in2) {
            try {
                return this.getInputStream(this.imageDir + fileName + ".gif");
            }
            catch (FileNotFoundException in2) {
                InputStream in3 = this.getClass().getResourceAsStream("/" + this.imageDir + fileName + ".gif");
                if (in3 != null) {
                    return in3;
                }
                throw new FileNotFoundException("'" + this.imageDir + fileName + "' not found in " + this.getName());
            }
        }
    }

    public InputStream getInputStream(String fileName) throws IOException, FileNotFoundException {
        if (fileName.startsWith("/")) {
            InputStream in = this.getClass().getResourceAsStream(fileName);
            if (in != null) {
                return in;
            }
            throw new FileNotFoundException("Resource not found: " + fileName);
        }
        InputStream in = this.getInputStreamImpl(fileName);
        if (in != null) {
            return in;
        }
        in = this.getClass().getResourceAsStream("/" + fileName);
        if (in != null) {
            return in;
        }
        in = this.getInputStreamImpl(fileName + ".gif");
        if (in != null) {
            return in;
        }
        in = this.getClass().getResourceAsStream("/" + fileName + ".gif");
        if (in != null) {
            return in;
        }
        throw new FileNotFoundException("'" + fileName + "' not found in " + this.getName());
    }

    private InputStream getInputStreamImpl(String fileName) throws IOException, FileNotFoundException {
        if (this.archive != null && this.archive.contains(fileName)) {
            return this.archive.getInputStream(fileName);
        }
        for (DataArchive ext : this.extensions) {
            try {
                return ext.getInputStream(fileName);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        }
        return null;
    }

    public URL getURL() throws IOException {
        if (this.archive == null) {
            throw new IOException("Must save before accessing contents");
        }
        return URLUtils.toJarURL(this.archive.getName());
    }

    public URL getURL(String fileName) throws IOException, FileNotFoundException {
        if (fileName.startsWith("/")) {
            return this.getClass().getResource(fileName);
        }
        if (this.archive == null) {
            throw new IOException("Must save before accessing contents");
        }
        if (this.archive.contains(fileName)) {
            return new URL(this.getURL(), fileName);
        }
        for (DataArchive ext : this.extensions) {
            try {
                return ext.getURL(fileName);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        }
        throw new FileNotFoundException("'" + fileName + "' not found in " + this.getName());
    }

    @Deprecated
    public URL getImageURL(String fileName) throws IOException, FileNotFoundException {
        return this.getURL(fileName);
    }

    public boolean contains(String fileName) throws IOException {
        if (this.archive == null) {
            return false;
        }
        return this.archive.contains(fileName);
    }

    @Override
    public void close() throws IOException {
        if (this.archive != null) {
            this.archive.revert();
            this.archive.close();
        }
    }

    public String[] getImageNames() {
        SortedSet<String> s = this.getImageNameSet();
        return s.toArray(new String[0]);
    }

    public SortedSet<String> getImageNameSet() {
        TreeSet<String> s = new TreeSet<String>();
        this.getImageNamesRecursively(s);
        return s;
    }

    protected void getImageNamesRecursively(SortedSet<String> s) {
        if (this.localImages == null) {
            this.localImages = this.getLocalImageNames();
        }
        s.addAll(this.localImages);
        for (DataArchive ext : this.extensions) {
            ext.getImageNamesRecursively(s);
        }
    }

    protected SortedSet<String> getLocalImageNames() {
        TreeSet<String> s = new TreeSet<String>();
        if (this.archive != null) {
            try {
                for (String filename : this.archive.getFiles("images")) {
                    s.add(filename.substring(this.imageDir.length()));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return s;
    }

    public void addExtension(DataArchive ext) {
        this.extensions.add(ext);
    }

    public ArchiveWriter getWriter() {
        if (this instanceof ArchiveWriter) {
            return (ArchiveWriter)this;
        }
        for (DataArchive ext : this.extensions) {
            ArchiveWriter writer = ext.getWriter();
            if (writer == null) continue;
            return writer;
        }
        return null;
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        try {
            c = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            c = this.findLoadedClass(name);
        }
        if (c == null) {
            return this.findClass(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection p = super.getPermissions(codesource);
        p.add(new AllPermission());
        return p;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String slashname = name.replace('.', '/');
        byte[] data = null;
        try (InputStream stream = this.getInputStream(slashname + ".class");){
            data = IOUtils.toByteArray((InputStream)stream);
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Unable to load class " + name, e);
        }
        int minor = data[4] << 8 | data[5];
        int major = data[6] << 8 | data[7];
        if (major > 55 || major == 55 && minor != 0) {
            ProblemDialog.showDisableable(2, null, null, (Object)cs, "Incompatible Custom Code", "The Custom Code In This Module Should Be Recompiled", "This module contains custom Java code (" + name + ") which was not compiled to be Java 11 compatible. As a result, this module will not run on all versions of Java which VASSAL itself supports.\n\nPlease check whether there is an updated version of this module. If not, please contact the maintainer of this module and request that it be fixed.");
        }
        return this.defineClass(name, data, 0, data.length, cs);
    }

    @Deprecated
    public Dimension getImageSize(String name) throws IOException {
        if (name.toLowerCase().endsWith(".svg")) {
            return SVGImageUtils.getImageSize(name, this.getImageInputStream(name));
        }
        return ImageUtils.getImageSize(name, this.getImageInputStream(name));
    }

    @Deprecated
    public BufferedImage getImage(String name) throws IOException {
        if (name.toLowerCase().endsWith(".svg")) {
            return new SVGRenderer(this.getURL(name), this.getImageInputStream(name)).render();
        }
        return ImageUtils.getImage(name, this.getImageInputStream(name));
    }

    @Deprecated
    protected boolean isNameCacheStale() {
        return true;
    }

    @Deprecated
    protected SortedSet<String> setOfImageNames() {
        return this.getImageNameSet();
    }

    @Deprecated
    public void unCacheImage(String file) {
    }

    @Deprecated
    public void unCacheImage(Image im) {
    }

    @Deprecated
    public void clearTransformedImageCache() {
    }

    @Deprecated
    public void clearScaledImageCache() {
    }

    @Deprecated
    public Image getCachedImage(String name) throws IOException {
        return Op.load(name).getImage();
    }

    @Deprecated
    public Image getTransformedImage(Image base, double scale, double theta) {
        return Op.rotateScale(Op.load(ImageUtils.toBufferedImage(base)), theta, scale).getImage();
    }

    @Deprecated
    public Image getTransformedImage(Image base, double scale, double theta, boolean forceSmoothing) {
        return this.getTransformedImage(base, scale, theta);
    }

    @Deprecated
    public Image getScaledImage(Image base, double scale, boolean reversed, boolean forceSmoothing) {
        return this.getTransformedImage(base, scale, reversed ? 180.0 : 0.0);
    }

    @Deprecated
    public Image getScaledImage(Image base, double scale) {
        return this.getTransformedImage(base, scale, 0.0, true);
    }

    @Deprecated
    public static Image findImage(File zip, String file) throws IOException {
        return DataArchive.getImage(DataArchive.getFileStream(zip, file));
    }

    @Deprecated
    public static Image findImage(File dir, String zip, String file) throws IOException {
        if (new File(dir, zip).exists()) {
            return DataArchive.getImage(DataArchive.getFileStream(dir, zip, file));
        }
        if (new File(dir, file).exists()) {
            return Toolkit.getDefaultToolkit().getImage(dir.getPath() + File.separatorChar + file);
        }
        throw new IOException("Image " + file + " not found in " + dir + File.separator + zip);
    }

    @Deprecated
    public static InputStream getFileStream(File zip, String file) throws IOException {
        try {
            ZipFile z = new ZipFile(zip);
            return z.getInputStream(z.getEntry(file));
        }
        catch (Exception e) {
            throw new IOException("Couldn't locate " + file + " in " + zip.getName() + ": " + e.getMessage());
        }
    }

    @Deprecated
    public static InputStream getFileStream(File dir, String zipName, String file) {
        try {
            if (new File(dir, zipName).exists()) {
                ZipFile zip = new ZipFile(new File(dir, zipName));
                return zip.getInputStream(zip.getEntry(file));
            }
            return new FileInputStream(new File(dir, file));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Deprecated
    public InputStream getFileStream(String fileName) throws IOException {
        return this.getInputStream(fileName);
    }

    @Deprecated
    public static Image getImage(InputStream in) throws IOException {
        return ImageUtils.getImage("", in);
    }

    @Deprecated
    public String getArchiveURL() {
        return this.archive != null ? "jar:file://" + this.archive.getName() + "!/" : "";
    }

    @Deprecated
    public static byte[] getBytes(InputStream in) throws IOException {
        return IOUtils.toByteArray((InputStream)in);
    }

    @Deprecated
    protected void listImageNames(Collection l) {
        l.addAll(this.setOfImageNames());
    }

    @Deprecated
    public static Rectangle getImageBounds(Image im) {
        ImageIcon icon = new ImageIcon(im);
        return new Rectangle(-icon.getIconWidth() / 2, -icon.getIconHeight() / 2, icon.getIconWidth(), icon.getIconHeight());
    }

    @Deprecated
    public Image improvedScaling(Image img, int width, int height) {
        ImprovedAveragingScaleFilter filter = new ImprovedAveragingScaleFilter(img.getWidth(null), img.getHeight(null), width, height);
        FilteredImageSource prod = new FilteredImageSource(img.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }
}

