/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.i18n.Resources;
import VASSAL.tools.AudioClip;
import VASSAL.tools.ErrorDialog;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.Player;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mp3AudioClip
implements AudioClip {
    private static final Logger log = LoggerFactory.getLogger(Mp3AudioClip.class);
    protected URL url = null;
    protected String name = null;

    public Mp3AudioClip(String name) {
        this.name = name;
    }

    public Mp3AudioClip(URL url) {
        this.url = url;
    }

    protected InputStream getStream() {
        block5: {
            try {
                if (this.name != null) {
                    try {
                        return GameModule.getGameModule().getDataArchive().getInputStream(this.name);
                    }
                    catch (FileNotFoundException e) {
                        ErrorDialog.dataError(new BadDataReport(Resources.getString("Error.not_found", this.name), "", e));
                        break block5;
                    }
                }
                return this.url.openStream();
            }
            catch (IOException e) {
                ErrorDialog.bug(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Player getPlayer(InputStream stream) {
        Player player = null;
        try {
            player = new Player(stream);
        }
        catch (JavaLayerException e) {
            ErrorDialog.bug(e);
        }
        finally {
            if (player == null && stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    log.error("Error while closing stream", (Throwable)e);
                }
            }
        }
        return player;
    }

    @Override
    public void play() {
        final InputStream stream = this.getStream();
        if (stream == null) {
            return;
        }
        final Player player = this.getPlayer(stream);
        if (player == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try (InputStream inputStream = stream;){
                    player.play();
                }
                catch (IOException | JavaLayerException e) {
                    ErrorDialog.dataError(new BadDataReport("Error reading sound file", Mp3AudioClip.this.name, e));
                }
            }
        }.start();
    }
}

