/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.tools.NamedKeyStroke;
import java.awt.Color;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.KeyStroke;

public class SequenceEncoder {
    private StringBuilder buffer;
    private final char delimit;

    public SequenceEncoder(char delimiter) {
        this.delimit = delimiter;
    }

    public SequenceEncoder(String val, char delimiter) {
        this(delimiter);
        this.append(val);
    }

    public SequenceEncoder append(String s) {
        if (this.buffer == null) {
            this.buffer = new StringBuilder();
        } else {
            this.buffer.append(this.delimit);
        }
        if (s != null) {
            if (s.endsWith("\\") || s.startsWith("'") && s.endsWith("'")) {
                this.buffer.append("'");
                this.appendEscapedString(s);
                this.buffer.append("'");
            } else {
                this.appendEscapedString(s);
            }
        }
        return this;
    }

    public SequenceEncoder append(char c) {
        return this.append(String.valueOf(c));
    }

    public SequenceEncoder append(int i) {
        return this.append(String.valueOf(i));
    }

    public SequenceEncoder append(long l) {
        return this.append(String.valueOf(l));
    }

    public SequenceEncoder append(double d) {
        return this.append(String.valueOf(d));
    }

    public SequenceEncoder append(boolean b) {
        return this.append(String.valueOf(b));
    }

    public SequenceEncoder append(KeyStroke stroke) {
        return this.append(HotKeyConfigurer.encode(stroke));
    }

    public SequenceEncoder append(NamedKeyStroke stroke) {
        return this.append(NamedHotKeyConfigurer.encode(stroke));
    }

    public SequenceEncoder append(Color color) {
        return this.append(ColorConfigurer.colorToString(color));
    }

    public SequenceEncoder append(String[] s) {
        return this.append(StringArrayConfigurer.arrayToString(s));
    }

    public SequenceEncoder append(PropertyExpression p) {
        return this.append(p.getExpression());
    }

    public String getValue() {
        return this.buffer != null ? this.buffer.toString() : null;
    }

    private void appendEscapedString(String s) {
        int begin = 0;
        int end = s.indexOf(this.delimit);
        while (begin <= end) {
            this.buffer.append(s.substring(begin, end)).append('\\');
            begin = end;
            end = s.indexOf(this.delimit, end + 1);
        }
        this.buffer.append(s.substring(begin));
    }

    public static void main(String[] args) {
        SequenceEncoder se = new SequenceEncoder(',');
        for (String arg : args) {
            se.append(arg);
        }
        System.out.println(se.getValue());
        Decoder st = new Decoder(se.getValue(), ',');
        while (st.hasMoreTokens()) {
            System.out.println(st.nextToken());
        }
    }

    public static class Decoder
    implements Iterator<String> {
        private String val;
        private final char delimit;

        public Decoder(String value, char delimiter) {
            this.val = value;
            this.delimit = delimiter;
        }

        public boolean hasMoreTokens() {
            return this.val != null;
        }

        public String nextToken() {
            String value;
            if (!this.hasMoreTokens()) {
                throw new NoSuchElementException();
            }
            int i = this.val.indexOf(this.delimit);
            if (i < 0) {
                value = this.val;
                this.val = null;
            } else {
                StringBuilder buffer = new StringBuilder();
                int begin = 0;
                int end = i;
                while (begin < end && this.val.charAt(end - 1) == '\\') {
                    buffer.append(this.val.substring(begin, end - 1));
                    begin = end;
                    end = this.val.indexOf(this.delimit, end + 1);
                }
                if (end < 0) {
                    buffer.append(this.val.substring(begin));
                    this.val = null;
                } else {
                    buffer.append(this.val.substring(begin, end));
                    this.val = end >= this.val.length() - 1 ? "" : this.val.substring(end + 1);
                }
                value = buffer.toString();
            }
            if (value.startsWith("'") && value.endsWith("'") && value.length() > 1) {
                value = value.substring(1, value.length() - 1);
            }
            return value;
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreTokens();
        }

        @Override
        public String next() {
            return this.nextToken();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Decoder copy() {
            return new Decoder(this.val, this.delimit);
        }

        public int nextInt(int defaultValue) {
            if (this.val != null) {
                try {
                    defaultValue = Integer.parseInt(this.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return defaultValue;
        }

        public long nextLong(long defaultValue) {
            if (this.val != null) {
                try {
                    defaultValue = Long.parseLong(this.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return defaultValue;
        }

        public double nextDouble(double defaultValue) {
            if (this.val != null) {
                try {
                    defaultValue = Double.parseDouble(this.nextToken());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return defaultValue;
        }

        public boolean nextBoolean(boolean defaultValue) {
            return this.val != null ? "true".equals(this.nextToken()) : defaultValue;
        }

        public char nextChar(char defaultValue) {
            if (this.val != null) {
                String s = this.nextToken();
                defaultValue = s.length() > 0 ? s.charAt(0) : defaultValue;
            }
            return defaultValue;
        }

        public KeyStroke nextKeyStroke(char defaultValue) {
            return this.nextKeyStroke(KeyStroke.getKeyStroke((int)defaultValue, 128));
        }

        public Color nextColor(Color defaultValue) {
            if (this.val != null) {
                String s = this.nextToken();
                defaultValue = s.length() > 0 ? ColorConfigurer.stringToColor(s) : null;
            }
            return defaultValue;
        }

        public KeyStroke nextKeyStroke(KeyStroke defaultValue) {
            if (this.val != null) {
                String s = this.nextToken();
                defaultValue = s.length() == 0 ? null : (s.indexOf(44) < 0 ? KeyStroke.getKeyStroke((int)s.charAt(0), 128) : HotKeyConfigurer.decode(s));
            }
            return defaultValue;
        }

        public NamedKeyStroke nextNamedKeyStroke(char defaultValue) {
            return this.nextNamedKeyStroke(NamedKeyStroke.getNamedKeyStroke(defaultValue, 128));
        }

        public NamedKeyStroke nextNamedKeyStroke() {
            return this.nextNamedKeyStroke(NamedKeyStroke.NULL_KEYSTROKE);
        }

        public NamedKeyStroke nextNamedKeyStroke(NamedKeyStroke defaultValue) {
            if (this.val != null) {
                String s = this.nextToken();
                defaultValue = s.length() == 0 ? null : (s.indexOf(44) < 0 ? NamedKeyStroke.getNamedKeyStroke(s.charAt(0), 128) : NamedHotKeyConfigurer.decode(s));
            }
            return defaultValue == null ? NamedKeyStroke.NULL_KEYSTROKE : defaultValue;
        }

        public String nextToken(String defaultValue) {
            return this.val != null ? this.nextToken() : defaultValue;
        }

        public String[] nextStringArray(int minLength) {
            String[] retVal = this.val != null ? StringArrayConfigurer.stringToArray(this.nextToken()) : new String[]{};
            if (retVal.length < minLength) {
                retVal = Arrays.copyOf(retVal, minLength);
            }
            return retVal;
        }
    }
}

