/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.build.GameModule;
import VASSAL.tools.DataArchive;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageNotFoundException;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.image.svg.SVGRenderer;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.RotateScaleOp;
import VASSAL.tools.imageop.SVGOp;
import VASSAL.tools.opcache.Op;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class RotateScaleOpSVGImpl
extends AbstractTileOpImpl
implements RotateScaleOp,
SVGOp {
    private final SVGOp sop;
    private final double scale;
    private final double angle;
    private final RenderingHints hints;
    private final int hash;

    public RotateScaleOpSVGImpl(SVGOp sop, double angle, double scale) {
        this(sop, angle, scale, ImageUtils.getDefaultHints());
    }

    public RotateScaleOpSVGImpl(SVGOp sop, double angle, double scale, RenderingHints hints) {
        if (sop == null) {
            throw new IllegalArgumentException();
        }
        if (scale <= 0.0) {
            throw new IllegalArgumentException("scale = " + scale);
        }
        this.sop = sop;
        this.angle = angle;
        this.scale = scale;
        this.hints = hints;
        this.hash = new HashCodeBuilder().append((Object)sop).append(scale).append(angle).append((Object)hints).toHashCode();
    }

    @Override
    public List<Op<?>> getSources() {
        return Collections.emptyList();
    }

    @Override
    public BufferedImage eval() throws Exception {
        DataArchive archive = GameModule.getGameModule().getDataArchive();
        String name = this.getName();
        try {
            SVGRenderer renderer = new SVGRenderer(archive.getURL(name), (InputStream)new BufferedInputStream(archive.getInputStream(name)));
            if (this.size == null) {
                this.fixSize();
            }
            return renderer.render(this.angle, this.scale);
        }
        catch (FileNotFoundException e) {
            throw new ImageNotFoundException(name, (Throwable)e);
        }
        catch (IOException e) {
            throw new ImageIOException(name, (Throwable)e);
        }
    }

    @Override
    protected void fixSize() {
        this.size = this.getSizeFromCache();
        if (this.size == null) {
            this.size = ImageUtils.transform(new Rectangle(this.sop.getSize()), this.scale, this.angle).getSize();
        }
    }

    @Override
    public double getAngle() {
        return this.angle;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public String getName() {
        return this.sop.getName();
    }

    @Override
    public RenderingHints getHints() {
        return this.hints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        RotateScaleOpSVGImpl op = (RotateScaleOpSVGImpl)o;
        return this.scale == op.getScale() && this.angle == op.getAngle() && this.hints.equals(op.getHints()) && this.sop.equals(op.sop);
    }

    public int hashCode() {
        return this.hash;
    }
}

