/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import VASSAL.tools.io.IOUtils;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Random;

public class ObfuscatingOutputStream
extends FilterOutputStream {
    public static final String HEADER = "!VCSK";
    private static final Random rand = new Random();
    private final byte key;
    private final byte[] pair = new byte[2];
    private static final byte[] HEX = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public ObfuscatingOutputStream(OutputStream out) throws IOException {
        this(out, (byte)rand.nextInt(256));
    }

    public ObfuscatingOutputStream(OutputStream out, byte key) throws IOException {
        super(out);
        this.key = key;
        out.write(HEADER.getBytes(StandardCharsets.UTF_8));
        this.pair[0] = HEX[(key & 0xF0) >>> 4];
        this.pair[1] = HEX[key & 0xF];
        out.write(this.pair);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(bytes[off + i]);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.pair[0] = HEX[((b ^= this.key) & 0xF0) >>> 4];
        this.pair[1] = HEX[b & 0xF];
        this.out.write(this.pair);
    }

    public static void main(String[] args) throws IOException {
        try (InputStream in = args.length > 0 ? new FileInputStream(args[0]) : System.in;
             ObfuscatingOutputStream out = new ObfuscatingOutputStream(new BufferedOutputStream(System.out));){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        System.exit(0);
    }
}

