/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.ipc;

import VASSAL.tools.ipc.Fin;
import VASSAL.tools.ipc.IPCMessage;
import java.io.IOException;
import java.io.ObjectOutput;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPCMessageDispatcher
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(IPCMessageDispatcher.class);
    protected final BlockingQueue<IPCMessage> queue;
    protected final ObjectOutput out;

    public IPCMessageDispatcher(BlockingQueue<IPCMessage> queue, ObjectOutput out) {
        this.queue = queue;
        this.out = out;
    }

    @Override
    public void run() {
        try (ObjectOutput objectOutput = this.out;){
            IPCMessage msg;
            do {
                msg = this.queue.take();
                this.out.writeObject(msg);
                this.out.flush();
            } while (!(msg instanceof Fin));
        }
        catch (IOException | InterruptedException e) {
            log.error("Error while writing into IPC channel", (Throwable)e);
        }
    }
}

