/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.logging;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggedOutputStream
extends OutputStream {
    private final Logger logger;
    private final ByteArrayOutputStream buf = new ByteArrayOutputStream();

    public LoggedOutputStream() {
        this(LoggerFactory.getLogger(LoggedOutputStream.class));
    }

    public LoggedOutputStream(Logger logger) {
        this.logger = logger;
    }

    @Override
    public synchronized void write(int b) {
        if (b == 10) {
            this.flush();
        } else {
            this.buf.write(b);
        }
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        if (b[off + len - 1] == 10) {
            --len;
        }
        this.buf.write(b, off, len);
        this.flush();
    }

    @Override
    public synchronized void flush() {
        if (this.buf.size() > 0) {
            this.logger.warn(new String(this.buf.toByteArray()));
            this.buf.reset();
        }
    }
}

