/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.swing;

import VASSAL.Info;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicSplitPaneUI;

@Deprecated
public class InternalSplitPane
extends JSplitPane {
    private static final long serialVersionUID = 1L;
    private boolean resizeOnVisibilityChange;
    private int hideablePosition;
    public static final int HIDE_TOP = 0;
    public static final int HIDE_BOTTOM = 1;
    public static final int HIDE_LEFT = 2;
    public static final int HIDE_RIGHT = 3;
    private List<InternalSplitPane> showingTransverseComponents = new ArrayList<InternalSplitPane>();
    private int transverseHiddenSize;

    public InternalSplitPane(Component hideableComponent, Component baseComponent, int hideablePosition, boolean resizeOnVisibilityChange) {
        super(0 == hideablePosition || 1 == hideablePosition ? 0 : 1);
        this.resizeOnVisibilityChange = resizeOnVisibilityChange;
        this.hideablePosition = hideablePosition;
        if (hideableComponent instanceof JComponent) {
            hideableComponent.setMinimumSize(new Dimension(0, 0));
        }
        switch (hideablePosition) {
            case 2: {
                this.setLeftComponent(hideableComponent);
                this.setRightComponent(baseComponent);
                break;
            }
            case 3: {
                this.setRightComponent(hideableComponent);
                this.setLeftComponent(baseComponent);
                break;
            }
            case 0: {
                this.setTopComponent(hideableComponent);
                this.setBottomComponent(baseComponent);
                break;
            }
            case 1: {
                this.setBottomComponent(hideableComponent);
                this.setTopComponent(baseComponent);
            }
        }
        this.setBorder(null);
        this.setResizeWeight(2 == hideablePosition || 0 == hideablePosition ? 0.0 : 1.0);
        this.hideComponent();
    }

    public void toggleVisibility() {
        if (this.getHideableComponent().isVisible()) {
            this.hideComponent();
        } else {
            this.showComponent();
        }
    }

    public Component getHideableComponent() {
        Component c = null;
        switch (this.hideablePosition) {
            case 2: {
                c = this.getLeftComponent();
                break;
            }
            case 3: {
                c = this.getRightComponent();
                break;
            }
            case 0: {
                c = this.getTopComponent();
                break;
            }
            case 1: {
                c = this.getBottomComponent();
            }
        }
        return c;
    }

    public Component getBaseComponent() {
        Component c = null;
        switch (this.hideablePosition) {
            case 2: {
                c = this.getRightComponent();
                break;
            }
            case 3: {
                c = this.getLeftComponent();
                break;
            }
            case 0: {
                c = this.getBottomComponent();
                break;
            }
            case 1: {
                c = this.getTopComponent();
            }
        }
        return c;
    }

    protected int getBaseComponentSize() {
        int size = -1;
        switch (this.getOrientation()) {
            case 0: {
                size = this.getBaseComponent().getSize().height;
                break;
            }
            case 1: {
                size = this.getBaseComponent().getSize().width;
            }
        }
        return size;
    }

    protected int getHideableComponentSize() {
        int size = -1;
        switch (this.getOrientation()) {
            case 0: {
                size = this.getHideableComponent().getSize().height;
                break;
            }
            case 1: {
                size = this.getHideableComponent().getSize().width;
            }
        }
        return size;
    }

    public void hideComponent() {
        if (this.getHideableComponent().isVisible()) {
            Container ancestor;
            if (this.resizeOnVisibilityChange && (ancestor = this.getTopLevelAncestor()) != null) {
                switch (this.hideablePosition) {
                    case 2: 
                    case 3: {
                        ancestor.setSize(new Dimension(ancestor.getSize().width - this.getHideableComponent().getSize().width, ancestor.getSize().height - this.getDividerSize()));
                        break;
                    }
                    case 0: 
                    case 1: {
                        ancestor.setSize(new Dimension(ancestor.getSize().width, ancestor.getSize().height - this.getHideableComponent().getSize().height - this.getDividerSize()));
                    }
                }
                ancestor.validate();
            }
            ((BasicSplitPaneUI)this.getUI()).getDivider().setVisible(false);
            this.getHideableComponent().setVisible(false);
            switch (this.hideablePosition) {
                case 0: 
                case 2: {
                    this.setDividerLocation(0.0);
                    break;
                }
                case 1: 
                case 3: {
                    this.setDividerLocation(1.0);
                }
            }
            InternalSplitPane split = this.getTransverseSplit();
            if (split != null) {
                split.hideTransverseComponent(this);
            }
        }
    }

    protected void showTransverseComponent(InternalSplitPane split) {
        if (this.showingTransverseComponents.isEmpty()) {
            this.transverseHiddenSize = this.getBaseComponentSize();
        }
        this.showingTransverseComponents.add(split);
        this.resizeBaseComponent();
    }

    protected void resizeBaseComponent() {
        if (this.getHideableComponent().isVisible()) {
            switch (this.hideablePosition) {
                case 1: 
                case 3: {
                    this.setDividerLocation(this.getPreferredBaseComponentSize());
                    break;
                }
                case 0: {
                    this.setDividerLocation(this.getSize().height - this.getPreferredBaseComponentSize());
                    break;
                }
                case 2: {
                    this.setDividerLocation(this.getSize().width - this.getPreferredBaseComponentSize());
                }
            }
        } else if (this.resizeOnVisibilityChange && this.getTopLevelAncestor() != null) {
            this.getTopLevelAncestor().setSize(this.getTransverseSize());
            this.getTopLevelAncestor().validate();
        }
    }

    protected int getPreferredBaseComponentSize() {
        int size = this.transverseHiddenSize;
        for (InternalSplitPane split : this.showingTransverseComponents) {
            switch (this.getOrientation()) {
                case 0: {
                    size = Math.max(size, split.getHideableComponent().getPreferredSize().height);
                    break;
                }
                case 1: {
                    size = Math.max(size, split.getHideableComponent().getPreferredSize().width);
                }
            }
        }
        return size;
    }

    protected void hideTransverseComponent(InternalSplitPane split) {
        this.showingTransverseComponents.remove(split);
        this.resizeBaseComponent();
    }

    protected Dimension getTransverseSize() {
        Dimension newSize = this.getTopLevelAncestor().getSize();
        switch (this.getOrientation()) {
            case 0: {
                newSize.height += this.getPreferredBaseComponentSize() - this.getBaseComponentSize();
                break;
            }
            case 1: {
                newSize.width += this.getPreferredBaseComponentSize() - this.getBaseComponentSize();
            }
        }
        return newSize;
    }

    public void showComponent() {
        if (this.getHideableComponent().isVisible()) {
            return;
        }
        if (this.resizeOnVisibilityChange) {
            Container ancestor = this.getTopLevelAncestor();
            if (ancestor == null) {
                return;
            }
            Rectangle screenBounds = Info.getScreenBounds(ancestor);
            Point ancestorPos = ancestor.getLocation();
            Dimension ancestorSize = ancestor.getSize();
            Dimension prefHSize = this.getHideableComponent().getPreferredSize();
            Dimension prefBSize = this.getBaseComponent().getPreferredSize();
            double div = 0.0;
            int w = 0;
            int h = 0;
            switch (this.getOrientation()) {
                case 1: {
                    w = Math.min(ancestorSize.width + prefHSize.width, screenBounds.width - ancestorPos.x);
                    h = ancestorSize.height;
                    div = (double)prefBSize.width / (double)(prefBSize.width + prefHSize.width);
                    break;
                }
                case 0: {
                    w = ancestorSize.width;
                    h = Math.min(ancestorSize.height + prefHSize.height, screenBounds.height - ancestorPos.y);
                    div = (double)prefBSize.height / (double)(prefBSize.height + prefHSize.height);
                }
            }
            ancestor.setSize(w, h);
            ancestor.validate();
            this.getHideableComponent().setVisible(true);
            ((BasicSplitPaneUI)this.getUI()).getDivider().setVisible(true);
            final double divPos = div;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InternalSplitPane.this.setDividerLocation(divPos);
                }
            });
        } else {
            this.getHideableComponent().setVisible(true);
            ((BasicSplitPaneUI)this.getUI()).getDivider().setVisible(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    InternalSplitPane.this.setDividerLocation(InternalSplitPane.this.getPreferredDividerLocation());
                }
            });
            InternalSplitPane split = this.getTransverseSplit();
            if (split != null) {
                split.showTransverseComponent(this);
            }
        }
    }

    protected int getPreferredDividerLocation() {
        int loc = 0;
        switch (this.hideablePosition) {
            case 2: {
                loc = this.getInsets().left + this.getLeftComponent().getPreferredSize().width;
                break;
            }
            case 3: {
                loc = this.getSize().width - this.getInsets().right - this.getDividerSize() - this.getRightComponent().getPreferredSize().width;
                break;
            }
            case 0: {
                loc = this.getInsets().top + this.getLeftComponent().getPreferredSize().height;
                break;
            }
            case 1: {
                loc = this.getSize().height - this.getInsets().bottom - this.getDividerSize() - this.getRightComponent().getPreferredSize().height;
            }
        }
        return loc;
    }

    public InternalSplitPane getTransverseSplit() {
        InternalSplitPane split = null;
        for (Container c = this.getParent(); c != null; c = c.getParent()) {
            InternalSplitPane p;
            if (!(c instanceof InternalSplitPane) || (p = (InternalSplitPane)c).getOrientation() == this.getOrientation() || !SwingUtilities.isDescendingFrom(this, p.getBaseComponent())) continue;
            split = p;
            break;
        }
        return split;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = null;
        if (this.getHideableComponent() == null || this.getHideableComponent().isVisible()) {
            d = super.getPreferredSize();
        } else {
            switch (this.hideablePosition) {
                case 2: {
                    d = this.getRightComponent().getPreferredSize();
                    break;
                }
                case 3: {
                    d = this.getLeftComponent().getPreferredSize();
                    break;
                }
                case 0: {
                    d = this.getBottomComponent().getPreferredSize();
                    break;
                }
                case 1: {
                    d = this.getTopComponent().getPreferredSize();
                }
            }
        }
        return d;
    }
}

