/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.version;

import VASSAL.Info;
import VASSAL.tools.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class VersionUtils {
    private static final String baseURL = "http://www.vassalengine.org/util/";
    private static final String currentRelease = "current-release";
    private static final String currentBeta = "current-beta";
    private static final String bugCheck = "check-version-bug.php?version=";
    private static String release = null;
    private static String beta = null;

    protected VersionUtils() {
    }

    private static String getRelease() throws IOException {
        if (release == null) {
            release = VersionUtils.getVersion("http://www.vassalengine.org/util/current-release");
        }
        return release;
    }

    private static String getBeta() throws IOException {
        if (beta == null) {
            beta = VersionUtils.getVersion("http://www.vassalengine.org/util/current-beta");
        }
        return beta;
    }

    private static String getVersion(String url) throws IOException {
        try (InputStream in = new URL(url).openStream();){
            String string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8).trim();
            return string;
        }
    }

    public static boolean isCurrent(String version) throws IOException {
        return version.equals(VersionUtils.update(version));
    }

    public static int compareVersions(String v0, String v1) {
        ComparableVersion comparableVersion0 = new ComparableVersion(v0);
        ComparableVersion comparableVersion1 = new ComparableVersion(v1);
        return comparableVersion0.compareTo(comparableVersion1);
    }

    private static String update(String version) throws IOException {
        String current = VersionUtils.getRelease();
        switch (Integer.signum(VersionUtils.compareVersions(version, current))) {
            case -1: {
                return current;
            }
            case 0: {
                return version;
            }
            case 1: {
                current = VersionUtils.getBeta();
                switch (Integer.signum(VersionUtils.compareVersions(version, current))) {
                    case -1: {
                        return current;
                    }
                    case 0: 
                    case 1: {
                        return version;
                    }
                }
            }
        }
        throw new IllegalStateException();
    }

    public static Boolean isUpdateable(String runningVersion) throws IOException {
        String update = VersionUtils.update(runningVersion);
        return !update.equals(runningVersion);
    }

    public static void main(String[] args) throws IOException {
        System.out.println(Info.getVersion() + " is current? " + VersionUtils.isCurrent(Info.getVersion()));
    }
}

