/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.Info;
import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.GpIdChecker;
import VASSAL.build.GpIdSupport;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.BasicCommandEncoder;
import VASSAL.build.module.ChartWindow;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.DiceButton;
import VASSAL.build.module.DoActionButton;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.GameState;
import VASSAL.build.module.GlobalKeyCommand;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Inventory;
import VASSAL.build.module.Map;
import VASSAL.build.module.ModuleExtension;
import VASSAL.build.module.MultiActionButton;
import VASSAL.build.module.NotesWindow;
import VASSAL.build.module.PieceWindow;
import VASSAL.build.module.PlayerHand;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.Plugin;
import VASSAL.build.module.PredefinedSetup;
import VASSAL.build.module.PrivateMap;
import VASSAL.build.module.PrototypesContainer;
import VASSAL.build.module.RandomTextButton;
import VASSAL.build.module.ServerConnection;
import VASSAL.build.module.SpecialDiceButton;
import VASSAL.build.module.StartupGlobalKeyCommand;
import VASSAL.build.module.ToolbarMenu;
import VASSAL.build.module.WizardSupport;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.build.module.properties.ChangePropertyCommandEncoder;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.build.module.turn.TurnTracker;
import VASSAL.build.widget.PieceSlot;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.Logger;
import VASSAL.command.NullCommand;
import VASSAL.configure.CompoundValidityChecker;
import VASSAL.configure.MandatoryComponent;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.launch.PlayerWindow;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.CRCUtils;
import VASSAL.tools.DataArchive;
import VASSAL.tools.KeyStrokeListener;
import VASSAL.tools.KeyStrokeSource;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.ToolBarComponent;
import VASSAL.tools.WarningDialog;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.image.ImageTileSource;
import VASSAL.tools.image.tilecache.ImageTileDiskCache;
import VASSAL.tools.version.VersionUtils;
import java.awt.FileDialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public abstract class GameModule
extends AbstractConfigurable
implements CommandEncoder,
ToolBarComponent,
PropertySource,
MutablePropertiesContainer,
GpIdSupport {
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(GameModule.class);
    protected static final String DEFAULT_NAME = "Unnamed module";
    public static final String MODULE_NAME = "name";
    public static final String MODULE_VERSION = "version";
    public static final String DESCRIPTION = "description";
    public static final String VASSAL_VERSION_CREATED = "VassalVersion";
    public static final String VASSAL_VERSION_RUNNING = "runningVassalVersion";
    public static final String NEXT_PIECESLOT_ID = "nextPieceSlotId";
    public static final String BUILDFILE = "buildFile";
    private static GameModule theModule;
    protected String moduleVersion = "0.0";
    protected String vassalVersionCreated = "0.0";
    protected String gameName = "Unnamed module";
    protected String localizedGameName = null;
    protected String description = "";
    protected String lastSavedConfiguration;
    protected FileChooser fileChooser;
    protected FileDialog fileDialog;
    protected MutablePropertiesContainer propsContainer = new MutablePropertiesContainer.Impl();
    protected PropertyChangeListener repaintOnPropertyChange = evt -> {
        for (Map map : Map.getMapList()) {
            map.repaint();
        }
    };
    protected PlayerWindow frame = new PlayerWindow();
    @Deprecated(since="2020-08-06", forRemoval=true)
    protected JPanel controlPanel = this.frame.getControlPanel();
    protected GameState theState;
    protected DataArchive archive;
    protected Prefs preferences;
    protected Logger logger;
    protected Chatter chat;
    protected Random RNG = new SecureRandom();
    protected ServerConnection server;
    protected ImageTileSource tcache;
    protected WizardSupport wizardSupport;
    protected PropertyChangeSupport idChangeSupport;
    protected List<KeyStrokeSource> keyStrokeSources = new ArrayList<KeyStrokeSource>();
    protected List<KeyStrokeListener> keyStrokeListeners = new ArrayList<KeyStrokeListener>();
    protected CommandEncoder[] commandEncoders = new CommandEncoder[0];
    protected List<String> deferredChat = new ArrayList<String>();
    protected int nextGpId = 0;
    protected boolean loggingPaused = false;
    protected final Object loggingLock = new Object();
    protected Command pausedCommands;
    protected GpIdSupport gpidSupport = null;
    protected Long crc = null;
    private static String oldDragThreshold;
    public static final String REAL_NAME = "RealName";
    public static final String SECRET_NAME = "SecretName";
    public static final String PERSONAL_INFO = "Profile";
    private static String userId;

    @Deprecated(since="2020-08-06", forRemoval=true)
    public JFrame getFrame() {
        ProblemDialog.showDeprecated("2020-08-06");
        return this.frame;
    }

    public PlayerWindow getPlayerWindow() {
        return this.frame;
    }

    public void initFrameTitle() {
        this.frame.setTitle(this.getLocalizedGameName());
    }

    public WizardSupport getWizardSupport() {
        if (this.wizardSupport == null) {
            this.wizardSupport = new WizardSupport();
        }
        return this.wizardSupport;
    }

    protected GameModule(DataArchive archive) {
        this.archive = archive;
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GameModule.this.quit();
            }
        });
        this.addKeyStrokeSource(new KeyStrokeSource(this.frame.getRootPane(), 2));
        this.validator = new CompoundValidityChecker(new MandatoryComponent(this, Documentation.class), new MandatoryComponent(this, GlobalOptions.class));
        this.addCommandEncoder(new ChangePropertyCommandEncoder(this.propsContainer));
    }

    protected abstract void build() throws IOException;

    @Override
    public void setAttribute(String name, Object value) {
        if (MODULE_NAME.equals(name)) {
            if (Localization.getInstance().isTranslationInProgress()) {
                this.localizedGameName = (String)value;
            } else {
                this.gameName = (String)value;
            }
            this.setConfigureName((String)value);
        } else if (MODULE_VERSION.equals(name)) {
            this.moduleVersion = (String)value;
        } else if (VASSAL_VERSION_CREATED.equals(name)) {
            this.vassalVersionCreated = (String)value;
            String runningVersion = Info.getVersion();
            if (VersionUtils.compareVersions(this.vassalVersionCreated, runningVersion) > 0) {
                WarningDialog.show("GameModule.version_warning", this.vassalVersionCreated, runningVersion);
            }
        } else if (NEXT_PIECESLOT_ID.equals(name)) {
            try {
                this.nextGpId = Integer.parseInt((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalBuildException(e);
            }
        } else if (DESCRIPTION.equals(name)) {
            this.description = (String)value;
        }
    }

    @Override
    public String getAttributeValueString(String name) {
        if (MODULE_NAME.equals(name)) {
            return this.gameName;
        }
        if (MODULE_VERSION.equals(name)) {
            return this.moduleVersion;
        }
        if (VASSAL_VERSION_CREATED.equals(name)) {
            return this.vassalVersionCreated;
        }
        if (VASSAL_VERSION_RUNNING.equals(name)) {
            return Info.getVersion();
        }
        if (NEXT_PIECESLOT_ID.equals(name)) {
            return String.valueOf(this.nextGpId);
        }
        if (DESCRIPTION.equals(name)) {
            return this.description;
        }
        return null;
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public static int compareVersions(String v1, String v2) {
        ProblemDialog.showDeprecated("2020-08-06");
        return VersionUtils.compareVersions(v1, v2);
    }

    @Override
    public void addTo(Buildable b) {
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.GameModule.component_type");
    }

    @Override
    public void removeFrom(Buildable parent) {
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm");
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{MODULE_NAME, MODULE_VERSION, DESCRIPTION, VASSAL_VERSION_CREATED, NEXT_PIECESLOT_ID};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.GameModule.name_label"), Resources.getString("Editor.GameModule.version_label"), Resources.getString("Editor.GameModule.description")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, String.class};
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{Map.class, PieceWindow.class, PrototypesContainer.class, ToolbarMenu.class, MultiActionButton.class, DoActionButton.class, DiceButton.class, GlobalKeyCommand.class, StartupGlobalKeyCommand.class, Inventory.class, RandomTextButton.class, SpecialDiceButton.class, PredefinedSetup.class, ChartWindow.class, PrivateMap.class, PlayerHand.class, NotesWindow.class, TurnTracker.class};
    }

    public void addKeyStrokeSource(KeyStrokeSource src) {
        this.keyStrokeSources.add(src);
        for (KeyStrokeListener l : this.keyStrokeListeners) {
            l.addKeyStrokeSource(src);
        }
    }

    public void addKeyStrokeListener(KeyStrokeListener l) {
        this.keyStrokeListeners.add(l);
        for (KeyStrokeSource s : this.keyStrokeSources) {
            l.addKeyStrokeSource(s);
        }
    }

    public void refreshKeyStrokeListeners() {
        this.keyStrokeListeners.forEach(l -> l.setKeyStroke(l.getKeyStroke()));
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public void fireKeyStroke(KeyStroke stroke) {
        ProblemDialog.showDeprecated("2020-08-06");
        if (stroke != null) {
            for (KeyStrokeListener l : this.keyStrokeListeners) {
                l.keyPressed(stroke);
            }
        }
    }

    public void fireKeyStroke(NamedKeyStroke stroke) {
        if (stroke == null || stroke.isNull()) {
            return;
        }
        KeyStroke innerStroke = stroke.getKeyStroke();
        if (innerStroke == null) {
            return;
        }
        this.keyStrokeListeners.forEach(l -> l.keyPressed(innerStroke));
    }

    public String getGameName() {
        return this.gameName;
    }

    public String getLocalizedGameName() {
        return this.localizedGameName == null ? this.gameName : this.localizedGameName;
    }

    public String getGameVersion() {
        return this.moduleVersion;
    }

    public void addIdChangeListener(PropertyChangeListener l) {
        this.idChangeSupport.addPropertyChangeListener(l);
    }

    public void removeIdChangeListener(PropertyChangeListener l) {
        this.idChangeSupport.removePropertyChangeListener(l);
    }

    public Prefs getPrefs() {
        if (this.preferences == null) {
            this.setPrefs(new Prefs(Prefs.getGlobalPrefs().getEditor(), this.gameName));
        }
        return this.preferences;
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public Prefs getGlobalPrefs() {
        ProblemDialog.showDeprecated("2020-08-06");
        return Prefs.getGlobalPrefs();
    }

    public void addCommandEncoder(CommandEncoder ce) {
        this.commandEncoders = (CommandEncoder[])ArrayUtils.add((Object[])this.commandEncoders, (Object)ce);
    }

    public void removeCommandEncoder(CommandEncoder ce) {
        this.commandEncoders = (CommandEncoder[])ArrayUtils.removeElement((Object[])this.commandEncoders, (Object)ce);
    }

    public GamePiece createPiece(String type) {
        for (CommandEncoder commandEncoder : this.commandEncoders) {
            GamePiece p;
            if (!(commandEncoder instanceof BasicCommandEncoder) || (p = ((BasicCommandEncoder)commandEncoder).createPiece(type)) == null) continue;
            return p;
        }
        return null;
    }

    public GamePiece createPiece(String type, GamePiece inner) {
        for (CommandEncoder commandEncoder : this.commandEncoders) {
            Decorator p;
            if (!(commandEncoder instanceof BasicCommandEncoder) || (p = ((BasicCommandEncoder)commandEncoder).createDecorator(type, inner)) == null) continue;
            return p;
        }
        return null;
    }

    public void warn(String s) {
        if (this.chat == null) {
            this.deferredChat.add(s);
        } else {
            this.chat.show(" - " + s);
        }
    }

    public Random getRNG() {
        return this.RNG;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setChatter(Chatter c) {
        this.chat = c;
        if (this.deferredChat.size() > 0) {
            for (String msg : this.deferredChat) {
                this.warn(msg);
            }
            this.deferredChat.clear();
        }
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public JComponent getControlPanel() {
        ProblemDialog.showDeprecated("2020-08-06");
        return this.controlPanel;
    }

    public Chatter getChatter() {
        return this.chat;
    }

    public void setPrefs(Prefs p) {
        this.preferences = p;
        this.preferences.getEditor().initDialog(this.getPlayerWindow());
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public void setGlobalPrefs(Prefs p) {
        ProblemDialog.showDeprecated("2020-08-06");
    }

    @Override
    public Command decode(String command) {
        if (command == null) {
            return null;
        }
        Command c = null;
        for (int i = 0; i < this.commandEncoders.length && c == null; ++i) {
            c = this.commandEncoders[i].decode(command);
        }
        if (c == null) {
            System.err.println("Failed to decode " + command);
        }
        return c;
    }

    @Override
    public String encode(Command c) {
        if (c == null) {
            return null;
        }
        String s = null;
        for (int i = 0; i < this.commandEncoders.length && s == null; ++i) {
            s = this.commandEncoders[i].encode(c);
        }
        if (s == null) {
            System.err.println("Failed to encode " + c);
        }
        return s;
    }

    public FileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = FileChooser.createFileChooser(this.getPlayerWindow(), this.getGameState().getSavedGameDirectoryPreference());
        } else {
            this.fileChooser.resetChoosableFileFilters();
            this.fileChooser.rescanCurrentDirectory();
        }
        return this.fileChooser;
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public FileDialog getFileDialog() {
        ProblemDialog.showDeprecated("2020-08-06");
        if (this.fileDialog == null) {
            this.fileDialog = new FileDialog(this.getPlayerWindow());
            File f = this.getGameState().getSavedGameDirectoryPreference().getFileValue();
            if (f != null) {
                this.fileDialog.setDirectory(f.getPath());
            }
            this.fileDialog.setModal(true);
        } else {
            this.fileDialog.setDirectory(this.fileDialog.getDirectory());
        }
        return this.fileDialog;
    }

    @Override
    public JToolBar getToolBar() {
        return this.frame.getToolBar();
    }

    public void appendToTitle(String s) {
        if (s == null) {
            this.frame.setTitle(Resources.getString("GameModule.frame_title", this.getLocalizedGameName()));
        } else {
            this.frame.setTitle(this.frame.getTitle() + s);
        }
        for (Map m : this.getComponentsOf(Map.class)) {
            m.appendToTitle(s);
        }
    }

    public void quit() {
        if (this.shutDown()) {
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutDown() {
        this.getGameState().setup(false);
        boolean cancelled = this.getGameState().isGameStarted();
        if (!cancelled) {
            if (this.getDataArchive() instanceof ArchiveWriter && !this.buildString().equals(this.lastSavedConfiguration)) {
                switch (JOptionPane.showConfirmDialog(this.frame, Resources.getString("GameModule.save_module"), "", 1)) {
                    case 0: {
                        this.save();
                        break;
                    }
                    case -1: 
                    case 2: {
                        cancelled = true;
                    }
                }
            }
            for (ModuleExtension ext : this.getComponentsOf(ModuleExtension.class)) {
                cancelled = !ext.confirmExit();
            }
        }
        if (!cancelled) {
            Prefs p = null;
            try {
                p = this.getPrefs();
                p.write();
            }
            catch (IOException e) {
                WriteErrorDialog.error(e, p.getFile());
            }
            finally {
                if (p != null) {
                    try {
                        p.close();
                    }
                    catch (IOException e) {
                        log.error("Error while closing module preferences", (Throwable)e);
                    }
                }
            }
            try {
                this.archive.close();
            }
            catch (IOException e) {
                ReadErrorDialog.error(e, this.archive.getName());
            }
            log.info("Exiting");
        }
        return !cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAndLog(Command c) {
        if (c != null && !c.isNull()) {
            Object object = this.loggingLock;
            synchronized (object) {
                if (this.loggingPaused) {
                    if (this.pausedCommands == null) {
                        this.pausedCommands = c;
                    } else {
                        this.pausedCommands.append(c);
                    }
                } else {
                    this.getServer().sendToOthers(c);
                    this.getLogger().log(c);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pauseLogging() {
        Object object = this.loggingLock;
        synchronized (object) {
            if (this.loggingPaused) {
                return false;
            }
            this.loggingPaused = true;
            this.pausedCommands = null;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command resumeLogging() {
        Command c;
        Object object = this.loggingLock;
        synchronized (object) {
            c = this.pausedCommands == null ? new NullCommand() : this.pausedCommands;
            this.pausedCommands = null;
            this.loggingPaused = false;
        }
        return c;
    }

    public void clearPausedCommands() {
        this.pausedCommands = null;
    }

    public static String getUserId() {
        return userId;
    }

    public static void setUserId(String newId) {
        userId = newId;
    }

    public ServerConnection getServer() {
        return this.server;
    }

    public static void init(GameModule module) throws IOException {
        if (theModule != null) {
            throw new UnsupportedOperationException(Resources.getString("GameModule.open_error", theModule.getDataArchive().getName()));
        }
        theModule = module;
        theModule.setGpIdSupport(theModule);
        try {
            theModule.build();
        }
        catch (IOException e) {
            theModule = null;
            throw e;
        }
        if (theModule.getDataArchive() instanceof ArchiveWriter) {
            theModule.checkGpIds();
        }
        oldDragThreshold = System.getProperty("awt.dnd.drag.threshold");
        System.setProperty("awt.dnd.drag.threshold", Integer.toString(GlobalOptions.getInstance().getDragThreshold()));
        for (Plugin plugin : theModule.getComponentsOf(Plugin.class)) {
            plugin.init();
        }
    }

    public static void unload() {
        if (oldDragThreshold != null) {
            System.setProperty("awt.dnd.drag.threshold", oldDragThreshold);
        } else {
            System.clearProperty("awt.dnd.drag.threshold");
        }
        if (theModule != null && theModule.shutDown()) {
            theModule = null;
        }
    }

    public void updateLastSave() {
        this.lastSavedConfiguration = this.buildString();
    }

    @Override
    public String generateGpId() {
        return String.valueOf(this.nextGpId++);
    }

    @Override
    public int getNextGpId() {
        return this.nextGpId;
    }

    @Override
    public void setNextGpId(int id) {
        this.nextGpId = id;
    }

    public void setGpIdSupport(GpIdSupport s) {
        this.gpidSupport = s;
    }

    public GpIdSupport getGpIdSupport() {
        return this.gpidSupport;
    }

    protected void checkGpIds() {
        GpIdChecker checker = new GpIdChecker(this);
        for (PieceSlot pieceSlot : theModule.getAllDescendantComponentsOf(PieceSlot.class)) {
            checker.add(pieceSlot);
        }
        for (PrototypesContainer pc : theModule.getComponentsOf(PrototypesContainer.class)) {
            pc.getDefinitions().forEach(checker::add);
        }
        checker.fixErrors();
    }

    public DataArchive getDataArchive() {
        return this.archive;
    }

    public ArchiveWriter getArchiveWriter() {
        return this.archive.getWriter();
    }

    public ImageTileSource getImageTileSource() {
        if (this.tcache == null) {
            String hstr = DigestUtils.sha1Hex((String)(this.getGameName() + "_" + this.getGameVersion()));
            File tc = new File(Info.getConfDir(), "tiles/" + hstr);
            this.tcache = new ImageTileDiskCache(tc.getAbsolutePath());
        }
        return this.tcache;
    }

    public boolean isLocalizationEnabled() {
        return this.getArchiveWriter() == null;
    }

    public static GameModule getGameModule() {
        return theModule;
    }

    public GameState getGameState() {
        return this.theState;
    }

    public void saveAs() {
        this.save(true);
    }

    public void save() {
        this.save(false);
    }

    protected void save(boolean saveAs) {
        this.vassalVersionCreated = Info.getVersion();
        ArchiveWriter writer = this.getArchiveWriter();
        try {
            new ModuleMetaData(this).save(writer);
        }
        catch (IOException e) {
            WriteErrorDialog.error(e, writer.getName());
        }
        try {
            String save = this.buildString();
            writer.addFile(BUILDFILE, new ByteArrayInputStream(save.getBytes(StandardCharsets.UTF_8)));
            if (saveAs) {
                writer.saveAs(true);
            } else {
                writer.save(true);
            }
            this.lastSavedConfiguration = save;
        }
        catch (IOException e) {
            WriteErrorDialog.error(e, writer.getName());
        }
    }

    protected String buildString() {
        Document doc = Builder.createNewDocument();
        doc.appendChild(this.getBuildElement(doc));
        return Builder.toString(doc);
    }

    @Override
    public Object getProperty(Object key) {
        if ("PlayerSide".equals(key) || "playerSide".equals(key)) {
            String mySide = PlayerRoster.getMySide();
            return mySide == null ? "" : mySide;
        }
        if ("PlayerName".equals(key) || "playerName".equals(key)) {
            return this.getPrefs().getValue(REAL_NAME);
        }
        if ("PlayerId".equals(key) || "playerId".equals(key)) {
            return GlobalOptions.getInstance().getPlayerId();
        }
        MutableProperty p = this.propsContainer.getMutableProperty(String.valueOf(key));
        return p == null ? null : p.getPropertyValue();
    }

    @Override
    public MutableProperty getMutableProperty(String name) {
        return this.propsContainer.getMutableProperty(name);
    }

    @Override
    public void addMutableProperty(String key, MutableProperty p) {
        this.propsContainer.addMutableProperty(key, p);
        p.addMutablePropertyChangeListener(this.repaintOnPropertyChange);
    }

    @Override
    public MutableProperty removeMutableProperty(String key) {
        MutableProperty p = this.propsContainer.removeMutableProperty(key);
        if (p != null) {
            p.removeMutablePropertyChangeListener(this.repaintOnPropertyChange);
        }
        return p;
    }

    @Override
    public String getMutablePropertiesContainerId() {
        return "Module";
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if ("PlayerSide".equals(key) || "playerSide".equals(key)) {
            String mySide = PlayerRoster.getMyLocalizedSide();
            return mySide == null ? "" : mySide;
        }
        return this.getProperty(key);
    }

    public long getCrc() {
        if (this.crc == null) {
            this.crc = this.buildCrc();
        }
        return this.crc;
    }

    protected Long buildCrc() {
        ArrayList<File> files = new ArrayList<File>();
        if (this.getDataArchive().getArchive() != null) {
            files.add(new File(this.getDataArchive().getName()));
        }
        for (ModuleExtension ext : this.getComponentsOf(ModuleExtension.class)) {
            if (ext.getDataArchive().getArchive() == null) continue;
            files.add(new File(ext.getDataArchive().getName()));
        }
        try {
            return CRCUtils.getCRC(files);
        }
        catch (IOException e) {
            log.error("Error generating CRC", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public ComponentI18nData getI18nData() {
        ComponentI18nData myI18nData = super.getI18nData();
        myI18nData.setAttributeTranslatable(MODULE_VERSION, false);
        return myI18nData;
    }

    public PlayerRoster getPlayerRoster() {
        return this.getComponentsOf(PlayerRoster.class).stream().findFirst().orElse(null);
    }

    public void addSideChangeListenerToPlayerRoster(PlayerRoster.SideChangeListener l) {
        PlayerRoster r = this.getPlayerRoster();
        if (r != null) {
            r.addSideChangeListenerToInstance(l);
        }
    }

    static {
        userId = null;
    }
}

