/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.FontManager;
import VASSAL.build.module.gamepieceimage.FontStyle;
import VASSAL.build.module.gamepieceimage.OutlineFont;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class FontConfigurer
extends Configurer {
    protected JPanel p;
    protected IntConfigurer size;
    protected BooleanConfigurer bold;
    protected BooleanConfigurer italic;
    protected BooleanConfigurer outline;
    protected JComboBox family;
    protected JTextField demo;

    public FontConfigurer(String key, String name) {
        super(key, name);
    }

    public FontConfigurer(String key, String name, OutlineFont f) {
        super(key, name);
        this.setValue(f);
    }

    public FontConfigurer(String key, String name, FontStyle f) {
        super(key, name);
        this.setValue(f.font);
        this.setName(f.getConfigureName());
    }

    @Override
    public String getValueString() {
        return FontConfigurer.encode((OutlineFont)this.value);
    }

    @Override
    public void setValue(String s) {
        this.setValue(FontConfigurer.decode(s));
    }

    @Override
    public Component getControls() {
        if (this.p == null) {
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 1));
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Font Family:  "));
            this.family = new JComboBox();
            for (int i = 0; i < FontManager.ALLOWABLE_FONTS.length; ++i) {
                this.family.addItem(FontManager.ALLOWABLE_FONTS[i]);
            }
            this.family.setSelectedItem(this.value == null ? "SanSerif" : this.getFontValue().getFamily());
            box.add(this.family);
            this.p.add(box);
            this.size = new IntConfigurer(null, "Size:  ", (Integer)this.getFontValue().getSize());
            this.p.add(this.size.getControls());
            box = Box.createHorizontalBox();
            this.bold = new BooleanConfigurer(null, "Bold", this.isBold());
            box.add(this.bold.getControls());
            this.italic = new BooleanConfigurer(null, "Italic", this.isItalic());
            box.add(this.italic.getControls());
            this.outline = new BooleanConfigurer(null, "Outline", this.isOutline());
            box.add(this.outline.getControls());
            this.p.add(box);
            box = Box.createHorizontalBox();
            box.add(new JLabel("Sample:  "));
            this.demo = new JTextField("The quick brown fox", 20);
            this.demo.setEditable(false);
            box.add(this.demo);
            this.p.add(box);
            this.updateValue();
            ItemListener l = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    FontConfigurer.this.updateValue();
                }
            };
            this.family.addItemListener(l);
            PropertyChangeListener pc = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    FontConfigurer.this.updateValue();
                }
            };
            this.size.addPropertyChangeListener(pc);
            this.bold.addPropertyChangeListener(pc);
            this.italic.addPropertyChangeListener(pc);
            this.outline.addPropertyChangeListener(pc);
        }
        return this.p;
    }

    protected void updateValue() {
        int style = 0 | (this.bold.booleanValue() != false ? 1 : 0) | (this.italic.booleanValue() != false ? 2 : 0);
        OutlineFont font = new OutlineFont((String)this.family.getSelectedItem(), style, Integer.parseInt(this.size.getValueString()), this.outline.booleanValue());
        this.setValue(font);
        this.demo.setFont(font);
        Window w = SwingUtilities.getWindowAncestor(this.getControls());
        if (w != null) {
            w.pack();
        }
    }

    protected OutlineFont getFontValue() {
        return (OutlineFont)this.getValue();
    }

    public static OutlineFont decode(String s) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ',');
        return new OutlineFont(sd.nextToken("Dialog"), sd.nextInt(0), sd.nextInt(10), sd.nextBoolean(false));
    }

    public static String encode(OutlineFont f) {
        SequenceEncoder se = new SequenceEncoder(f.getName(), ',');
        se.append(f.getStyle());
        se.append(f.getSize());
        se.append(f.isOutline());
        return se.getValue();
    }

    public boolean isBold() {
        return (this.getFontValue().getStyle() & 1) != 0;
    }

    public boolean isItalic() {
        return (this.getFontValue().getStyle() & 2) != 0;
    }

    public boolean isOutline() {
        return this.getFontValue().isOutline();
    }
}

