/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.Drawable;
import VASSAL.command.Command;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.Translatable;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HidePiecesButton
extends JPanel
implements MouseListener,
AutoConfigurable,
GameComponent,
Drawable {
    private static final long serialVersionUID = 1L;
    protected boolean piecesVisible = false;
    protected Map map;
    protected LaunchButton launch;
    protected String showingIcon;
    protected String hiddenIcon;
    protected ComponentI18nData myI18nData;
    public static final String DEFAULT_SHOWING_ICON = "/images/globe_unselected.gif";
    public static final String DEFAULT_HIDDEN_ICON = "/images/globe_selected.gif";
    public static final String HOTKEY = "hotkey";
    public static final String HIDDEN_ICON = "hiddenIcon";
    public static final String SHOWING_ICON = "showingIcon";
    public static final String LAUNCH_ICON = "icon";
    public static final String TOOLTIP = "tooltip";
    public static final String BUTTON_TEXT = "buttonText";

    public HidePiecesButton() {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HidePiecesButton.this.setPiecesVisible(!HidePiecesButton.this.piecesVisible);
            }
        };
        this.launch = new LaunchButton(null, TOOLTIP, BUTTON_TEXT, HOTKEY, LAUNCH_ICON, al);
        this.launch.setAttribute(TOOLTIP, "Hide all pieces on this map");
        this.addMouseListener(this);
    }

    @Override
    public void addTo(Buildable b) {
        this.map = (Map)b;
        GameModule.getGameModule().getGameState().addGameComponent(this);
        this.map.addDrawComponent(this);
        this.map.getToolBar().add(this.launch);
        if (b instanceof Translatable) {
            this.getI18nData().setOwningComponent((Translatable)b);
        }
    }

    protected void setPiecesVisible(boolean visible) {
        this.map.setPiecesVisible(visible);
        this.launch.setAttribute(LAUNCH_ICON, visible ? this.showingIcon : this.hiddenIcon);
        this.piecesVisible = visible;
        this.map.repaint();
    }

    @Override
    public void add(Buildable b) {
    }

    @Override
    public void remove(Buildable b) {
    }

    @Override
    public void removeFrom(Buildable b) {
        this.map = (Map)b;
        this.map.removeDrawComponent(this);
        this.map.getToolBar().remove(this.launch);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (SHOWING_ICON.equals(key)) {
            this.showingIcon = (String)value;
        } else if (HIDDEN_ICON.equals(key)) {
            this.hiddenIcon = (String)value;
        } else {
            this.launch.setAttribute(key, value);
        }
    }

    @Override
    public void build(Element e) {
        AutoConfigurable.Util.buildAttributes(e, this);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{BUTTON_TEXT, TOOLTIP, HOTKEY, SHOWING_ICON, HIDDEN_ICON};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        return null;
    }

    @Override
    public String getAttributeValueString(String key) {
        String s = null;
        s = HIDDEN_ICON.equals(key) ? this.hiddenIcon : (SHOWING_ICON.equals(key) ? this.showingIcon : this.launch.getAttributeValueString(key));
        return s;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.hotkey_label"), Resources.getString("Editor.HidePieceButton.show_icon"), Resources.getString("Editor.HidePieceButton.hide_icon")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, NamedKeyStroke.class, ShowingIconConfig.class, HiddenIconConfig.class};
    }

    @Override
    public void draw(Graphics g, Map m) {
        this.repaint();
    }

    @Override
    public boolean drawAboveCounters() {
        return false;
    }

    @Override
    public void paint(Graphics g) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        return null;
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    @Override
    public void setup(boolean show) {
        if (show) {
            this.setPiecesVisible(true);
        }
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.HidePieceButton.component_type");
    }

    @Override
    public String getConfigureName() {
        return null;
    }

    @Override
    public Configurer getConfigurer() {
        return new AutoConfigurer(this);
    }

    @Override
    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "HidePieces");
    }

    @Override
    public Element getBuildElement(Document doc) {
        return AutoConfigurable.Util.getBuildElement(doc, this);
    }

    @Override
    public ComponentI18nData getI18nData() {
        if (this.myI18nData == null) {
            this.myI18nData = new ComponentI18nData(this, "HidePieces");
        }
        return this.myI18nData;
    }

    public static class ShowingIconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, HidePiecesButton.DEFAULT_SHOWING_ICON);
        }
    }

    public static class HiddenIconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, HidePiecesButton.DEFAULT_HIDDEN_ICON);
        }
    }
}

