/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.jabber;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.chat.LockableRoom;
import VASSAL.chat.Player;
import VASSAL.chat.SimpleRoom;
import VASSAL.chat.SimpleStatus;
import VASSAL.chat.jabber.JabberClient;
import VASSAL.chat.jabber.JabberPlayer;
import VASSAL.i18n.Resources;
import VASSAL.tools.PropertiesEncoder;
import VASSAL.tools.swing.Dialogs;
import VASSAL.tools.version.VersionUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.RoomInfo;

public class JabberRoom
extends SimpleRoom
implements LockableRoom {
    public static final String CONFIG_NAME = "name";
    public static final String CONFIG_LOCKED = "locked";
    public static final String CONFIG_VASSAL_VERSION = "vasVer";
    public static final String CONFIG_MIN_VASSAL_VERSION = "minVasVer";
    public static final String CONFIG_MODULE_VERSION = "modVer";
    public static final String CONFIG_MIN_MODULE_VERSION = "minModVer";
    public static final String CONFIG_CRC_CHECK = "crcCheck";
    public static final String CONFIG_CRC = "crc";
    private static final String JABBER_MEMBERSONLY = "muc#roomconfig_membersonly";
    private static final String JABBER_ALLOW_INVITES = "muc#roomconfig_allowinvites";
    private static final String JABBER_CHANGE_SUBJECT = "muc#roomconfig_changesubject";
    private static final String JABBER_MODERATED = "muc#roomconfig_moderatedroom";
    private static final String JABBER_PASSWORD_PROTECTED = "muc#roomconfig_passwordprotectedroom";
    private static final String JABBER_PERSISTENT = "muc#roomconfig_persistentroom";
    private static final String JABBER_PUBLIC_ROOM = "muc#roomconfig_publicroom";
    private String jid;
    private RoomInfo info;
    private boolean ownedByMe;
    private JabberClient client;
    private ArrayList<String> owners = new ArrayList();
    private Properties config = new Properties();
    private static final String MINIMUM_OPTION = "min";
    private static final String ANY_OPTION = "any";
    private static final String THIS_OPTION = "this";
    private static final String MINIMUM_VERSION = Resources.getString("Chat.mimimum_version");
    private static final String ANY_VERSION = Resources.getString("Chat.any_version");
    private static final String THIS_VERSION = Resources.getString("Chat.this_version");

    private JabberRoom(String name, String jid, RoomInfo info, JabberClient client) {
        super(name);
        this.jid = jid;
        this.info = info;
        this.client = client;
        this.config.clear();
        this.config.put(CONFIG_NAME, name);
    }

    public String getJID() {
        return this.jid;
    }

    @Override
    public boolean isLocked() {
        return this.info != null && this.info.isMembersOnly();
    }

    public void setInfo(RoomInfo info) {
        this.info = info;
    }

    public void toggleLock(MultiUserChat muc) {
        try {
            if (!this.isLocked()) {
                this.lock(muc);
            } else {
                this.unlock(muc);
            }
            this.info = MultiUserChat.getRoomInfo((XMPPConnection)this.client.getConnection(), (String)this.jid);
        }
        catch (XMPPException e) {
            e.printStackTrace();
            return;
        }
    }

    protected void lock(MultiUserChat muc) throws XMPPException {
        Form form = muc.getConfigurationForm().createAnswerForm();
        form.setAnswer(JABBER_MEMBERSONLY, true);
        muc.sendConfigurationForm(form);
    }

    protected void unlock(MultiUserChat muc) throws XMPPException {
        Form form = muc.getConfigurationForm().createAnswerForm();
        form.setAnswer(JABBER_MEMBERSONLY, false);
        muc.sendConfigurationForm(form);
    }

    public MultiUserChat join(JabberClient client, JabberPlayer me) throws XMPPException {
        MultiUserChat chat;
        block3: {
            chat = new MultiUserChat(client.getConnection(), this.getJID());
            chat.join(StringUtils.parseName((String)me.getJid()));
            if (!chat.isJoined()) {
                return null;
            }
            try {
                Form configForm = chat.getConfigurationForm().createAnswerForm();
                configForm.setAnswer(JABBER_MEMBERSONLY, this.isStartLocked());
                configForm.setAnswer(JABBER_ALLOW_INVITES, false);
                configForm.setAnswer(JABBER_CHANGE_SUBJECT, false);
                configForm.setAnswer(JABBER_MODERATED, false);
                configForm.setAnswer(JABBER_PASSWORD_PROTECTED, false);
                configForm.setAnswer(JABBER_PERSISTENT, false);
                configForm.setAnswer(JABBER_PUBLIC_ROOM, true);
                chat.sendConfigurationForm(configForm);
                this.ownedByMe = true;
                this.owners.clear();
                this.addOwner(this.jid);
            }
            catch (XMPPException e) {
                if (e.getXMPPError() == null || e.getXMPPError().getCode() == 403) break block3;
                throw e;
            }
        }
        chat.addMessageListener((PacketListener)client);
        return chat;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof JabberRoom) {
            JabberRoom r = (JabberRoom)o;
            return r.jid.equals(this.jid);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.jid.hashCode();
    }

    public boolean isOwnedByMe() {
        return this.ownedByMe;
    }

    @Override
    public boolean isOwner(String jid) {
        return this.owners.contains(jid);
    }

    public void addOwner(String jid) {
        if (!this.owners.contains(jid)) {
            this.owners.add(jid);
        }
    }

    public void removeOwner(String jid) {
        this.owners.remove(jid);
    }

    @Override
    public Player getOwningPlayer() {
        if (this.owners.size() == 0) {
            return null;
        }
        return this.getPlayer(this.owners.get(0));
    }

    public void setConfig(Properties props) {
        this.config = props;
        this.setName(this.config.getProperty(CONFIG_NAME));
    }

    public String encodeConfig() {
        String s = new PropertiesEncoder(this.config).getStringValue();
        return s == null ? "" : s;
    }

    public void decodeConfig(String s) {
        try {
            this.config = new PropertiesEncoder(s).getProperties();
            this.setName(this.config.getProperty(CONFIG_NAME));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isStartLocked() {
        return "true".equals(this.config.getProperty(CONFIG_LOCKED));
    }

    public boolean isMatchCrc() {
        return "true".equals(this.config.getProperty(CONFIG_CRC_CHECK));
    }

    public String getCheckCrc() {
        return this.config.getProperty(CONFIG_CRC);
    }

    public String getVassalOption() {
        return this.config.getProperty(CONFIG_VASSAL_VERSION, ANY_OPTION);
    }

    public String getVassalVersion() {
        return this.config.getProperty(CONFIG_MIN_VASSAL_VERSION, Info.getVersion());
    }

    public String getModuleOption() {
        return this.config.getProperty(CONFIG_MODULE_VERSION, ANY_OPTION);
    }

    public String getModuleVersion() {
        return this.config.getProperty(CONFIG_MIN_MODULE_VERSION, GameModule.getGameModule().getGameVersion());
    }

    public void showConfig() {
        JabberRoomConfig c = new JabberRoomConfig(this.config, false);
        Dialogs.showDialog(null, Resources.getString("Chat.room_configuration"), c, -1, null, 2, null, null, null, null);
    }

    public String canJoin(JabberPlayer p) {
        if (this.isOwnedByMe()) {
            return null;
        }
        String option = this.getVassalOption();
        if (!ANY_OPTION.equals(option)) {
            String thisVassal = Info.getVersion();
            String targetVassal = this.getVassalVersion();
            if (MINIMUM_OPTION.equals(option)) {
                if (VersionUtils.compareVersions(thisVassal, targetVassal) < 1) {
                    return Resources.getString("Chat.bad_min_vassal", thisVassal, targetVassal);
                }
            } else if (!thisVassal.equals(targetVassal)) {
                return Resources.getString("Chat.bad_vassal", thisVassal, targetVassal);
            }
        }
        if (!ANY_OPTION.equals(option = this.getModuleOption())) {
            String thisModule = GameModule.getGameModule().getGameVersion();
            String targetModule = this.getModuleVersion();
            if (MINIMUM_OPTION.equals(option)) {
                if (VersionUtils.compareVersions(thisModule, targetModule) < 1) {
                    return Resources.getString("Chat.bad_min_module", thisModule, targetModule);
                }
            } else if (!thisModule.equals(targetModule)) {
                return Resources.getString("Chat.bad_module", thisModule, targetModule);
            }
        }
        if (this.isMatchCrc()) {
            String playerCRC = ((SimpleStatus)p.getStatus()).getCrc();
            String moduleCRC = this.getCheckCrc();
            if (!moduleCRC.equals(playerCRC)) {
                return Resources.getString("Chat.bad_crc");
            }
        }
        return null;
    }

    public static Properties configureNewRoom() {
        JabberRoomConfig config = new JabberRoomConfig();
        Integer result = (Integer)Dialogs.showDialog(null, Resources.getString("Chat.create_new_room"), config, -1, null, 2, null, null, null, null);
        if (result != null && result == 0) {
            return config.getProperties();
        }
        return null;
    }

    public static class JabberRoomConfig
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JTextField roomNameConfig;
        private JCheckBox startLockedConfig;
        private JCheckBox matchCrcConfig;
        private JTextField crcConfig;
        private JComboBox<String> vassalVersionConfig;
        private JTextField minimumVassalVersionConfig;
        private JComboBox<String> moduleVersionConfig;
        private JTextField minimumModuleVersionConfig;
        private String vassalVersion = Info.getVersion();
        private String moduleVersion = GameModule.getGameModule().getGameVersion();
        private boolean updateEnabled = true;

        static String versionToOption(String version) {
            if (MINIMUM_VERSION.equals(version)) {
                return JabberRoom.MINIMUM_OPTION;
            }
            if (THIS_VERSION.equals(version)) {
                return JabberRoom.THIS_OPTION;
            }
            return JabberRoom.ANY_OPTION;
        }

        static String optionToVersion(String option) {
            if (JabberRoom.MINIMUM_OPTION.equals(option)) {
                return MINIMUM_VERSION;
            }
            if (JabberRoom.THIS_OPTION.equals(option)) {
                return THIS_VERSION;
            }
            return ANY_VERSION;
        }

        public JabberRoomConfig() {
            this.setLayout((LayoutManager)new MigLayout("insets dialog", "[align right][fill,grow]", ""));
            this.add(new JLabel(Resources.getString("Chat.new_room_name")));
            this.roomNameConfig = new JTextField();
            this.add((Component)this.roomNameConfig, "wrap");
            this.add(new JLabel(Resources.getString("Chat.start_locked")));
            this.startLockedConfig = new JCheckBox();
            this.add((Component)this.startLockedConfig, "wrap");
            this.add(new JLabel(Resources.getString("Chat.vassal_versions_allowed")));
            this.vassalVersionConfig = new JComboBox<String>(new String[]{ANY_VERSION, THIS_VERSION, MINIMUM_VERSION});
            this.vassalVersionConfig.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    this.updateVisibility();
                }
            });
            this.add(this.vassalVersionConfig);
            this.minimumVassalVersionConfig = new JTextField(12);
            this.minimumVassalVersionConfig.setText(this.vassalVersion);
            this.add((Component)this.minimumVassalVersionConfig, "wrap");
            this.add(new JLabel(Resources.getString("Chat.module_versions_allowed")));
            this.moduleVersionConfig = new JComboBox<String>(new String[]{ANY_VERSION, THIS_VERSION, MINIMUM_VERSION});
            this.moduleVersionConfig.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    this.updateVisibility();
                }
            });
            this.add(this.moduleVersionConfig);
            this.minimumModuleVersionConfig = new JTextField(12);
            this.minimumModuleVersionConfig.setText(this.moduleVersion);
            this.add((Component)this.minimumModuleVersionConfig, "wrap");
            this.add(new JLabel(Resources.getString("Chat.crc_match")));
            this.matchCrcConfig = new JCheckBox();
            this.matchCrcConfig.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.updateVisibility();
                }
            });
            this.add(this.matchCrcConfig);
            this.crcConfig = new JTextField(12);
            this.crcConfig.setText(Long.toHexString(GameModule.getGameModule().getCrc()));
            this.crcConfig.setEditable(false);
            this.add((Component)this.crcConfig, "wrap");
            this.updateVisibility();
        }

        public JabberRoomConfig(Properties props) {
            this();
            this.roomNameConfig.setText(props.getProperty(JabberRoom.CONFIG_NAME));
            this.startLockedConfig.setSelected("true".equals(props.getProperty(JabberRoom.CONFIG_LOCKED)));
            this.vassalVersionConfig.setSelectedItem(JabberRoomConfig.optionToVersion(props.getProperty(JabberRoom.CONFIG_VASSAL_VERSION, ANY_VERSION)));
            this.minimumVassalVersionConfig.setText(props.getProperty(JabberRoom.CONFIG_MIN_VASSAL_VERSION, ""));
            this.moduleVersionConfig.setSelectedItem(JabberRoomConfig.optionToVersion(props.getProperty(JabberRoom.CONFIG_MODULE_VERSION, ANY_VERSION)));
            this.minimumModuleVersionConfig.setText(props.getProperty(JabberRoom.CONFIG_MIN_MODULE_VERSION, ""));
            this.matchCrcConfig.setSelected("true".equals(props.getProperty(JabberRoom.CONFIG_CRC_CHECK)));
            this.crcConfig.setText(props.getProperty(JabberRoom.CONFIG_CRC));
        }

        public JabberRoomConfig(Properties props, boolean enabled) {
            this(props);
            this.setEnabled(enabled);
        }

        public boolean isUpdateEnabled() {
            return this.updateEnabled;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.updateEnabled = enabled;
            this.updateVisibility();
        }

        private void updateVisibility() {
            this.minimumVassalVersionConfig.setVisible(!ANY_VERSION.equals(this.vassalVersionConfig.getSelectedItem()));
            this.minimumModuleVersionConfig.setVisible(!ANY_VERSION.equals(this.moduleVersionConfig.getSelectedItem()));
            this.crcConfig.setVisible(this.matchCrcConfig.isSelected());
            this.roomNameConfig.setEditable(this.isUpdateEnabled());
            this.startLockedConfig.setEnabled(this.isUpdateEnabled());
            this.vassalVersionConfig.setEnabled(this.isUpdateEnabled());
            this.minimumVassalVersionConfig.setEditable(this.isUpdateEnabled() && this.vassalVersionConfig.getSelectedItem().equals(MINIMUM_VERSION));
            this.moduleVersionConfig.setEnabled(this.isUpdateEnabled());
            this.minimumModuleVersionConfig.setEditable(this.isUpdateEnabled() && this.moduleVersionConfig.getSelectedItem().equals(MINIMUM_VERSION));
            this.matchCrcConfig.setEnabled(this.isUpdateEnabled());
        }

        public Properties getProperties() {
            Properties props = new Properties();
            props.put(JabberRoom.CONFIG_NAME, this.roomNameConfig.getText());
            props.put(JabberRoom.CONFIG_LOCKED, Boolean.toString(this.startLockedConfig.isSelected()));
            String vv = JabberRoomConfig.versionToOption((String)this.vassalVersionConfig.getSelectedItem());
            props.put(JabberRoom.CONFIG_VASSAL_VERSION, vv);
            if (!vv.equals(JabberRoom.ANY_OPTION)) {
                props.put(JabberRoom.CONFIG_MIN_VASSAL_VERSION, this.minimumVassalVersionConfig.getText());
            }
            String mv = JabberRoomConfig.versionToOption((String)this.moduleVersionConfig.getSelectedItem());
            props.put(JabberRoom.CONFIG_MODULE_VERSION, mv);
            if (!mv.equals(JabberRoom.ANY_OPTION)) {
                props.put(JabberRoom.CONFIG_MIN_MODULE_VERSION, this.minimumModuleVersionConfig.getText());
            }
            props.put(JabberRoom.CONFIG_CRC_CHECK, Boolean.toString(this.matchCrcConfig.isSelected()));
            if (this.matchCrcConfig.isSelected()) {
                props.put(JabberRoom.CONFIG_CRC, this.crcConfig.getText());
            }
            return props;
        }
    }

    public static class Manager {
        private Map<String, JabberRoom> jidToRoom = new HashMap<String, JabberRoom>();

        public JabberRoom getRoomByJID(JabberClient client, String jid) {
            return this.getRoomByJID(client, jid, "");
        }

        public synchronized JabberRoom getRoomByJID(JabberClient client, String jid, String defaultName) {
            if (jid == null) {
                return null;
            }
            JabberRoom newRoom = this.jidToRoom.get(jid);
            if (newRoom == null) {
                String roomName = defaultName == null ? "" : defaultName;
                RoomInfo info = null;
                try {
                    info = MultiUserChat.getRoomInfo((XMPPConnection)client.getConnection(), (String)jid);
                }
                catch (XMPPException e) {
                    e.printStackTrace();
                }
                newRoom = new JabberRoom(roomName, jid, info, client);
                this.jidToRoom.put(jid, newRoom);
            }
            return newRoom;
        }

        public synchronized JabberRoom getRoomByName(JabberClient client, String name) {
            String jid = StringUtils.escapeNode((String)(client.getModule() + "-" + name)).toLowerCase() + "@" + client.getConferenceService();
            JabberRoom room = this.jidToRoom.get(jid);
            if (room == null) {
                room = new JabberRoom(name, jid, null, client);
                this.jidToRoom.put(jid, room);
            }
            return room;
        }

        public void deleteRoom(String jid) {
            this.jidToRoom.remove(jid);
        }

        public synchronized void clear() {
            this.jidToRoom.clear();
        }
    }
}

