/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.Configurable;
import VASSAL.build.module.ExtensionElement;
import VASSAL.build.module.ModuleExtension;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.build.widget.PieceSlot;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.PropertiesWindow;
import VASSAL.launch.EditorWindow;
import VASSAL.tools.ReflectionUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ExtensionTree
extends ConfigureTree {
    private static final long serialVersionUID = 1L;
    private ModuleExtension extension;

    public ExtensionTree(Configurable root, HelpWindow helpWindow, ModuleExtension extention, EditorWindow editorWindow) {
        super(root, helpWindow, editorWindow);
        this.extension = extention;
        this.setCellRenderer(new ExtensionRenderer());
    }

    private boolean isEditable(DefaultMutableTreeNode node) {
        if (node != null) {
            for (ExtensionElement el : this.extension.getComponentsOf(ExtensionElement.class)) {
                if (el.getExtension() != node.getUserObject()) continue;
                return true;
            }
            if (node.getParent() instanceof DefaultMutableTreeNode) {
                return this.isEditable((DefaultMutableTreeNode)node.getParent());
            }
        }
        return false;
    }

    public Configurable[] getPath(DefaultMutableTreeNode node) {
        Object[] nodePath = node.getUserObjectPath();
        Configurable[] path = new Configurable[nodePath.length - 1];
        for (int i = 0; i < path.length; ++i) {
            path[i] = (Configurable)nodePath[i + 1];
        }
        return path;
    }

    @Override
    public void externalInsert(Configurable parent, Configurable child) {
        super.externalInsert(parent, child);
        if (!this.isEditable(parent)) {
            this.extension.add(new ExtensionElement(child, this.getPath(this.getTreeNode(parent))));
        }
    }

    @Override
    protected Action buildAddAction(final Configurable target, final Class<? extends Buildable> newConfig) {
        return new AbstractAction("Add " + ExtensionTree.getConfigureName(newConfig)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                Configurable ch = null;
                try {
                    ch = (Configurable)newConfig.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    ReflectionUtils.handleNewInstanceFailure(t, newConfig);
                }
                if (ch != null) {
                    final Configurable child = ch;
                    child.build(null);
                    if (child instanceof PieceSlot) {
                        ((PieceSlot)child).updateGpId(ExtensionTree.this.extension);
                    }
                    if (child.getConfigurer() != null) {
                        if (ExtensionTree.this.insert(target, child, ExtensionTree.this.getTreeNode(target).getChildCount())) {
                            PropertiesWindow w = new PropertiesWindow((Frame)SwingUtilities.getAncestorOfClass(Frame.class, ExtensionTree.this), false, child, ExtensionTree.this.helpWindow){
                                private static final long serialVersionUID = 1L;

                                @Override
                                public void save() {
                                    super.save();
                                    if (!ExtensionTree.this.isEditable(target)) {
                                        ExtensionElement el = new ExtensionElement(child, ExtensionTree.this.getPath(ExtensionTree.this.getTreeNode(target)));
                                        ExtensionTree.this.extension.add(el);
                                    }
                                }

                                @Override
                                public void cancel() {
                                    ExtensionTree.this.remove(target, child);
                                    this.dispose();
                                }
                            };
                            w.setVisible(true);
                        }
                    } else {
                        boolean inserted = ExtensionTree.this.insert(target, child, ExtensionTree.this.getTreeNode(target).getChildCount());
                        if (inserted && !ExtensionTree.this.isEditable(ExtensionTree.this.getTreeNode(target))) {
                            ExtensionTree.this.extension.add(new ExtensionElement(child, ExtensionTree.this.getPath(ExtensionTree.this.getTreeNode(target))));
                        }
                    }
                }
            }
        };
    }

    @Override
    protected Action buildImportAction(final Configurable target) {
        AbstractAction a = new AbstractAction("Add Imported Class"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                final Configurable child = ExtensionTree.this.importConfigurable();
                if (child != null) {
                    try {
                        child.build(null);
                        final Configurable c = target;
                        if (child.getConfigurer() != null) {
                            PropertiesWindow w = new PropertiesWindow((Frame)SwingUtilities.getAncestorOfClass(Frame.class, ExtensionTree.this), false, child, ExtensionTree.this.helpWindow){
                                private static final long serialVersionUID = 1L;

                                @Override
                                public void save() {
                                    super.save();
                                    ExtensionTree.this.insert(c, child, ExtensionTree.this.getTreeNode(c).getChildCount());
                                    if (!ExtensionTree.this.isEditable(target)) {
                                        ExtensionElement el = new ExtensionElement(child, ExtensionTree.this.getPath(ExtensionTree.this.getTreeNode(target)));
                                        ExtensionTree.this.extension.add(el);
                                    }
                                }

                                @Override
                                public void cancel() {
                                    this.dispose();
                                }
                            };
                            w.setVisible(true);
                        } else {
                            ExtensionTree.this.insert(c, child, ExtensionTree.this.getTreeNode(c).getChildCount());
                        }
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(ExtensionTree.this.getTopLevelAncestor(), "Error adding " + ConfigureTree.getConfigureName(child) + " to " + ConfigureTree.getConfigureName(target) + "\n" + ex.getMessage(), "Illegal configuration", 0);
                    }
                }
            }
        };
        return a;
    }

    private boolean isEditable(Configurable target) {
        return this.isEditable(this.getTreeNode(target));
    }

    @Override
    protected Action buildEditAction(Configurable target) {
        return this.isEditable(target) ? super.buildEditAction(target) : null;
    }

    @Override
    protected Action buildCutAction(Configurable target) {
        return this.isEditable(target) ? super.buildCutAction(target) : null;
    }

    @Override
    protected Action buildPasteAction(final Configurable target) {
        Action a = null;
        if (this.isEditable(target)) {
            a = super.buildPasteAction(target);
        } else {
            a = new AbstractAction("Paste"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ExtensionTree.this.cutData != null) {
                        DefaultMutableTreeNode targetNode = ExtensionTree.this.getTreeNode(target);
                        Configurable cutTarget = (Configurable)ExtensionTree.this.cutData.getUserObject();
                        if (ExtensionTree.this.remove(ExtensionTree.this.getParent(ExtensionTree.this.cutData), cutTarget) && ExtensionTree.this.insert(target, cutTarget, targetNode.getChildCount())) {
                            ExtensionTree.this.extension.add(new ExtensionElement(cutTarget, ExtensionTree.this.getPath(targetNode)));
                        }
                    } else if (ExtensionTree.this.copyData != null) {
                        Configurable copyTarget = (Configurable)ExtensionTree.this.copyData.getUserObject();
                        Configurable clone = null;
                        try {
                            clone = (Configurable)copyTarget.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Throwable t) {
                            ReflectionUtils.handleNewInstanceFailure(t, copyTarget.getClass());
                        }
                        if (clone != null) {
                            clone.build(copyTarget.getBuildElement(Builder.createNewDocument()));
                            if (ExtensionTree.this.insert(target, clone, ExtensionTree.this.getTreeNode(target).getChildCount())) {
                                ExtensionTree.this.updateGpIds(clone);
                                ExtensionTree.this.extension.add(new ExtensionElement(clone, ExtensionTree.this.getPath(ExtensionTree.this.getTreeNode(target))));
                            }
                        }
                    }
                    ExtensionTree.this.cutData = null;
                    ExtensionTree.this.updateEditMenu();
                }
            };
            a.setEnabled(this.isValidPasteTarget(target));
        }
        return a;
    }

    @Override
    protected boolean isValidPasteTarget(Configurable target) {
        return this.cutData != null && super.isValidParent(target, (Configurable)this.cutData.getUserObject()) && this.isEditable(this.getParent(this.cutData)) || this.copyData != null && super.isValidParent(target, (Configurable)this.copyData.getUserObject());
    }

    @Override
    public void updateGpIds(Configurable c) {
        if (c instanceof PieceSlot) {
            ((PieceSlot)c).updateGpId(this.extension);
        } else {
            for (Configurable conf : c.getConfigureComponents()) {
                this.updateGpIds(conf);
            }
        }
    }

    @Override
    protected Action buildMoveAction(Configurable target) {
        return this.isEditable((DefaultMutableTreeNode)this.getTreeNode(target).getParent()) ? super.buildMoveAction(target) : null;
    }

    @Override
    protected Action buildDeleteAction(final Configurable target) {
        AbstractAction action = null;
        DefaultMutableTreeNode targetNode = this.getTreeNode(target);
        if (targetNode.getParent() != null && this.isEditable(targetNode)) {
            final Configurable parent = (Configurable)((DefaultMutableTreeNode)targetNode.getParent()).getUserObject();
            action = new AbstractAction("Delete"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    boolean removed = ExtensionTree.this.remove(parent, target);
                    if (removed && !ExtensionTree.this.isEditable(parent)) {
                        for (ExtensionElement el : ExtensionTree.this.extension.getComponentsOf(ExtensionElement.class)) {
                            if (el.getExtension() != target) continue;
                            ExtensionTree.this.extension.remove(el);
                            break;
                        }
                    }
                }
            };
        }
        return action;
    }

    @Override
    protected Action buildCloneAction(final Configurable target) {
        DefaultMutableTreeNode targetNode = this.getTreeNode(target);
        final DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)targetNode.getParent();
        if (this.isEditable(parentNode)) {
            return super.buildCloneAction(target);
        }
        if (parentNode != null) {
            return new AbstractAction("Clone"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Configurable clone = null;
                    try {
                        clone = (Configurable)target.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Throwable t) {
                        ReflectionUtils.handleNewInstanceFailure(t, target.getClass());
                    }
                    if (clone != null) {
                        clone.build(target.getBuildElement(Builder.createNewDocument()));
                        if (ExtensionTree.this.insert((Configurable)parentNode.getUserObject(), clone, parentNode.getChildCount())) {
                            ExtensionTree.this.extension.add(new ExtensionElement(clone, ExtensionTree.this.getPath(parentNode)));
                        }
                    }
                }
            };
        }
        return null;
    }

    @Override
    protected Action buildEditPiecesAction(Configurable target) {
        Action a = null;
        if (this.isEditable(target)) {
            a = super.buildEditPiecesAction(target);
        }
        return a;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        if (path != null && this.isEditable((DefaultMutableTreeNode)path.getLastPathComponent())) {
            super.mousePressed(e);
        }
    }

    @Override
    protected boolean isValidParent(Configurable parent, Configurable child) {
        return super.isValidParent(parent, child) && this.isEditable(parent);
    }

    @Override
    protected void updateEditMenu() {
        super.updateEditMenu();
        this.deleteAction.setEnabled(this.selected != null && this.isEditable(this.selected));
        this.cutAction.setEnabled(this.selected != null && this.isEditable(this.selected));
        this.propertiesAction.setEnabled(this.selected != null && this.isEditable(this.selected) && this.selected.getConfigurer() != null);
    }

    class ExtensionRenderer
    extends ConfigureTree.Renderer {
        private static final long serialVersionUID = 1L;

        ExtensionRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            c.setForeground(ExtensionTree.this.isEditable((DefaultMutableTreeNode)value) ? Color.BLACK : Color.GRAY);
            return c;
        }
    }
}

