/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.ArrayUtils;

public class StringArrayConfigurer
extends Configurer {
    protected JPanel panel;
    protected JList<String> list;
    protected DefaultListModel<String> model;
    private static final String[] EMPTY = new String[0];
    protected JTextField textField;

    public StringArrayConfigurer(String key, String name, Object val) {
        super(key, name, val);
    }

    public StringArrayConfigurer(String key, String name) {
        super(key, name);
    }

    public DefaultListModel<String> getModel() {
        return this.model;
    }

    public void addValue(String s) {
        Object[] objectArray;
        if (this.value == null) {
            String[] stringArray = new String[1];
            objectArray = stringArray;
            stringArray[0] = s;
        } else {
            objectArray = ArrayUtils.add((Object[])((String[])this.value), (Object)s);
        }
        this.setValue(objectArray);
    }

    public void removeValue(String s) {
        String[] newValue;
        Object[] oldValue = this.getStringArray();
        if (oldValue != (newValue = (String[])ArrayUtils.removeElement((Object[])oldValue, (Object)s))) {
            this.setValue(newValue);
        }
    }

    @Override
    public Component getControls() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setBorder(new TitledBorder(this.name));
            this.panel.setLayout((LayoutManager)new MigLayout("fill"));
            Box buttonBox = Box.createHorizontalBox();
            Box leftBox = Box.createVerticalBox();
            this.model = new DefaultListModel();
            this.updateModel();
            this.list = new JList<String>(this.model);
            this.list.setPrototypeCellValue("MMMMMMMM");
            this.list.setVisibleRowCount(2);
            this.list.setSelectionMode(0);
            JButton addButton = new JButton(Resources.getString("General.add"));
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = StringArrayConfigurer.this.getTextValue();
                    StringArrayConfigurer.this.addValue(s);
                    StringArrayConfigurer.this.setTextValue("");
                }
            });
            buttonBox.add(addButton);
            JButton removeButton = new JButton(Resources.getString("General.remove"));
            removeButton.addActionListener(e -> this.list.getSelectedValuesList().forEach(this::removeValue));
            buttonBox.add(removeButton);
            JButton insertButton = new JButton(Resources.getString("General.insert"));
            ActionListener insertAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (StringArrayConfigurer.this.value == null) {
                        StringArrayConfigurer.this.addValue(StringArrayConfigurer.this.getTextValue());
                    } else {
                        int pos = StringArrayConfigurer.this.list.getSelectedIndex();
                        if (pos < 0) {
                            pos = StringArrayConfigurer.this.list.getModel().getSize();
                        }
                        StringArrayConfigurer.this.setValue(ArrayUtils.insert((int)pos, (Object[])((String[])StringArrayConfigurer.this.value), (Object[])new String[]{StringArrayConfigurer.this.getTextValue()}));
                        StringArrayConfigurer.this.setTextValue("");
                        StringArrayConfigurer.this.list.setSelectedIndex(pos + 1);
                    }
                }
            };
            insertButton.addActionListener(insertAction);
            buttonBox.add(insertButton);
            Component textComponent = this.getTextComponent();
            this.addTextActionListener(insertAction);
            leftBox.add(textComponent);
            leftBox.add(buttonBox);
            JSplitPane pane = new JSplitPane(1);
            pane.setLeftComponent(leftBox);
            pane.setRightComponent(new ScrollPane(this.list));
            this.panel.add((Component)pane, "grow");
        }
        return this.panel;
    }

    protected Component getTextComponent() {
        if (this.textField == null) {
            this.textField = new JTextField(8);
            this.textField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.textField.getPreferredSize().height));
        }
        return this.textField;
    }

    protected String getTextValue() {
        return this.textField.getText();
    }

    protected void setTextValue(String s) {
        this.textField.setText(s);
    }

    protected void addTextActionListener(ActionListener a) {
        this.textField.addActionListener(a);
    }

    public String[] getStringArray() {
        if (this.value instanceof String[]) {
            return (String[])this.value;
        }
        return EMPTY;
    }

    @Override
    public String getValueString() {
        return StringArrayConfigurer.arrayToString(this.getStringArray());
    }

    public static String arrayToString(String[] s) {
        if (s == null || s.length == 0) {
            return "";
        }
        SequenceEncoder se = new SequenceEncoder(',');
        for (String item : s) {
            se.append(item != null ? item : "");
        }
        return se.getValue();
    }

    @Override
    public void setValue(Object o) {
        if (o == null) {
            o = EMPTY;
        }
        super.setValue(o);
        this.updateModel();
    }

    @Override
    public void setValue(String s) {
        String[] val = StringArrayConfigurer.stringToArray(s);
        this.setValue(val);
    }

    public static String[] stringToArray(String s) {
        if (s == null || s.length() == 0) {
            return EMPTY;
        }
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ',');
        ArrayList<String> l = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        return l.toArray(new String[0]);
    }

    protected void updateModel() {
        if (this.model != null) {
            String[] s;
            this.model.removeAllElements();
            for (String item : s = this.getStringArray()) {
                this.model.addElement(item);
            }
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        final StringArrayConfigurer c = new StringArrayConfigurer(null, "Visible to these players:  ");
        c.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                System.err.println(c.getName() + " = " + c.getValueString());
            }
        });
        c.setValue("Rack,Shack,Benny");
        f.add(c.getControls());
        f.pack();
        f.setVisible(true);
    }
}

