/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.MovementReporter;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.MoveTracker;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.DoubleConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class Pivot
extends Decorator
implements TranslatablePiece {
    public static final String ID = "pivot;";
    public static final String DEGREES = "_Degrees";
    protected int pivotX;
    protected int pivotY;
    protected double angle;
    protected String command;
    protected NamedKeyStroke key;
    protected boolean fixedAngle;
    protected KeyCommand[] commands;
    protected KeyCommand pivotCommand;
    protected FreeRotator rotator;

    public Pivot() {
        this(ID, null);
    }

    public Pivot(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public String getDescription() {
        return "Can Pivot";
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Pivot.htm");
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.command = st.nextToken("Pivot");
        this.key = st.nextNamedKeyStroke(null);
        this.pivotX = st.nextInt(0);
        this.pivotY = st.nextInt(0);
        this.fixedAngle = st.nextBoolean(true);
        this.angle = st.nextDouble(90.0);
        this.commands = null;
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.pivotCommand = new KeyCommand(this.command, this.key, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.commands = this.command.length() > 0 && this.key != null && !this.key.isNull() ? new KeyCommand[]{this.pivotCommand} : new KeyCommand[0];
            this.rotator = (FreeRotator)Decorator.getDecorator(this, FreeRotator.class);
            this.pivotCommand.setEnabled(this.rotator != null);
        }
        return this.commands;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.command).append(this.key).append(this.pivotX).append(this.pivotY).append(this.fixedAngle).append(this.angle);
        return ID + se.getValue();
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        Command c = null;
        if (this.pivotCommand.matches(stroke)) {
            if (this.fixedAngle) {
                ChangeTracker t = new ChangeTracker(this);
                double oldAngle = this.rotator.getAngle();
                this.rotator.setAngle(oldAngle - this.angle);
                double newAngle = this.rotator.getAngle();
                if (this.getMap() != null) {
                    c = Pivot.setOldProperties(this);
                    Point pos = this.getPosition();
                    this.pivotPoint(pos, -Math.PI * oldAngle / 180.0, -Math.PI * newAngle / 180.0);
                    GamePiece outer = Decorator.getOutermost(this);
                    if (!Boolean.TRUE.equals(outer.getProperty("IgnoreGrid"))) {
                        pos = this.getMap().snapTo(pos);
                    }
                    outer.setProperty("Moved", Boolean.TRUE);
                    c = c.append(t.getChangeCommand());
                    MoveTracker moveTracker = new MoveTracker(outer);
                    this.getMap().placeOrMerge(outer, pos);
                    c = c.append(moveTracker.getMoveCommand());
                    MovementReporter r = new MovementReporter(c);
                    Command reportCommand = r.getReportCommand();
                    if (reportCommand != null) {
                        reportCommand.execute();
                    }
                    c = c.append(reportCommand);
                    c = c.append(r.markMovedPieces());
                    this.getMap().ensureVisible(this.getMap().selectionBoundsOf(outer));
                } else {
                    c = t.getChangeCommand();
                }
            } else if (this.getMap() != null) {
                Pivot.setOldProperties(this);
                double oldAngle = this.rotator.getAngleInRadians();
                Point2D.Double pivot2D = new Point2D.Double(this.pivotX, this.pivotY);
                AffineTransform t = AffineTransform.getRotateInstance(oldAngle);
                t.transform(pivot2D, pivot2D);
                this.rotator.beginInteractiveRotate();
                this.rotator.setPivot(this.getPosition().x + (int)Math.round(((Point2D)pivot2D).getX()), this.getPosition().y + (int)Math.round(((Point2D)pivot2D).getY()));
            }
        }
        if (c != null && this.getMap() != null && this.getMap().getMoveKey() != null) {
            c.append(Decorator.getOutermost(this).keyEvent(this.getMap().getMoveKey()));
        }
        return c;
    }

    private void pivotPoint(Point p, double oldAngle, double newAngle) {
        Point2D.Double pivot2D = new Point2D.Double(this.pivotX, this.pivotY);
        AffineTransform t = AffineTransform.getRotateInstance(oldAngle);
        t.transform(pivot2D, pivot2D);
        t = AffineTransform.getRotateInstance(newAngle - oldAngle, ((Point2D)pivot2D).getX(), ((Point2D)pivot2D).getY());
        Point2D.Float newPos2D = new Point2D.Float(0.0f, 0.0f);
        t.transform(newPos2D, newPos2D);
        p.x += (int)Math.round(((Point2D)newPos2D).getX());
        p.y += (int)Math.round(((Point2D)newPos2D).getY());
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Rectangle boundingBox() {
        return this.getInner().boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.getInner().draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.getInner().getName();
    }

    @Override
    public Shape getShape() {
        return this.getInner().getShape();
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.command, "Pivot command");
    }

    public static class Ed
    implements PieceEditor {
        private StringConfigurer command;
        private NamedHotKeyConfigurer key;
        private IntConfigurer xOff;
        private IntConfigurer yOff;
        private DoubleConfigurer angle;
        private BooleanConfigurer fixedAngle;
        private JPanel controls = new JPanel();

        public Ed(Pivot p) {
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.command = new StringConfigurer(null, "Command:  ", p.command);
            this.controls.add(this.command.getControls());
            this.key = new NamedHotKeyConfigurer(null, "Keyboard command:  ", p.key);
            this.controls.add(this.key.getControls());
            Box b = Box.createHorizontalBox();
            this.xOff = new IntConfigurer(null, "Pivot point:  ", (Integer)p.pivotX);
            b.add(this.xOff.getControls());
            this.yOff = new IntConfigurer(null, ", ", (Integer)p.pivotY);
            b.add(this.yOff.getControls());
            this.controls.add(b);
            this.fixedAngle = new BooleanConfigurer(null, "Pivot through fixed angle?", (Boolean)p.fixedAngle);
            this.controls.add(this.fixedAngle.getControls());
            this.angle = new DoubleConfigurer(null, "Angle:  ", p.angle);
            this.controls.add(this.angle.getControls());
            this.angle.getControls().setVisible(p.fixedAngle);
            this.fixedAngle.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    angle.getControls().setVisible(Boolean.TRUE.equals(fixedAngle.getValue()));
                }
            });
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.command.getValueString()).append(this.key.getValueString()).append(this.xOff.getValueString()).append(this.yOff.getValueString()).append(Boolean.TRUE.equals(this.fixedAngle.getValue())).append(this.angle.getValueString());
            return Pivot.ID + se.getValue();
        }
    }
}

