/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.DrawPile;
import VASSAL.command.Command;
import VASSAL.configure.ChooseComponentDialog;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.UniqueIdManager;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ReturnToDeck
extends Decorator
implements TranslatablePiece {
    public static final String ID = "return;";
    protected String deckId;
    protected String returnCommand;
    protected String selectDeckPrompt = "Select destination";
    protected NamedKeyStroke returnKey;
    protected DrawPile deck;
    protected KeyCommand[] commands;
    protected KeyCommand myCommand;

    public ReturnToDeck() {
        this("return;Return to Deck;R;", null);
    }

    public ReturnToDeck(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.myCommand = new KeyCommand(this.returnCommand, this.returnKey, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.commands = this.returnCommand.length() > 0 && this.returnKey != null && !this.returnKey.isNull() ? new KeyCommand[]{this.myCommand} : new KeyCommand[0];
        }
        return this.commands;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public void mySetType(String s) {
        s = s.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ';');
        this.returnCommand = st.nextToken();
        this.returnKey = st.nextNamedKeyStroke(null);
        this.deckId = st.nextToken("");
        this.selectDeckPrompt = st.nextToken(this.selectDeckPrompt);
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        return ID + se.append(this.returnCommand).append(this.returnKey).append(this.deckId).append(this.selectDeckPrompt).getValue();
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        Command comm = null;
        if (this.myCommand.matches(stroke)) {
            DrawPile pile = this.deck;
            if (pile == null || this.deckId.length() == 0) {
                pile = this.findDeck();
            }
            if (pile == null) {
                return null;
            }
            Map preMap = this.getMap();
            Point prePos = this.getPosition();
            comm = ReturnToDeck.setOldProperties(this);
            comm = comm.append(pile.addToContents(Decorator.getOutermost(this)));
            Map m = pile.getMap();
            if (!(m == null || m.getMoveKey() == null || m == preMap && this.getPosition().equals(prePos))) {
                comm.append(Decorator.getOutermost(this).keyEvent(m.getMoveKey()));
            }
            pile.getMap().repaint();
        }
        return comm;
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    private DrawPile findDeck() {
        DrawPile pile = null;
        if (this.deckId.length() > 0) {
            pile = DrawPile.findDrawPile(this.deckId);
        }
        if (pile == null) {
            return this.promptForDrawPile();
        }
        this.deck = pile;
        return pile;
    }

    private DrawPile promptForDrawPile() {
        final JDialog d = new JDialog((Frame)GameModule.getGameModule().getPlayerWindow(), true);
        d.setTitle(Decorator.getInnermost(this).getName());
        d.setLayout(new BoxLayout(d.getContentPane(), 1));
        List<DrawPile> piles = GameModule.getGameModule().getAllDescendantComponentsOf(DrawPile.class);
        if (piles.size() == 0) {
            ReturnToDeck.reportDataError(this, "No decks in module.");
            return null;
        }
        class AvailableDeck {
            private DrawPile pile;

            public AvailableDeck(DrawPile pile) {
                this.pile = pile;
            }

            public String toString() {
                return this.pile.getConfigureName();
            }
        }
        AvailableDeck[] decks = new AvailableDeck[piles.size()];
        int i = 0;
        for (DrawPile p : piles) {
            decks[i++] = new AvailableDeck(p);
        }
        final JList<AvailableDeck> list = new JList<AvailableDeck>(decks);
        list.setSelectionMode(0);
        JLabel prompt = new JLabel(this.selectDeckPrompt);
        prompt.setAlignmentX(0.5f);
        d.add(prompt);
        d.add(new ScrollPane(list));
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(0.5f);
        JButton b = new JButton(Resources.getString("General.ok"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AvailableDeck selection = (AvailableDeck)list.getSelectedValue();
                if (selection != null) {
                    ReturnToDeck.this.deck = selection.pile;
                }
                d.dispose();
            }
        });
        box.add(b);
        b = new JButton(Resources.getString("General.cancel"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                d.dispose();
            }
        });
        box.add(b);
        d.add(box);
        d.pack();
        d.setLocationRelativeTo(d.getOwner());
        d.setVisible(true);
        DrawPile pile = this.deck;
        this.deck = null;
        return pile;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public String getDescription() {
        Object d = "Return to Deck";
        if (this.deck != null) {
            this.findDeck();
            if (this.deck != null) {
                d = (String)d + " - " + this.deck.getConfigureName();
            }
        }
        return d;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ReturnToDeck.htm");
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.returnCommand, "Return to Deck command");
    }

    private static class Ed
    implements PieceEditor {
        private StringConfigurer menuName;
        private NamedHotKeyConfigurer menuKey;
        private JPanel controls;
        private String deckId;
        private final JTextField tf = new JTextField(12);
        private StringConfigurer promptText;
        private JCheckBox prompt;

        public Ed(ReturnToDeck p) {
            this.controls = new JPanel();
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.menuName = new StringConfigurer(null, "Menu Text:  ", p.returnCommand);
            this.controls.add(this.menuName.getControls());
            this.menuKey = new NamedHotKeyConfigurer(null, "Keyboard Command:  ", p.returnKey);
            this.deckId = p.deckId;
            this.controls.add(this.menuKey.getControls());
            JButton select = new JButton("Select Deck");
            this.tf.setEditable(false);
            this.updateDeckName();
            select.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChooseComponentDialog d = new ChooseComponentDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, controls), DrawPile.class);
                    d.setTitle("Select Deck");
                    d.setVisible(true);
                    if (d.getTarget() != null) {
                        deckId = UniqueIdManager.getIdentifier((UniqueIdManager.Identifyable)((Object)d.getTarget()));
                        this.updateDeckName();
                    }
                }
            });
            final Box box = Box.createHorizontalBox();
            box.add(select);
            box.add(this.tf);
            this.controls.add(box);
            this.promptText = new StringConfigurer(null, "Prompt for destination deck:  ", p.selectDeckPrompt);
            this.prompt = new JCheckBox("Choose destination deck at game time?");
            this.controls.add(this.prompt);
            this.controls.add(this.promptText.getControls());
            this.promptText.getControls().setVisible(p.deckId == null || p.deckId.length() == 0);
            box.setVisible(p.deckId != null && p.deckId.length() > 0);
            this.prompt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    box.setVisible(!prompt.isSelected());
                    promptText.getControls().setVisible(prompt.isSelected());
                }
            });
            this.prompt.setSelected(p.deckId == null || p.deckId.length() == 0);
        }

        private void updateDeckName() {
            DrawPile p = DrawPile.findDrawPile(this.deckId);
            this.tf.setText(p != null ? p.getConfigureName() : "<none>");
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            return ReturnToDeck.ID + se.append(this.menuName.getValueString()).append(this.menuKey.getValueString()).append(this.prompt.isSelected() ? "" : this.deckId).append(this.promptText.getValueString()).getValue();
        }
    }
}

