/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.Region;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ChooseComponentDialog;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.PropertyExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.Stack;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class SendToLocation
extends Decorator
implements TranslatablePiece {
    public static final String ID = "sendto;";
    private static final String _0 = "0";
    public static final String BACK_MAP = "backMap";
    public static final String BACK_POINT = "backPoint";
    protected static final String DEST_GRIDLOCATION = "Grid location on selected Map";
    protected static final String DEST_LOCATION = "Location on selected Map";
    protected static final String DEST_ZONE = "Zone on selected Map";
    protected static final String DEST_REGION = "Region on selected Map";
    protected static final String DEST_COUNTER = "Another counter, selected by properties";
    protected static final String[] DEST_OPTIONS = new String[]{"Grid location on selected Map", "Location on selected Map", "Zone on selected Map", "Region on selected Map", "Another counter, selected by properties"};
    protected KeyCommand[] command;
    protected String commandName;
    protected String backCommandName;
    protected NamedKeyStroke key;
    protected NamedKeyStroke backKey;
    protected FormattedString mapId = new FormattedString("");
    protected FormattedString boardName = new FormattedString("");
    protected FormattedString x = new FormattedString("");
    protected FormattedString xIndex = new FormattedString("");
    protected FormattedString xOffset = new FormattedString("");
    protected FormattedString y = new FormattedString("");
    protected FormattedString yIndex = new FormattedString("");
    protected FormattedString yOffset = new FormattedString("");
    protected FormattedString gridLocation = new FormattedString("");
    protected KeyCommand sendCommand;
    protected KeyCommand backCommand;
    protected String description;
    protected String destination;
    protected FormattedString zone = new FormattedString("");
    protected FormattedString region = new FormattedString("");
    protected PropertyExpression propertyFilter = new PropertyExpression("");
    private Map map;

    public SendToLocation() {
        this("sendto;;;;;0;0;;;", null);
    }

    public SendToLocation(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.commandName = st.nextToken("");
        this.key = st.nextNamedKeyStroke(null);
        this.mapId.setFormat(st.nextToken(""));
        this.boardName.setFormat(st.nextToken(""));
        this.x.setFormat(st.nextToken(_0));
        this.y.setFormat(st.nextToken(_0));
        this.backCommandName = st.nextToken("");
        this.backKey = st.nextNamedKeyStroke(null);
        this.xIndex.setFormat(st.nextToken(_0));
        this.yIndex.setFormat(st.nextToken(_0));
        this.xOffset.setFormat(st.nextToken(_0));
        this.yOffset.setFormat(st.nextToken(_0));
        this.description = st.nextToken("");
        this.destination = st.nextToken(DEST_LOCATION.substring(0, 1));
        if (this.destination.length() == 0) {
            this.destination = DEST_LOCATION.substring(0, 1);
        }
        this.zone.setFormat(st.nextToken(""));
        this.region.setFormat(st.nextToken(""));
        this.propertyFilter.setExpression(st.nextToken(""));
        this.gridLocation.setFormat(st.nextToken(""));
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.commandName).append(this.key).append(this.mapId.getFormat()).append(this.boardName.getFormat()).append(this.x.getFormat()).append(this.y.getFormat()).append(this.backCommandName).append(this.backKey).append(this.xIndex.getFormat()).append(this.yIndex.getFormat()).append(this.xOffset.getFormat()).append(this.yOffset.getFormat()).append(this.description).append(this.destination).append(this.zone.getFormat()).append(this.region.getFormat()).append(this.propertyFilter.getExpression()).append(this.gridLocation.getFormat());
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.command == null) {
            this.sendCommand = new KeyCommand(this.commandName, this.key, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.backCommand = new KeyCommand(this.backCommandName, this.backKey, Decorator.getOutermost(this), (TranslatablePiece)this);
            ArrayList<KeyCommand> l = new ArrayList<KeyCommand>();
            if (this.commandName.length() > 0 && this.key != null && !this.key.isNull()) {
                l.add(this.sendCommand);
            }
            if (this.backCommandName.length() > 0 && this.backKey != null && !this.backKey.isNull()) {
                l.add(this.backCommand);
            }
            this.command = l.toArray(new KeyCommand[0]);
        }
        for (KeyCommand c : this.command) {
            if (c.getName().equals(this.backCommandName)) {
                c.setEnabled(this.getMap() != null && this.getProperty(BACK_MAP) != null && this.getProperty(BACK_POINT) != null);
                continue;
            }
            Point p = this.getSendLocation();
            c.setEnabled(this.getMap() != null && p != null && (this.map != this.getMap() || !p.equals(this.getPosition())));
        }
        return this.command;
    }

    private void LogBadGridLocation(Point p) {
        String s = "* " + Decorator.getOutermost(this).getName();
        s = this.getMap() == null ? s + "getMap is null" : (p == null ? s + "p is null" : s + "getMap: " + this.getMap().getMapName() + "; p: (" + p.x + "," + p.y + "; Position: (" + this.getPosition().x + "," + this.getPosition().y + "); map: " + this.map.getMapName() + ";");
        new Chatter.DisplayText(GameModule.getGameModule().getChatter(), s).execute();
    }

    @Override
    public String myGetState() {
        SequenceEncoder se = new SequenceEncoder(';');
        Map backMap = (Map)this.getProperty(BACK_MAP);
        if (backMap != null) {
            se.append(backMap.getIdentifier());
        } else {
            se.append("");
        }
        Point backPoint = (Point)this.getProperty(BACK_POINT);
        if (backPoint != null) {
            se.append(backPoint.x).append(backPoint.y);
        } else {
            se.append("").append("");
        }
        return se.getValue();
    }

    private Point getSendLocation() {
        GamePiece outer = Decorator.getOutermost(this);
        this.map = null;
        Point dest = null;
        if (this.destination.equals(DEST_COUNTER.substring(0, 1))) {
            GamePiece target = null;
            for (GamePiece piece : GameModule.getGameModule().getGameState().getAllPieces()) {
                if (piece instanceof Stack) {
                    Stack s = (Stack)piece;
                    for (GamePiece gamePiece : s.asList()) {
                        if (this.propertyFilter.accept(this, gamePiece) && (target = gamePiece) != null) break;
                    }
                } else if (this.propertyFilter.accept(this, piece)) {
                    target = piece;
                }
                if (target == null) continue;
                break;
            }
            if (target != null) {
                this.map = target.getMap();
                if (this.map != null) {
                    dest = target.getPosition();
                }
            }
        } else {
            this.map = Map.getMapById(this.mapId.getText(outer));
            if (this.map == null) {
                this.map = this.getMap();
            }
            if (this.map != null) {
                switch (this.destination.charAt(0)) {
                    case 'G': {
                        Board b = this.map.getBoardByName(this.boardName.getText(outer));
                        if (b == null) break;
                        try {
                            MapGrid g = b.getGrid();
                            if (g != null) {
                                dest = g.getLocation(this.gridLocation.getText(outer));
                                if (dest == null) break;
                                dest.translate(b.bounds().x, b.bounds().y);
                                break;
                            }
                            SendToLocation.reportDataError(this, Resources.getString("Error.no_grid_assigned"), this.map.getMapName());
                        }
                        catch (MapGrid.BadCoords e) {
                            this.LogBadGridLocation(dest);
                            SendToLocation.reportDataError(this, Resources.getString("Error.not_found", "Grid Location"), this.map.getMapName());
                        }
                        break;
                    }
                    case 'L': {
                        int xValue = this.x.getTextAsInt((PropertySource)outer, "Xlocation", this);
                        int yValue = this.y.getTextAsInt((PropertySource)outer, "YLocation", this);
                        dest = new Point(xValue, yValue);
                        Board b = this.map.getBoardByName(this.boardName.getText(outer));
                        if (b == null || dest == null) break;
                        dest.translate(b.bounds().x, b.bounds().y);
                        break;
                    }
                    case 'Z': {
                        String zoneName = this.zone.getText(outer);
                        Zone z = this.map.findZone(zoneName);
                        if (z == null) {
                            SendToLocation.reportDataError(this, Resources.getString("Error.not_found", "Zone"), this.zone.debugInfo(zoneName, "Zone"));
                            break;
                        }
                        Rectangle r = z.getBounds();
                        Rectangle r2 = z.getBoard().bounds();
                        dest = new Point(r2.x + r.x + r.width / 2, r2.y + r.y + r.height / 2);
                        break;
                    }
                    case 'R': {
                        String regionName = this.region.getText(outer);
                        Region r = this.map.findRegion(regionName);
                        if (r == null) {
                            SendToLocation.reportDataError(this, Resources.getString("Error.not_found", "Region"), this.region.debugInfo(regionName, "Region"));
                            break;
                        }
                        Rectangle r2 = r.getBoard().bounds();
                        if (r == null) break;
                        dest = new Point(r.getOrigin().x + r2.x, r.getOrigin().y + r2.y);
                    }
                }
            }
        }
        if (dest != null && this.destination.charAt(0) != 'G') {
            dest = this.offsetDestination(dest.x, dest.y, outer);
        }
        return dest;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        Command c = null;
        this.myGetKeyCommands();
        if (this.sendCommand.matches(stroke)) {
            GamePiece outer = Decorator.getOutermost(this);
            Stack parent = outer.getParent();
            Point dest = this.getSendLocation();
            if (this.map != null && dest != null) {
                if (this.map == this.getMap() && dest.equals(this.getPosition())) {
                    return null;
                }
                ChangeTracker tracker = new ChangeTracker(this);
                this.setProperty(BACK_MAP, this.getMap());
                this.setProperty(BACK_POINT, this.getPosition());
                c = tracker.getChangeCommand();
                c = c.append(SendToLocation.setOldProperties(this));
                if (!Boolean.TRUE.equals(outer.getProperty("IgnoreGrid"))) {
                    dest = this.map.snapTo(dest);
                }
                c = c.append(this.map.placeOrMerge(outer, dest));
                if (this.map.getMoveKey() != null) {
                    c = c.append(outer.keyEvent(this.map.getMoveKey()));
                }
                if (parent != null) {
                    c = c.append(parent.pieceRemoved(outer));
                }
            }
        } else if (this.backCommand.matches(stroke)) {
            GamePiece outer = Decorator.getOutermost(this);
            Map backMap = (Map)this.getProperty(BACK_MAP);
            Point backPoint = (Point)this.getProperty(BACK_POINT);
            ChangeTracker tracker = new ChangeTracker(this);
            this.setProperty(BACK_MAP, null);
            this.setProperty(BACK_POINT, null);
            c = tracker.getChangeCommand();
            if (backMap != null && backPoint != null) {
                c = c.append(SendToLocation.setOldProperties(this));
                c = c.append(backMap.placeOrMerge(outer, backPoint));
                if (backMap.getMoveKey() != null) {
                    c = c.append(outer.keyEvent(backMap.getMoveKey()));
                }
            }
        }
        return c;
    }

    protected Point offsetDestination(int x, int y, GamePiece outer) {
        int xPos = x + this.parse("xIndex", this.xIndex, outer) * this.parse("xOffset", this.xOffset, outer);
        int yPos = y + this.parse("yIndex", this.yIndex, outer) * this.parse("yOffset", this.yOffset, outer);
        return new Point(xPos, yPos);
    }

    private int parse(String desc, FormattedString s, GamePiece outer) {
        int i = 0;
        String val = s.getText((PropertySource)outer, _0);
        try {
            i = Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            SendToLocation.reportDataError(this, Resources.getString("Error.non_number_error"), s.debugInfo(val, desc), e);
        }
        return i;
    }

    @Override
    public void mySetState(String newState) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(newState, ';');
        String mapId = st.nextToken("");
        if (mapId.length() > 0) {
            this.setProperty(BACK_MAP, Map.getMapById(mapId));
        }
        String x = st.nextToken("");
        String y = st.nextToken("");
        if (x.length() > 0 && y.length() > 0) {
            try {
                this.setProperty(BACK_POINT, new Point(Integer.parseInt(x), Integer.parseInt(y)));
            }
            catch (NumberFormatException e) {
                SendToLocation.reportDataError(this, Resources.getString("Error.non_number_error"), "Back Point=(" + x + "," + y + ")", e);
            }
        }
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public String getDescription() {
        Object d = "Send to Location";
        if (this.description.length() > 0) {
            d = (String)d + " - " + this.description;
        }
        return d;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("SendToLocation.htm");
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(new String[]{this.commandName, this.backCommandName}, new String[]{this.getCommandDescription(this.description, "Send command"), this.getCommandDescription(this.description, "Back command")});
    }

    public static class Ed
    implements PieceEditor {
        protected StringConfigurer nameInput;
        protected StringConfigurer backNameInput;
        protected NamedHotKeyConfigurer keyInput;
        protected NamedHotKeyConfigurer backKeyInput;
        protected FormattedStringConfigurer mapIdInput;
        protected FormattedStringConfigurer boardNameInput;
        protected FormattedStringConfigurer xInput;
        protected FormattedStringConfigurer yInput;
        protected BooleanConfigurer advancedInput;
        protected FormattedStringConfigurer xIndexInput;
        protected FormattedStringConfigurer xOffsetInput;
        protected FormattedStringConfigurer yIndexInput;
        protected FormattedStringConfigurer yOffsetInput;
        protected StringConfigurer descInput;
        protected StringEnumConfigurer destInput;
        protected PropertyExpressionConfigurer propertyInput;
        protected FormattedStringConfigurer zoneInput;
        protected FormattedStringConfigurer regionInput;
        protected JPanel controls = new JPanel();
        protected Box mapControls;
        protected Box boardControls;
        protected Box advancedControls;
        protected StringConfigurer gridLocationInput;

        public Ed(SendToLocation p) {
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.descInput = new StringConfigurer(null, "Description:  ", p.description);
            this.controls.add(this.descInput.getControls());
            this.nameInput = new StringConfigurer(null, "Command name:  ", p.commandName);
            this.controls.add(this.nameInput.getControls());
            this.keyInput = new NamedHotKeyConfigurer(null, "Keyboard Command:  ", p.key);
            this.controls.add(this.keyInput.getControls());
            this.backNameInput = new StringConfigurer(null, "Send Back Command name:  ", p.backCommandName);
            this.controls.add(this.backNameInput.getControls());
            this.backKeyInput = new NamedHotKeyConfigurer(null, "Send Back Keyboard Command:  ", p.backKey);
            this.controls.add(this.backKeyInput.getControls());
            this.destInput = new StringEnumConfigurer(null, "Destination:  ", DEST_OPTIONS);
            this.destInput.setValue(SendToLocation.DEST_LOCATION);
            for (String destOption : DEST_OPTIONS) {
                if (!destOption.substring(0, 1).equals(p.destination)) continue;
                this.destInput.setValue(destOption);
            }
            this.destInput.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    this.updateVisibility();
                }
            });
            this.controls.add(this.destInput.getControls());
            this.mapControls = Box.createHorizontalBox();
            this.mapIdInput = new FormattedExpressionConfigurer(null, "Map:  ", p.mapId.getFormat(), p);
            this.mapControls.add(this.mapIdInput.getControls());
            JButton select = new JButton("Select");
            select.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.selectMap();
                }
            });
            this.mapControls.add(select);
            JButton clear = new JButton("Clear");
            clear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.clearMap();
                }
            });
            this.mapControls.add(clear);
            this.controls.add(this.mapControls);
            this.boardControls = Box.createHorizontalBox();
            this.boardNameInput = new FormattedExpressionConfigurer(null, "Board:  ", p.boardName.getFormat(), p);
            this.boardControls.add(this.boardNameInput.getControls());
            select = new JButton("Select");
            select.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.selectBoard();
                }
            });
            clear = new JButton("Clear");
            clear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.clearBoard();
                }
            });
            this.boardControls.add(select);
            this.boardControls.add(clear);
            this.controls.add(this.boardControls);
            this.xInput = new FormattedExpressionConfigurer(null, "X Position:  ", p.x.getFormat(), p);
            this.controls.add(this.xInput.getControls());
            this.yInput = new FormattedExpressionConfigurer(null, "Y Position:  ", p.y.getFormat(), p);
            this.controls.add(this.yInput.getControls());
            this.zoneInput = new FormattedExpressionConfigurer(null, "Zone Name:  ", p.zone.getFormat(), p);
            this.controls.add(this.zoneInput.getControls());
            this.regionInput = new FormattedExpressionConfigurer(null, "Region Name:  ", p.region.getFormat(), p);
            this.controls.add(this.regionInput.getControls());
            this.propertyInput = new PropertyExpressionConfigurer(null, "Property Match:  ", p.propertyFilter);
            this.controls.add(this.propertyInput.getControls());
            this.gridLocationInput = new StringConfigurer(null, "Grid Location:  ", p.gridLocation.getFormat());
            this.controls.add(this.gridLocationInput.getControls());
            this.advancedInput = new BooleanConfigurer(null, "Advanced Options", false);
            this.advancedInput.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent arg0) {
                    this.updateVisibility();
                }
            });
            this.controls.add(this.advancedInput.getControls());
            this.advancedControls = Box.createHorizontalBox();
            this.xIndexInput = new FormattedExpressionConfigurer(null, "Additional X offset:  ", p.xIndex.getFormat(), p);
            this.advancedControls.add(this.xIndexInput.getControls());
            this.xOffsetInput = new FormattedExpressionConfigurer(null, " times ", p.xOffset.getFormat(), p);
            this.advancedControls.add(this.xOffsetInput.getControls());
            this.controls.add(this.advancedControls);
            this.advancedControls = Box.createHorizontalBox();
            this.yIndexInput = new FormattedExpressionConfigurer(null, "Additional Y offset:  ", p.yIndex.getFormat(), p);
            this.advancedControls.add(this.yIndexInput.getControls());
            this.yOffsetInput = new FormattedExpressionConfigurer(null, " times ", p.yOffset.getFormat(), p);
            this.advancedControls.add(this.yOffsetInput.getControls());
            this.controls.add(this.advancedControls);
            this.updateVisibility();
        }

        private void updateVisibility() {
            this.advancedInput.getControls().setVisible(!this.destInput.getValue().equals(SendToLocation.DEST_GRIDLOCATION));
            boolean advancedVisible = this.advancedInput.booleanValue() != false && this.advancedInput.getControls().isVisible();
            this.xIndexInput.getControls().setVisible(advancedVisible);
            this.xOffsetInput.getControls().setVisible(advancedVisible);
            this.yIndexInput.getControls().setVisible(advancedVisible);
            this.yOffsetInput.getControls().setVisible(advancedVisible);
            String destOption = this.destInput.getValueString();
            this.xInput.getControls().setVisible(destOption.equals(SendToLocation.DEST_LOCATION));
            this.yInput.getControls().setVisible(destOption.equals(SendToLocation.DEST_LOCATION));
            this.mapControls.setVisible(!destOption.equals(SendToLocation.DEST_COUNTER));
            this.boardControls.setVisible(destOption.equals(SendToLocation.DEST_LOCATION) || destOption.equals(SendToLocation.DEST_GRIDLOCATION));
            this.zoneInput.getControls().setVisible(destOption.equals(SendToLocation.DEST_ZONE));
            this.regionInput.getControls().setVisible(destOption.equals(SendToLocation.DEST_REGION));
            this.propertyInput.getControls().setVisible(destOption.equals(SendToLocation.DEST_COUNTER));
            this.gridLocationInput.getControls().setVisible(destOption.equals(SendToLocation.DEST_GRIDLOCATION));
            Window w = SwingUtilities.getWindowAncestor(this.controls);
            if (w != null) {
                w.pack();
            }
        }

        private void clearBoard() {
            this.boardNameInput.setValue("");
        }

        private void clearMap() {
            this.mapIdInput.setValue("");
        }

        private void selectBoard() {
            ChooseComponentDialog d = new ChooseComponentDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.controls), Board.class);
            d.setVisible(true);
            if (d.getTarget() != null) {
                Board b = (Board)d.getTarget();
                this.boardNameInput.setValue(b.getName());
            }
        }

        private void selectMap() {
            ChooseComponentDialog d = new ChooseComponentDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.controls), Map.class);
            d.setVisible(true);
            if (d.getTarget() != null) {
                Map map = (Map)d.getTarget();
                this.mapIdInput.setValue(map.getMapName());
            }
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.nameInput.getValueString()).append(this.keyInput.getValueString()).append(this.mapIdInput.getValueString()).append(this.boardNameInput.getValueString()).append(this.xInput.getValueString()).append(this.yInput.getValueString()).append(this.backNameInput.getValueString()).append(this.backKeyInput.getValueString()).append(this.xIndexInput.getValueString()).append(this.yIndexInput.getValueString()).append(this.xOffsetInput.getValueString()).append(this.yOffsetInput.getValueString()).append(this.descInput.getValueString()).append(this.destInput.getValueString().charAt(0)).append(this.zoneInput.getValueString()).append(this.regionInput.getValueString()).append(this.propertyInput.getValueString()).append(this.gridLocationInput.getValueString());
            return SendToLocation.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }
}

