/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import VASSAL.tools.io.IOUtils;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.charset.StandardCharsets;

public class DeobfuscatingInputStream
extends FilterInputStream {
    public DeobfuscatingInputStream(InputStream in) throws IOException {
        super(null);
        byte[] header = new byte["!VCSK".length()];
        DeobfuscatingInputStream.readFully(in, header, header.length);
        if (new String(header, StandardCharsets.UTF_8).equals("!VCSK")) {
            this.in = new DeobfuscatingInputStreamImpl(in);
        } else {
            PushbackInputStream pin = new PushbackInputStream(in, header.length);
            pin.unread(header);
            this.in = pin;
        }
    }

    private static int readFully(InputStream in, byte[] bytes, int len) throws IOException {
        int n;
        int count;
        for (n = 0; n < len && (count = in.read(bytes, n, len - n)) >= 0; n += count) {
        }
        return n;
    }

    public static void main(String[] args) throws IOException {
        try (DeobfuscatingInputStream in = new DeobfuscatingInputStream(args.length > 0 ? new FileInputStream(args[0]) : System.in);){
            IOUtils.copy((InputStream)in, (OutputStream)System.out);
        }
        System.exit(0);
    }

    private static class DeobfuscatingInputStreamImpl
    extends FilterInputStream {
        private final byte key;
        private final byte[] pair = new byte[2];

        public DeobfuscatingInputStreamImpl(InputStream in) throws IOException {
            super(in);
            DeobfuscatingInputStream.readFully(in, this.pair, 2);
            this.key = (byte)(this.unhex(this.pair[0]) << 4 | this.unhex(this.pair[1]));
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            int b = 0;
            int i = 0;
            while (i < len && (b = this.read()) >= 0) {
                bytes[i++ + off] = (byte)b;
            }
            return b == -1 && i == 0 ? -1 : i;
        }

        @Override
        public int read() throws IOException {
            switch (DeobfuscatingInputStream.readFully(this.in, this.pair, 2)) {
                case 0: {
                    return -1;
                }
                case 2: {
                    return ((this.unhex(this.pair[0]) << 4 | this.unhex(this.pair[1])) ^ this.key) & 0xFF;
                }
            }
            throw new IOException();
        }

        private int unhex(int i) throws IOException {
            switch (i) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return i - 48;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    return i - 55;
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    return i - 87;
                }
            }
            throw new IOException(String.valueOf(i));
        }
    }
}

