/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.swing;

import VASSAL.build.widget.HtmlChart;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.ScrollPane;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HTMLWindowHelper
implements HyperlinkListener {
    private JEditorPane pane = new JEditorPane();

    public HTMLWindowHelper() {
        this.pane.setEditable(false);
        this.pane.setContentType("text/html");
        this.pane.setEditorKit(new HtmlChart.XTMLEditorKit());
        this.pane.addHyperlinkListener(this);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType()) && e.getURL() != null) {
            this.update(e.getURL());
        }
    }

    public void update(URL contents) {
        if (contents != null) {
            try {
                this.pane.setPage(contents);
            }
            catch (IOException e) {
                ReadErrorDialog.error(e, contents.toString());
            }
        } else {
            this.pane.setText("");
        }
    }

    public void setup(Window w, URL contents) {
        ScrollPane s = new ScrollPane(this.pane);
        Font f = new JLabel().getFont();
        FontMetrics fm = w.getFontMetrics(f);
        s.getVerticalScrollBar().setUnitIncrement(fm.getHeight() * 3);
        w.add(s);
        this.update(contents);
        w.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int width = Math.max(d.width / 2, w.getSize().width);
        int height = Math.max(d.height / 2, w.getSize().height);
        width = Math.min(width, d.width * 2 / 3);
        height = Math.min(height, d.height * 2 / 3);
        w.setSize(width, height);
        w.setLocation(d.width / 2 - width / 2, 0);
    }
}

