/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Translatable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;

public abstract class AbstractConfigurable
extends AbstractBuildable
implements AutoConfigurable {
    protected PropertyChangeSupport changeSupport;
    protected String name;
    protected String localizedName;
    protected Configurer config;
    protected ComponentI18nData myI18nData;

    @Override
    public void remove(Buildable b) {
        this.buildComponents.remove(b);
    }

    @Override
    public String getConfigureName() {
        return this.name;
    }

    public String getLocalizedConfigureName() {
        return this.localizedName;
    }

    public void setConfigureName(String s) {
        String oldName = this.name;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("name", oldName, s);
        }
        if (Localization.getInstance().isTranslationInProgress()) {
            this.localizedName = s;
        } else if (Localization.getInstance().isTranslationComplete()) {
            this.name = s;
        } else {
            this.name = s;
            this.localizedName = s;
        }
    }

    @Override
    public abstract String[] getAttributeDescriptions();

    @Override
    public abstract Class<?>[] getAttributeTypes();

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        return null;
    }

    @Override
    public ComponentI18nData getI18nData() {
        if (this.myI18nData == null) {
            this.myI18nData = new ComponentI18nData(this, this.getI18nPrefix());
        }
        return this.myI18nData;
    }

    protected String getI18nPrefix() {
        Object key = this.getClass().getSimpleName();
        if (this.getConfigureName() != null && this.getConfigureName().length() > 0) {
            key = (String)key + "." + this.getConfigureName();
        }
        return (String)key + ".";
    }

    protected void setAttributeTranslatable(String attr, boolean b) {
        this.getI18nData().setAttributeTranslatable(attr, b);
    }

    protected void setAllAttributesUntranslatable() {
        this.getI18nData().setAllAttributesUntranslatable();
    }

    @Override
    public void add(Buildable b) {
        super.add(b);
        if (b instanceof Translatable) {
            ((Translatable)b).getI18nData().setOwningComponent(this);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(l);
        }
    }

    @Override
    public Configurable[] getConfigureComponents() {
        ArrayList<Configurable> l = new ArrayList<Configurable>();
        for (Buildable b : this.getBuildables()) {
            if (!(b instanceof Configurable)) continue;
            l.add((Configurable)b);
        }
        return l.toArray(new Configurable[0]);
    }

    @Override
    public Configurer getConfigurer() {
        if (this.config == null) {
            this.config = new AutoConfigurer(this);
        } else {
            ((AutoConfigurer)this.config).reset();
        }
        return this.config;
    }
}

