/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.ColorManager;
import VASSAL.build.module.gamepieceimage.ColorSwatch;
import VASSAL.build.module.gamepieceimage.SwatchComboBox;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ColorSwatchConfigurer
extends Configurer {
    protected JPanel p;
    protected JPanel swatchPanel;
    protected JComboBox<String> swatches;
    protected Box colorBox;
    protected ColorConfigurer config;

    public ColorSwatchConfigurer(String key, String name) {
        this(key, name, ColorSwatch.getDefaultSwatch());
    }

    public ColorSwatchConfigurer(String key, String name, ColorSwatch swatch) {
        super(key, name);
        this.setValue(swatch);
    }

    public ColorSwatchConfigurer(String key, String name, String swatchName) {
        this(key, name, ColorManager.getColorManager().getColorSwatch(swatchName));
    }

    public ColorSwatchConfigurer(String key, String name, Color color) {
        this(key, name, ColorManager.getColorManager().getColorSwatch(color));
    }

    @Override
    public String getValueString() {
        return "";
    }

    public Color getValueColor() {
        return ((ColorSwatch)this.value).getColor();
    }

    public ColorSwatch getValueColorSwatch() {
        return (ColorSwatch)this.value;
    }

    @Override
    public Component getControls() {
        if (this.p == null) {
            this.p = new JPanel();
            this.swatchPanel = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 1));
            Box box = Box.createHorizontalBox();
            box.add(new JLabel(this.name));
            this.buildSwatches();
            box.add(this.swatchPanel);
            this.p.add(box);
            this.colorBox = Box.createHorizontalBox();
            this.config = new ColorConfigurer("", "Select Color  ");
            this.config.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    Color c = (Color)ColorSwatchConfigurer.this.config.getValue();
                    ColorSwatch cs = ColorManager.getColorManager().getColorSwatch(c);
                    ColorSwatchConfigurer.this.setValue(cs);
                    ColorSwatchConfigurer.this.buildSwatches();
                    ColorSwatchConfigurer.this.updateValue();
                }
            });
            this.colorBox.add(this.config.getControls());
            this.p.add(this.colorBox);
            this.repack();
        }
        return this.p;
    }

    protected void buildSwatches() {
        if (this.swatchPanel == null) {
            return;
        }
        if (this.swatches != null) {
            this.swatchPanel.remove(this.swatches);
        }
        ItemListener l = evt -> this.updateValue();
        this.swatches = new SwatchComboBox(l, ((ColorSwatch)this.value).getConfigureName());
        this.swatchPanel.add(this.swatches);
    }

    protected void updateValue() {
        String s = (String)this.swatches.getSelectedItem();
        if ("Select...".equals(s)) {
            this.setValue(ColorManager.getColorManager().getColorSwatch((Color)this.config.getValue()));
        } else {
            this.setValue(ColorManager.getColorManager().getColorSwatch(s));
        }
        this.repack();
    }

    protected void repack() {
        this.colorBox.setVisible(((ColorSwatch)this.getValue()).getConfigureName().equals("Select..."));
        Window w = SwingUtilities.getWindowAncestor(this.colorBox);
        if (w != null) {
            w.pack();
        }
    }

    @Override
    public void setValue(String s) {
        super.setValue(new ColorSwatch(s));
        this.buildSwatches();
    }

    public static ColorSwatch decode(String s) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, '|');
        return new ColorSwatch(sd.nextToken(), sd.nextColor(Color.WHITE));
    }

    public static String encode(ColorSwatch f) {
        SequenceEncoder se = new SequenceEncoder(f.getConfigureName(), '|');
        se.append(ColorConfigurer.colorToString(f.getColor()));
        return se.getValue();
    }
}

