/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.module.gamepieceimage.ColorManager;
import VASSAL.build.module.gamepieceimage.ColorSwatch;
import VASSAL.build.module.gamepieceimage.ColorSwatchConfigurer;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.ItemInstance;
import VASSAL.build.module.gamepieceimage.TextItem;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.TextConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;

public class TextBoxItemInstance
extends ItemInstance {
    protected static final String VALUE = "value";
    protected static final String BG_COLOR = "borderColor";
    protected String val = "";
    private VisibilityCondition valueCond = new VisibilityCondition(){

        @Override
        public boolean shouldBeVisible() {
            return !((TextItem)TextBoxItemInstance.this.getItem()).isFixed();
        }
    };

    public TextBoxItemInstance() {
        this.setFgColor(ColorSwatch.getBlack());
        this.setBgColor(ColorManager.getColorManager().getColorSwatch(Color.LIGHT_GRAY));
    }

    public TextBoxItemInstance(String code, GamePieceImage defn) {
        super(defn);
        this.decode(code);
    }

    public TextBoxItemInstance(String name, String type, String location) {
        super(name, type, location);
        this.setFgColor(ColorSwatch.getBlack());
        this.setBgColor(ColorManager.getColorManager().getColorSwatch(Color.LIGHT_GRAY));
    }

    public void setValue(String value) {
        this.val = value;
    }

    public String getValue() {
        return this.val;
    }

    @Override
    public String encode() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.getType());
        se.append(this.getName());
        se.append(this.getLocation());
        se.append(this.getFgColor().encode());
        se.append(this.getBgColor().encode());
        se.append(this.getValue());
        return se.getValue();
    }

    public void decode(String code) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(code, ';');
        this.setType(sd.nextToken(""));
        this.setName(sd.nextToken(""));
        this.setLocation(sd.nextToken(""));
        this.setFgColor(new ColorSwatch(sd.nextToken("")));
        this.setBgColor(new ColorSwatch(sd.nextToken("")));
        this.setValue(sd.nextToken(""));
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Value:  ", "Text Color:  ", "Background Color:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{WrappingTextConfigurer.class, FgColorSwatchConfig.class, BgColorSwatchConfig.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{VALUE, "fgColor", BG_COLOR};
    }

    @Override
    public void setAttribute(String key, Object o) {
        if (VALUE.equals(key)) {
            this.val = (String)o;
        } else if ("fgColor".equals(key)) {
            if (o instanceof String) {
                o = new ColorSwatch((String)o);
            }
            this.fgColor = (ColorSwatch)o;
        } else if (BG_COLOR.equals(key)) {
            if (o instanceof String) {
                o = new ColorSwatch((String)o);
            }
            this.bgColor = (ColorSwatch)o;
        }
        if (this.myConfig != null) {
            this.myConfig.rebuildViz();
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (VALUE.equals(key)) {
            return this.val;
        }
        if ("fgColor".equals(key)) {
            return this.fgColor.encode();
        }
        if (BG_COLOR.equals(key)) {
            return this.bgColor.encode();
        }
        return null;
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (VALUE.equals(name)) {
            return this.valueCond;
        }
        return super.getAttributeVisibility(name);
    }

    public static class WrappingTextConfigurer
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new TextConfigurer(key, name, ((TextBoxItemInstance)c).val, true);
        }
    }

    public static class FgColorSwatchConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new ColorSwatchConfigurer(key, name, ((ItemInstance)c).getFgColor());
        }
    }

    public static class BgColorSwatchConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new ColorSwatchConfigurer(key, name, ((ItemInstance)c).getBgColor());
        }
    }
}

