/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.gamepieceimage.StringEnumConfigurer;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.counters.BooleanAndPieceFilter;
import VASSAL.counters.Decorator;
import VASSAL.counters.Embellishment;
import VASSAL.counters.GamePiece;
import VASSAL.counters.GlobalCommand;
import VASSAL.counters.PieceFilter;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.ToolBarComponent;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class MassKeyCommand
extends AbstractConfigurable
implements RecursionLimiter.Loopable {
    public static final String DEPRECATED_NAME = "text";
    public static final String NAME = "name";
    public static final String ICON = "icon";
    public static final String TOOLTIP = "tooltip";
    public static final String BUTTON_TEXT = "buttonText";
    public static final String HOTKEY = "buttonHotkey";
    public static final String KEY_COMMAND = "hotkey";
    public static final String AFFECTED_PIECE_NAMES = "names";
    public static final String PROPERTIES_FILTER = "filter";
    public static final String REPORT_SINGLE = "reportSingle";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String CONDITION = "condition";
    public static final String DECK_COUNT = "deckCount";
    private static final String IF_ACTIVE = "If layer is active";
    private static final String IF_INACTIVE = "If layer is inactive";
    private static final String ALWAYS = "Always";
    public static final String CHECK_PROPERTY = "property";
    public static final String CHECK_VALUE = "propValue";
    public static final String SINGLE_MAP = "singleMap";
    protected LaunchButton launch;
    protected NamedKeyStroke stroke = new NamedKeyStroke();
    protected String[] names = new String[0];
    protected String condition;
    protected String checkProperty;
    protected String checkValue;
    protected PropertyExpression propertiesFilter = new PropertyExpression();
    protected PropertySource propertySource;
    protected PieceFilter filter;
    protected Map map;
    protected GlobalCommand globalCommand = new GlobalCommand(this);
    protected FormattedString reportFormat = new FormattedString();
    protected boolean singleMap = true;

    public MassKeyCommand() {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MassKeyCommand.this.apply();
            }
        };
        this.launch = new LaunchButton("CTRL", TOOLTIP, BUTTON_TEXT, HOTKEY, ICON, al);
    }

    @Override
    public void addTo(Buildable parent) {
        if (parent instanceof Map) {
            this.map = (Map)parent;
        }
        if (parent instanceof ToolBarComponent) {
            ((ToolBarComponent)((Object)parent)).getToolBar().add(this.launch);
        }
        if (parent instanceof PropertySource) {
            this.propertySource = (PropertySource)((Object)parent);
        }
        this.setAttributeTranslatable(NAME, false);
        this.globalCommand.setPropertySource(this.propertySource);
    }

    public void apply() {
        this.buildFilter();
        if (this.singleMap) {
            GameModule.getGameModule().sendAndLog(this.globalCommand.apply(this.map, this.getFilter()));
        } else {
            List<Map> l = Map.getMapList();
            GameModule.getGameModule().sendAndLog(this.globalCommand.apply(l.toArray(new Map[0]), this.getFilter()));
        }
    }

    public void setPropertySource(PropertySource source) {
        this.propertySource = source;
        this.globalCommand.setPropertySource(source);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeDescriptions() {
        if (this.condition == null) {
            return new String[]{Resources.getString("Editor.description_label"), Resources.getString("Editor.MassKey.key"), Resources.getString("Editor.MassKey.match"), Resources.getString("Editor.MassKey.counters"), Resources.getString("Editor.MassKey.deck_content"), Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.hotkey_label"), Resources.getString("Editor.MassKey.suppress"), Resources.getString("Editor.report_format")};
        }
        return new String[]{Resources.getString("Editor.description_label"), Resources.getString("Editor.MassKey.key"), Resources.getString("Editor.MassKey.match"), Resources.getString("Editor.MassKey.counters"), Resources.getString("Editor.MassKey.deck_content"), Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.hotkey_label"), Resources.getString("Editor.MassKey.suppress"), Resources.getString("Editor.report_format"), Resources.getString("Editor.MassKey.apply")};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, KEY_COMMAND, PROPERTIES_FILTER, SINGLE_MAP, DECK_COUNT, BUTTON_TEXT, TOOLTIP, ICON, HOTKEY, REPORT_SINGLE, REPORT_FORMAT, CONDITION, CHECK_VALUE, CHECK_PROPERTY, AFFECTED_PIECE_NAMES};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        if (this.condition == null) {
            return new Class[]{String.class, NamedKeyStroke.class, PropertyExpression.class, Boolean.class, DeckPolicyConfig.class, String.class, String.class, IconConfig.class, NamedKeyStroke.class, Boolean.class, ReportFormatConfig.class};
        }
        return new Class[]{String.class, NamedKeyStroke.class, String.class, Boolean.class, DeckPolicyConfig.class, String.class, String.class, IconConfig.class, NamedKeyStroke.class, Boolean.class, ReportFormatConfig.class, Prompt.class};
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (KEY_COMMAND.equals(key)) {
            return NamedHotKeyConfigurer.encode(this.stroke);
        }
        if (AFFECTED_PIECE_NAMES.equals(key)) {
            return this.names == null || this.names.length == 0 ? null : StringArrayConfigurer.arrayToString(this.names);
        }
        if (CHECK_PROPERTY.equals(key)) {
            return this.propertiesFilter != null ? null : this.checkProperty;
        }
        if (CHECK_VALUE.equals(key)) {
            return this.propertiesFilter != null ? null : this.checkValue;
        }
        if (PROPERTIES_FILTER.equals(key)) {
            return this.propertiesFilter.getExpression();
        }
        if (CONDITION.equals(key)) {
            return ALWAYS.equals(this.condition) ? null : this.condition;
        }
        if (REPORT_SINGLE.equals(key)) {
            return String.valueOf(this.globalCommand.isReportSingle());
        }
        if (DECK_COUNT.equals(key)) {
            return String.valueOf(this.globalCommand.getSelectFromDeck());
        }
        if (REPORT_FORMAT.equals(key)) {
            return this.reportFormat.getFormat();
        }
        if (SINGLE_MAP.equals(key)) {
            return String.valueOf(this.singleMap);
        }
        return this.launch.getAttributeValueString(key);
    }

    public static String getConfigureTypeName() {
        return "Global Key Command";
    }

    protected LaunchButton getLaunchButton() {
        return this.launch;
    }

    protected void setLaunchButton(LaunchButton launch) {
        this.launch = launch;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "GlobalKeyCommand");
    }

    @Override
    public void removeFrom(Buildable parent) {
        if (parent instanceof ToolBarComponent) {
            ((ToolBarComponent)((Object)parent)).getToolBar().remove(this.launch);
        }
    }

    public PieceFilter getFilter() {
        this.buildFilter();
        return this.filter;
    }

    private void buildFilter() {
        if (this.checkValue != null) {
            this.propertiesFilter.setExpression(this.checkProperty + "=" + this.checkValue);
        }
        if (this.propertiesFilter != null) {
            this.filter = this.propertiesFilter.getFilter(this.propertySource);
        }
        if (this.filter != null && this.condition != null) {
            this.filter = new BooleanAndPieceFilter(this.filter, new PieceFilter(){

                @Override
                public boolean accept(GamePiece piece) {
                    boolean valid = false;
                    if (MassKeyCommand.ALWAYS.equals(MassKeyCommand.this.condition)) {
                        valid = true;
                    } else if (MassKeyCommand.IF_ACTIVE.equals(MassKeyCommand.this.condition)) {
                        valid = Embellishment.getLayerWithMatchingActivateCommand(piece, MassKeyCommand.this.stroke, true) != null;
                    } else if (MassKeyCommand.IF_INACTIVE.equals(MassKeyCommand.this.condition)) {
                        valid = Embellishment.getLayerWithMatchingActivateCommand(piece, MassKeyCommand.this.stroke, false) != null;
                    }
                    return valid;
                }
            });
        }
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (DEPRECATED_NAME.equals(key)) {
            this.setAttribute(NAME, value);
            this.setAttribute(BUTTON_TEXT, value);
        } else if (NAME.equals(key)) {
            this.setConfigureName((String)value);
            if (this.launch.getAttributeValueString(TOOLTIP) == null) {
                this.launch.setAttribute(TOOLTIP, value);
            }
        } else if (KEY_COMMAND.equals(key)) {
            if (value instanceof String) {
                value = NamedHotKeyConfigurer.decode((String)value);
            }
            this.stroke = (NamedKeyStroke)value;
            this.globalCommand.setKeyStroke(this.stroke);
        } else if (AFFECTED_PIECE_NAMES.equals(key)) {
            if (value instanceof String) {
                value = StringArrayConfigurer.stringToArray((String)value);
            }
            this.names = value;
            if (this.names.length == 0) {
                this.names = null;
            } else {
                this.filter = new PieceFilter(){

                    @Override
                    public boolean accept(GamePiece piece) {
                        for (String s : MassKeyCommand.this.names) {
                            if (!Decorator.getInnermost(piece).getName().equals(s)) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
        } else if (CHECK_PROPERTY.equals(key)) {
            this.checkProperty = (String)value;
        } else if (CHECK_VALUE.equals(key)) {
            this.checkValue = (String)value;
        } else if (PROPERTIES_FILTER.equals(key)) {
            this.propertiesFilter.setExpression((String)value);
        } else if (CONDITION.equals(key)) {
            this.condition = (String)value;
        } else if (REPORT_SINGLE.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.globalCommand.setReportSingle((Boolean)value);
        } else if (DECK_COUNT.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.globalCommand.setSelectFromDeck((Integer)value);
        } else if (REPORT_FORMAT.equals(key)) {
            this.reportFormat.setFormat((String)value);
            this.globalCommand.setReportFormat((String)value);
        } else if (SINGLE_MAP.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.singleMap = (Boolean)value;
        } else {
            this.launch.setAttribute(key, value);
        }
    }

    @Override
    public String getComponentName() {
        return this.getConfigureName();
    }

    @Override
    public String getComponentTypeName() {
        return MassKeyCommand.getConfigureTypeName();
    }

    public static class DeckPolicyConfig
    extends Configurer
    implements ConfigurerFactory {
        protected static final String FIXED = "Fixed number of pieces";
        protected static final String NONE = "No pieces";
        protected static final String ALL = "All pieces";
        protected IntConfigurer intConfig;
        protected StringEnumConfigurer typeConfig = new StringEnumConfigurer(null, "", new String[]{"All pieces", "No pieces", "Fixed number of pieces"});
        protected JLabel prompt;
        protected Box controls;

        public DeckPolicyConfig() {
            super(null, "");
            this.intConfig = new IntConfigurer(null, "");
            this.controls = Box.createHorizontalBox();
            this.prompt = new JLabel("Within a Deck, apply to:  ");
            this.controls.add(this.prompt);
            this.controls.add(this.typeConfig.getControls());
            this.controls.add(this.intConfig.getControls());
            PropertyChangeListener l = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    intConfig.getControls().setVisible(DeckPolicyConfig.FIXED.equals(typeConfig.getValueString()));
                    Window w = SwingUtilities.getWindowAncestor(intConfig.getControls());
                    if (w != null) {
                        w.pack();
                    }
                }
            };
            PropertyChangeListener l2 = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    this.setValue(this.getIntValue());
                }
            };
            this.typeConfig.addPropertyChangeListener(l);
            this.typeConfig.addPropertyChangeListener(l2);
            this.intConfig.addPropertyChangeListener(l2);
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getValueString() {
            return String.valueOf(this.getIntValue());
        }

        public int getIntValue() {
            String type = this.typeConfig.getValueString();
            if (ALL.equals(type)) {
                return -1;
            }
            if (NONE.equals(type)) {
                return 0;
            }
            return this.intConfig.getIntValue(1);
        }

        @Override
        public void setValue(Object o) {
            if (this.typeConfig != null) {
                this.typeConfig.setFrozen(true);
                this.intConfig.setFrozen(true);
                if (o instanceof Integer) {
                    Integer i = (Integer)o;
                    switch (i) {
                        case 0: {
                            this.typeConfig.setValue(NONE);
                            this.intConfig.setValue(1);
                            break;
                        }
                        case -1: {
                            this.typeConfig.setValue(ALL);
                            this.intConfig.setValue(1);
                            break;
                        }
                        default: {
                            this.typeConfig.setValue(FIXED);
                            this.intConfig.setValue(i);
                        }
                    }
                    this.intConfig.getControls().setVisible(FIXED.equals(this.typeConfig.getValueString()));
                }
            }
            super.setValue(o);
            if (this.typeConfig != null) {
                this.typeConfig.setFrozen(false);
                this.intConfig.setFrozen(false);
            }
        }

        @Override
        public void setValue(String s) {
            if (s != null) {
                this.setValue(Integer.valueOf(s));
            }
        }

        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            this.setName(name);
            this.key = key;
            return this;
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, "/images/keyCommand.gif");
        }
    }

    public static class ReportFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new PlayerIdFormattedStringConfigurer(key, name, new String[0]);
        }
    }

    public static class Prompt
    extends StringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{MassKeyCommand.ALWAYS, MassKeyCommand.IF_ACTIVE, MassKeyCommand.IF_INACTIVE};
        }
    }
}

