/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.widget;

import VASSAL.build.Buildable;
import VASSAL.build.Widget;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.tools.AdjustableSpeedScrollPane;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.OpIcon;
import VASSAL.tools.imageop.SourceOp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.io.File;
import javax.swing.JLabel;

public class Chart
extends Widget {
    public static final String NAME = "chartName";
    public static final String FILE = "fileName";
    private Component chart;
    private String fileName;
    private SourceOp srcOp;
    private JLabel label;

    @Override
    public Component getComponent() {
        if (this.chart == null) {
            this.label = new JLabel();
            SourceOp sourceOp = this.srcOp = this.fileName == null || this.fileName.trim().length() == 0 ? null : Op.load(this.fileName);
            if (this.srcOp != null) {
                this.label.setIcon(new OpIcon(this.srcOp));
            }
            Dimension d = this.label.getPreferredSize();
            if (d.width > 300 || d.height > 300) {
                AdjustableSpeedScrollPane scroll = new AdjustableSpeedScrollPane(this.label);
                scroll.getViewport().setPreferredSize(this.label.getPreferredSize());
                scroll.getViewport().setAlignmentY(0.0f);
                this.chart = scroll;
            } else {
                this.chart = this.label;
            }
        }
        return this.chart;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void addTo(Buildable parent) {
    }

    @Override
    public void removeFrom(Buildable parent) {
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ChartWindow.htm", "Chart");
    }

    @Override
    public void setAttribute(String key, Object val) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)val);
        } else if (FILE.equals(key)) {
            if (val instanceof File) {
                val = ((File)val).getName();
            }
            this.fileName = (String)val;
            if (this.label != null) {
                SourceOp sourceOp = this.srcOp = this.fileName == null || this.fileName.trim().length() == 0 ? null : Op.load(this.fileName);
                if (this.srcOp != null) {
                    this.label.setIcon(new OpIcon(this.srcOp));
                    this.label.revalidate();
                }
            }
        }
    }

    @Override
    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, FILE};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  ", "Image:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Image.class};
    }

    @Override
    public String getAttributeValueString(String name) {
        if (NAME.equals(name)) {
            return this.getConfigureName();
        }
        if (FILE.equals(name)) {
            return this.fileName;
        }
        return null;
    }

    public static String getConfigureTypeName() {
        return "Chart";
    }
}

