/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class HttpRequestWrapper {
    private String baseURL;

    public HttpRequestWrapper(String baseURL) {
        this.baseURL = baseURL;
    }

    public List<String> doGet(Properties p) throws IOException {
        return this.doGet("", p);
    }

    private List<String> readLines(InputStream is) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);){
            ArrayList<String> arrayList;
            try (BufferedReader in = new BufferedReader(isr);){
                String line;
                ArrayList<String> l = new ArrayList<String>();
                while ((line = in.readLine()) != null) {
                    l.add(line);
                }
                arrayList = l;
            }
            return arrayList;
        }
    }

    public List<String> doGet(String url, Properties props) throws IOException {
        url = this.baseURL + (String)url;
        if (props != null) {
            url = (String)url + "?";
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = props.getProperty(key);
                url = (String)url + key + "=" + URLEncoder.encode(value, "UTF-8");
                if (!e.hasMoreElements()) continue;
                url = (String)url + "&";
            }
        }
        URLConnection conn = new URL((String)url).openConnection();
        conn.setUseCaches(false);
        try (InputStream in = conn.getInputStream();){
            List<String> list = this.readLines(in);
            return list;
        }
    }

    public List<String> doPost(Properties p) throws IOException {
        return this.doPost("", p);
    }

    public List<String> doPost(String url, Properties props) throws IOException {
        url = this.baseURL + (String)url;
        Object content = "";
        if (props != null) {
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = props.getProperty(key);
                content = (String)content + key + "=" + URLEncoder.encode(value, "UTF-8");
                if (!e.hasMoreElements()) continue;
                content = (String)content + "&";
            }
        }
        URLConnection conn = new URL((String)url).openConnection();
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        try (OutputStream co = conn.getOutputStream();
             DataOutputStream out = new DataOutputStream(co);){
            out.writeBytes((String)content);
        }
        try (InputStream in = conn.getInputStream();){
            List<String> list = this.readLines(in);
            return list;
        }
    }
}

