/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.DynamicClientFactory;
import VASSAL.chat.HybridClient;
import VASSAL.chat.jabber.JabberClientFactory;
import VASSAL.chat.node.NodeClientFactory;
import VASSAL.chat.peer2peer.P2PClientFactory;
import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.menu.MacOSXMenuManager;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import net.miginfocom.swing.MigLayout;
import org.jivesoftware.smack.util.StringUtils;

public class ServerConfigurer
extends Configurer {
    private static final String CONNECTED = Resources.getString("Server.please_disconnect");
    private static final String DISCONNECTED = Resources.getString("Server.select_server_type");
    private static final String JABBER_BUTTON = Resources.getString("Server.jabber");
    private static final String P2P_BUTTON = Resources.getString("Server.direct");
    private static final String LEGACY_BUTTON = Resources.getString("Server.legacy");
    private static final String ENCODING = "UTF-8";
    protected JComponent controls;
    private JTextField jabberHost;
    private HybridClient client;
    private JRadioButton legacyButton;
    private JRadioButton jabberButton;
    private JTextField jabberAccountName;
    private JPasswordField jabberPassword;
    private JRadioButton p2pButton;
    private JLabel header;
    private JCheckBox jabberHostPrompt;
    private JLabel jabberAccountPrompt;
    private JLabel jabberPasswordPrompt;
    private DocumentListener docListener;

    public ServerConfigurer(String key, String name, HybridClient client) {
        super(key, name, new Properties());
        this.client = client;
        client.addPropertyChangeListener("Connected", e -> this.enableControls(Boolean.TRUE.equals(e.getNewValue())));
        this.getControls();
        this.setValue(this.buildLegacyProperties());
    }

    @Override
    public Component getControls() {
        if (this.controls == null) {
            this.controls = new JPanel((LayoutManager)new MigLayout());
            this.header = new JLabel(DISCONNECTED);
            this.controls.add((Component)this.header, "wrap");
            ButtonGroup group = new ButtonGroup();
            this.jabberButton = new JRadioButton(JABBER_BUTTON);
            this.jabberButton.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.noUpdate = true;
                    this.setValue(this.buildJabberProperties());
                    this.noUpdate = false;
                }
                this.jabberHostPrompt.setEnabled(this.jabberButton.isSelected());
                this.jabberHost.setEnabled(this.jabberButton.isSelected() && this.jabberHostPrompt.isSelected());
                this.jabberAccountName.setEnabled(this.jabberButton.isSelected());
                this.jabberPassword.setEnabled(this.jabberButton.isSelected());
                this.jabberAccountPrompt.setEnabled(this.jabberButton.isSelected());
                this.jabberPasswordPrompt.setEnabled(this.jabberButton.isSelected());
            });
            this.jabberAccountPrompt = new JLabel(Resources.getString("Server.account_name"));
            this.jabberAccountPrompt.setEnabled(false);
            this.jabberAccountName = new JTextField();
            this.jabberAccountName.setEnabled(false);
            this.jabberPasswordPrompt = new JLabel(Resources.getString("Server.password"));
            this.jabberPasswordPrompt.setEnabled(false);
            this.jabberPassword = new JPasswordField();
            this.jabberPassword.setEnabled(false);
            this.jabberHostPrompt = new JCheckBox(Resources.getString("Server.host"));
            this.jabberHostPrompt.setEnabled(false);
            this.jabberHost = new JTextField(18);
            this.jabberHost.setEnabled(false);
            this.jabberHostPrompt.addItemListener(e -> {
                this.jabberHost.setEnabled(this.jabberHostPrompt.isSelected() && this.jabberButton.isSelected());
                this.docListener.changedUpdate(null);
            });
            this.jabberHost.setText("localhost:5222");
            this.docListener = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updateValue();
                }

                private void updateValue() {
                    ServerConfigurer.this.noUpdate = true;
                    ServerConfigurer.this.setValue(ServerConfigurer.this.buildJabberProperties());
                    ServerConfigurer.this.noUpdate = false;
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updateValue();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updateValue();
                }
            };
            ((AbstractDocument)this.jabberAccountName.getDocument()).setDocumentFilter(new DocumentFilter(){

                @Override
                public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                    if (text != null) {
                        super.replace(fb, offset, length, StringUtils.escapeNode((String)text).toLowerCase(), attrs);
                    }
                }

                @Override
                public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                    if (string != null) {
                        super.insertString(fb, offset, StringUtils.escapeNode((String)string).toLowerCase(), attr);
                    }
                }
            });
            this.jabberHost.getDocument().addDocumentListener(this.docListener);
            this.jabberAccountName.getDocument().addDocumentListener(this.docListener);
            this.jabberPassword.getDocument().addDocumentListener(this.docListener);
            if ("true".equals(System.getProperty("enableJabber"))) {
                group.add(this.jabberButton);
                this.controls.add((Component)this.jabberButton, "wrap");
                this.controls.add((Component)this.jabberAccountPrompt, "gap 40");
                this.controls.add((Component)this.jabberAccountName, "wrap, growx");
                this.controls.add((Component)this.jabberPasswordPrompt, "gap 40");
                this.controls.add((Component)this.jabberPassword, "wrap, growx");
                this.controls.add((Component)this.jabberHostPrompt, "gap 40");
                this.controls.add((Component)this.jabberHost, "wrap, growx");
            }
            this.p2pButton = new JRadioButton(P2P_BUTTON);
            this.p2pButton.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.noUpdate = true;
                    this.setValue(this.buildPeerProperties());
                    this.noUpdate = false;
                }
            });
            group.add(this.p2pButton);
            this.controls.add((Component)this.p2pButton, "wrap");
            this.legacyButton = new JRadioButton(LEGACY_BUTTON);
            this.legacyButton.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.noUpdate = true;
                    this.setValue(this.buildLegacyProperties());
                    this.noUpdate = false;
                }
            });
            this.controls.add(this.legacyButton);
            group.add(this.legacyButton);
        }
        return this.controls;
    }

    private void enableControls(boolean connected) {
        this.p2pButton.setEnabled(!connected);
        this.legacyButton.setEnabled(!connected);
        this.jabberButton.setEnabled(!connected);
        this.jabberHostPrompt.setEnabled(!connected);
        this.jabberHost.setEnabled(!connected && this.jabberHostPrompt.isSelected() && this.jabberButton.isSelected());
        this.jabberAccountName.setEnabled(!connected && this.jabberButton.isSelected());
        this.jabberPassword.setEnabled(!connected && this.jabberButton.isSelected());
        this.header.setText(connected ? CONNECTED : DISCONNECTED);
    }

    protected Properties buildJabberProperties() {
        Properties p = new Properties();
        if (this.jabberHostPrompt.isSelected()) {
            p.setProperty("type", "jabber");
        } else {
            p.setProperty("type", "dynamic");
            p.setProperty("dynamic", "jabber");
        }
        p.putAll((Map<?, ?>)this.getJabberConfigProperties());
        return p;
    }

    protected Properties getJabberConfigProperties() {
        Properties p = new Properties();
        p.setProperty("jabberLogin", this.jabberAccountName.getText());
        p.setProperty("jabberPassword", new String(this.jabberPassword.getPassword()));
        String host = this.jabberHost.getText();
        String port = "5222";
        int idx = host.indexOf(58);
        if (idx > 0) {
            port = host.substring(idx + 1);
            host = host.substring(0, idx);
        }
        p.setProperty("jabberHost", host);
        p.setProperty("jabberPort", port);
        return p;
    }

    protected Properties buildPeerProperties() {
        Properties p = new Properties();
        p.setProperty("type", "peer2peer");
        p.putAll((Map<?, ?>)this.getJabberConfigProperties());
        return p;
    }

    protected Properties buildLegacyProperties() {
        Properties p = new Properties();
        p.setProperty("type", "dynamic");
        p.setProperty("dynamic", "node");
        p.putAll((Map<?, ?>)this.getJabberConfigProperties());
        return p;
    }

    @Override
    public String getValueString() {
        String s = "";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Properties p = (Properties)this.getValue();
            if (p != null) {
                p.store(out, null);
            }
            s = new String(out.toByteArray(), ENCODING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }

    @Override
    public void setValue(Object o) {
        super.setValue(o);
        if (!this.noUpdate && o instanceof Properties && this.controls != null) {
            String type;
            Properties p = (Properties)o;
            String finalType = type = p.getProperty("type", "jabber");
            if ("dynamic".equals(type)) {
                finalType = p.getProperty("dynamic");
            }
            if ("node".equals(finalType)) {
                this.legacyButton.setSelected(true);
            } else if ("jabber".equals(finalType)) {
                this.jabberButton.setSelected(true);
                this.jabberHostPrompt.setSelected(type.equals(finalType));
            } else if ("peer2peer".equals(finalType)) {
                this.p2pButton.setSelected(true);
            }
            this.jabberAccountName.setText(p.getProperty("jabberLogin"));
            this.jabberPassword.setText(p.getProperty("jabberPassword"));
            this.jabberHost.setText(p.getProperty("jabberHost", "localhost") + ":" + p.getProperty("jabberPort", "5222"));
        }
        if (this.client != null && !CONNECTED.equals(this.header.getText())) {
            this.client.setDelegate(ChatServerFactory.build(this.getServerInfo()));
        }
    }

    @Override
    public void setValue(String s) {
        Properties p = new Properties();
        try {
            p.load(new ByteArrayInputStream(s.getBytes(ENCODING)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setValue(p);
    }

    private Properties getServerInfo() {
        Properties p = (Properties)this.getValue();
        p = p == null ? new Properties() : new Properties(p);
        if ("dynamic".equals(p.getProperty("type"))) {
            p.remove("jabberHost");
            p.remove("jabberPort");
        }
        return p;
    }

    public static void main(String[] args) {
        ChatServerFactory.register("node", new NodeClientFactory());
        ChatServerFactory.register("dynamic", new DynamicClientFactory());
        ChatServerFactory.register("peer2peer", new P2PClientFactory());
        ChatServerFactory.register("jabber", new JabberClientFactory());
        new MacOSXMenuManager();
        HybridClient c = new HybridClient();
        ServerConfigurer config = new ServerConfigurer("server", "server", c);
        JFrame f = new JFrame();
        f.getContentPane().add(config.getControls());
        f.pack();
        f.setVisible(true);
        f.setDefaultCloseOperation(3);
    }
}

