/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.node.Protocol;
import VASSAL.chat.node.SocketHandler;
import VASSAL.chat.node.SocketWatcher;
import java.io.IOException;
import java.net.Socket;

public class LockWatcher
extends Thread {
    private long delay;
    private long timeout;
    private int port;

    public LockWatcher(long delay, long timeout, int port) {
        this.delay = delay;
        this.timeout = timeout;
        this.port = port;
    }

    @Override
    public void run() {
        try {
            while (true) {
                LockWatcher.sleep(this.delay);
                this.pingServer();
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private void pingServer() {
        try {
            Socket s = new Socket("localhost", this.port);
            final Thread t = new Thread(new Timeout());
            SocketWatcher watcher = new SocketWatcher(){

                @Override
                public void handleMessage(String msg) {
                    t.interrupt();
                }

                @Override
                public void socketClosed(SocketHandler handler) {
                    System.err.println("Server closed socket");
                }
            };
            SocketHandler sender = new SocketHandler(s, watcher);
            sender.start();
            t.start();
            sender.writeLine(Protocol.encodeRegisterCommand("pinger", "ping/Main", ""));
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            sender.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class Timeout
    implements Runnable {
        private Timeout() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(LockWatcher.this.timeout);
                System.err.println("No response from server in " + (double)LockWatcher.this.timeout / 1000.0 + " seconds.  Terminating process");
                System.exit(0);
            }
            catch (InterruptedException e) {
                System.err.println("Ping");
            }
        }
    }
}

