/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Room;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.i18n.Resources;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class BasicChatControlsInitializer
implements ChatControlsInitializer {
    private Action connectAction;
    private Action disconnectAction;
    private ChatServerConnection client;
    private JButton connectButton;
    private JButton disconnectButton;
    private PropertyChangeListener connectionListener;

    public BasicChatControlsInitializer(ChatServerConnection client) {
        this.client = client;
    }

    @Override
    public void initializeControls(final ChatServerControls controls) {
        JToolBar toolbar = controls.getToolbar();
        this.connectAction = new AbstractAction(Resources.getString("Chat.connect")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicChatControlsInitializer.this.client.setConnected(true);
            }
        };
        URL imageURL = this.getClass().getResource("/images/connect.gif");
        if (imageURL != null) {
            this.connectAction.putValue("ShortDescription", this.connectAction.getValue("Name"));
            this.connectAction.putValue("Name", "");
            this.connectAction.putValue("SmallIcon", new ImageIcon(imageURL));
        }
        this.connectAction.setEnabled(true);
        this.disconnectAction = new AbstractAction(Resources.getString("Chat.disconnect")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicChatControlsInitializer.this.client.setConnected(false);
            }
        };
        imageURL = this.getClass().getResource("/images/disconnect.gif");
        if (imageURL != null) {
            this.disconnectAction.putValue("ShortDescription", this.disconnectAction.getValue("Name"));
            this.disconnectAction.putValue("Name", "");
            this.disconnectAction.putValue("SmallIcon", new ImageIcon(imageURL));
        }
        this.disconnectAction.setEnabled(false);
        this.connectButton = toolbar.add(this.connectAction);
        this.disconnectButton = toolbar.add(this.disconnectAction);
        this.connectionListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        boolean connected = Boolean.TRUE.equals(evt.getNewValue());
                        BasicChatControlsInitializer.this.connectAction.setEnabled(!connected);
                        BasicChatControlsInitializer.this.disconnectAction.setEnabled(connected);
                        if (!connected) {
                            controls.getRoomTree().setRooms(new Room[0]);
                            controls.getCurrentRoom().setRooms(new Room[0]);
                        }
                    }
                });
            }
        };
        this.client.addPropertyChangeListener("Connected", this.connectionListener);
    }

    @Override
    public void uninitializeControls(ChatServerControls controls) {
        controls.getToolbar().remove(this.connectButton);
        controls.getToolbar().remove(this.disconnectButton);
    }
}

