/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.command;

import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.HighlightLastMoved;
import VASSAL.command.Command;
import VASSAL.counters.BoundsTracker;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceVisitorDispatcher;
import VASSAL.counters.Stack;
import java.awt.Point;

public class MovePiece
extends Command {
    private String id;
    private String newMapId;
    private String oldMapId;
    private Point newPosition;
    private Point oldPosition;
    private String newUnderneathId;
    private String oldUnderneathId;
    private String playerId;

    public MovePiece(String id, String newMapId, Point newPosition, String newUnderneathId, String oldMapId, Point oldPosition, String oldUnderneathId, String playerId) {
        this.id = id;
        this.newMapId = newMapId;
        this.oldMapId = oldMapId;
        this.newPosition = newPosition;
        this.oldPosition = oldPosition;
        this.newUnderneathId = newUnderneathId;
        this.oldUnderneathId = oldUnderneathId;
        this.playerId = playerId;
    }

    public String getId() {
        return this.id;
    }

    public String getNewMapId() {
        return this.newMapId;
    }

    public String getOldMapId() {
        return this.oldMapId;
    }

    public Point getNewPosition() {
        return this.newPosition;
    }

    public Point getOldPosition() {
        return this.oldPosition;
    }

    public String getNewUnderneathId() {
        return this.newUnderneathId;
    }

    public String getOldUnderneathId() {
        return this.oldUnderneathId;
    }

    public String getPlayerId() {
        return this.playerId;
    }

    @Override
    protected void executeCommand() {
        GamePiece piece = GameModule.getGameModule().getGameState().getPieceForId(this.id);
        if (piece != null) {
            BoundsTracker bounds = new BoundsTracker();
            bounds.addPiece(piece);
            Map newMap = Map.getMapById(this.newMapId);
            if (newMap != null) {
                PieceVisitorDispatcher mergeFinder = this.createMergeFinder(newMap, piece, this.newPosition);
                if (this.newUnderneathId != null) {
                    GamePiece under = GameModule.getGameModule().getGameState().getPieceForId(this.newUnderneathId);
                    if (under != null && under.getPosition().equals(this.newPosition)) {
                        newMap.getStackMetrics().merge(under, piece);
                    } else if (newMap.apply(mergeFinder) == null) {
                        newMap.placeAt(piece, this.newPosition);
                    }
                } else {
                    if (newMap.apply(mergeFinder) == null) {
                        newMap.placeAt(piece, this.newPosition);
                    }
                    if (piece.getParent() != null) {
                        piece.getParent().insert(piece, 0);
                    }
                }
            } else {
                Map oldMap = Map.getMapById(this.oldMapId);
                if (oldMap != null) {
                    oldMap.removePiece(piece);
                }
            }
            bounds.addPiece(piece);
            HighlightLastMoved.setLastMoved(piece);
            bounds.repaint();
            if (piece.getMap() != null && GlobalOptions.getInstance().centerOnOpponentsMove() && !Boolean.TRUE.equals(piece.getProperty("Invisible"))) {
                piece.getMap().ensureVisible(piece.getMap().selectionBoundsOf(piece));
            }
        }
    }

    @Override
    protected Command myUndoCommand() {
        return new MovePiece(this.id, this.oldMapId, this.oldPosition, this.oldUnderneathId, this.newMapId, this.newPosition, this.newUnderneathId, this.playerId);
    }

    protected PieceVisitorDispatcher createMergeFinder(final Map map, final GamePiece p, final Point pt) {
        DeckVisitorDispatcher dispatch = new DeckVisitorDispatcher(new DeckVisitor(){

            @Override
            public Object visitDeck(Deck d) {
                if (d.getPosition().equals(pt)) {
                    return map.getStackMetrics().merge(d, p);
                }
                return null;
            }

            @Override
            public Object visitStack(Stack s) {
                if (s.getPosition().equals(pt) && map.getStackMetrics().isStackingEnabled() && !Boolean.TRUE.equals(p.getProperty("NoStack")) && s.topPiece(MovePiece.this.playerId) != null && map.getPieceCollection().canMerge(p, s)) {
                    return map.getStackMetrics().merge(s, p);
                }
                return null;
            }

            @Override
            public Object visitDefault(GamePiece piece) {
                if (piece.getPosition().equals(pt) && map.getStackMetrics().isStackingEnabled() && !Boolean.TRUE.equals(p.getProperty("NoStack")) && !Boolean.TRUE.equals(piece.getProperty("NoStack")) && map.getPieceCollection().canMerge(p, piece)) {
                    String hiddenBy = (String)piece.getProperty("hiddenBy");
                    if (hiddenBy == null || hiddenBy.equals(MovePiece.this.playerId)) {
                        return map.getStackMetrics().merge(piece, p);
                    }
                    return null;
                }
                return null;
            }
        });
        return dispatch;
    }

    @Override
    public String getDetails() {
        return "id=" + this.id + ",map=" + this.newMapId + ",position=" + this.newPosition + ",under=" + this.newUnderneathId;
    }
}

