/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class Configurer {
    public static final String NAME_PROPERTY = "Configurer.name";
    protected String key;
    protected String name;
    protected Object value;
    protected PropertyChangeSupport changeSupport;
    protected boolean noUpdate = false;
    protected boolean frozen = false;

    public Configurer(String key, String name) {
        this(key, name, null);
    }

    public Configurer(String key, String name, Object val) {
        this.key = key;
        this.name = name;
        this.changeSupport = new PropertyChangeSupport(this);
        this.setValue(val);
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        String oldName = this.name;
        this.name = s;
        if (!this.frozen) {
            this.changeSupport.firePropertyChange(NAME_PROPERTY, oldName, this.name);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public abstract String getValueString();

    public void setValue(Object o) {
        Object oldValue = this.getValue();
        this.value = o;
        if (!this.frozen) {
            this.changeSupport.firePropertyChange(this.key, oldValue, this.value);
        }
    }

    public void setFrozen(boolean val) {
        this.frozen = val;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void fireUpdate() {
        this.changeSupport.firePropertyChange(this.key, null, this.value);
    }

    public abstract void setValue(String var1);

    public abstract Component getControls();

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }
}

