/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class StringConfigurer
extends Configurer {
    protected JPanel p;
    protected JTextField nameField;
    protected int length = DEFAULT_LENGHTH;
    protected static int DEFAULT_LENGHTH = 12;

    public StringConfigurer(String key, String name) {
        this(key, name, "");
    }

    public StringConfigurer(String key, String name, String val) {
        super(key, name, val);
    }

    public StringConfigurer(String key, String name, int length) {
        this(key, name);
        this.length = length > 0 ? length : DEFAULT_LENGHTH;
    }

    @Override
    public String getValueString() {
        return (String)this.value;
    }

    @Override
    public void setValue(String s) {
        if (!this.noUpdate && this.nameField != null) {
            this.nameField.setText(s);
        }
        this.setValue((Object)s);
    }

    @Override
    public Component getControls() {
        if (this.p == null) {
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 0));
            this.p.add(new JLabel(this.getName()));
            this.nameField = this.buildTextField();
            this.nameField.setMaximumSize(new Dimension(this.nameField.getMaximumSize().width, this.nameField.getPreferredSize().height));
            this.nameField.setText(this.getValueString());
            this.p.add(this.nameField);
            this.nameField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                private void update() {
                    StringConfigurer.this.noUpdate = true;
                    StringConfigurer.this.setValue(StringConfigurer.this.nameField.getText());
                    StringConfigurer.this.noUpdate = false;
                }
            });
        }
        return this.p;
    }

    protected JTextField buildTextField() {
        return new JTextField(this.length);
    }
}

