/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.counters.BooleanAndPieceFilter;
import VASSAL.counters.BooleanOrPieceFilter;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceFilter;
import VASSAL.script.expression.BeanShellExpression;
import VASSAL.script.expression.FormattedStringExpression;
import java.util.regex.Pattern;

public class PropertiesPieceFilter {
    private static final Pattern[] CONDITIONS = new Pattern[]{Pattern.compile("!="), Pattern.compile("<="), Pattern.compile(">="), Pattern.compile(">"), Pattern.compile("<"), Pattern.compile("=~"), Pattern.compile("="), Pattern.compile("!~")};
    private static final Pattern AND = Pattern.compile("&&");
    private static final Pattern OR = Pattern.compile("\\|\\|");
    private static final PieceFilter ACCEPT_ALL = piece -> true;

    public static PieceFilter parse(String expression) {
        if (expression == null || expression.length() == 0) {
            return ACCEPT_ALL;
        }
        String[] s = OR.split(expression);
        PieceFilter f = null;
        if (s.length > 1) {
            f = PropertiesPieceFilter.parse(s[0]);
            for (int i = 1; i < s.length; ++i) {
                f = new BooleanOrPieceFilter(f, PropertiesPieceFilter.parse(s[i]));
            }
        } else {
            s = AND.split(expression);
            if (s.length > 1) {
                f = PropertiesPieceFilter.parse(s[0]);
                for (int i = 1; i < s.length; ++i) {
                    f = new BooleanAndPieceFilter(f, PropertiesPieceFilter.parse(s[i]));
                }
            } else {
                for (int i = 0; i < CONDITIONS.length && f == null; ++i) {
                    if (!expression.contains(CONDITIONS[i].pattern())) continue;
                    s = CONDITIONS[i].split(expression);
                    String name = "";
                    String value = "";
                    if (s.length <= 0) break;
                    name = s[0].trim();
                    if (s.length > 1) {
                        value = s[1].trim();
                    }
                    switch (i) {
                        case 0: {
                            f = new NE(name, value);
                            break;
                        }
                        case 1: {
                            f = new LE(name, value);
                            break;
                        }
                        case 2: {
                            f = new GE(name, value);
                            break;
                        }
                        case 3: {
                            f = new GT(name, value);
                            break;
                        }
                        case 4: {
                            f = new LT(name, value);
                            break;
                        }
                        case 5: {
                            f = new MATCH(name, value);
                            break;
                        }
                        case 6: {
                            f = new EQ(name, value);
                            break;
                        }
                        case 7: {
                            f = new NOT_MATCH(name, value);
                        }
                    }
                    break;
                }
                if (f == null) {
                    f = ACCEPT_ALL;
                }
            }
        }
        return f;
    }

    public static String toBeanShellString(String s) {
        return PropertiesPieceFilter.toBeanShellString(PropertiesPieceFilter.parse(s));
    }

    public static String toBeanShellString(PieceFilter f) {
        if (f instanceof BooleanAndPieceFilter) {
            BooleanAndPieceFilter and = (BooleanAndPieceFilter)f;
            return "(" + PropertiesPieceFilter.toBeanShellString(and.getFilter1()) + ") && (" + PropertiesPieceFilter.toBeanShellString(and.getFilter2()) + ")";
        }
        if (f instanceof BooleanOrPieceFilter) {
            BooleanOrPieceFilter or = (BooleanOrPieceFilter)f;
            return "(" + PropertiesPieceFilter.toBeanShellString(or.getFilter1()) + ") || (" + PropertiesPieceFilter.toBeanShellString(or.getFilter2()) + ")";
        }
        if (f instanceof ComparisonFilter) {
            return ((ComparisonFilter)f).toBeanShellString();
        }
        return "";
    }

    private static class NE
    extends ComparisonFilter {
        public NE(String name, String value) {
            super(name, value);
        }

        @Override
        public boolean accept(GamePiece piece) {
            boolean retVal;
            String property = String.valueOf(piece.getProperty(this.name));
            boolean bl = retVal = !this.value.equals(property);
            if (this.alternate != null) {
                retVal = retVal && !this.alternate.equals(Boolean.parseBoolean(property));
            }
            return retVal;
        }

        public String toString() {
            return "PropertiesPieceFilter[" + this.name + "!=" + this.value + "]";
        }

        @Override
        public String toBeanShellString() {
            return this.toBeanShellName() + "!=" + this.toBeanShellValue();
        }
    }

    private static class LE
    extends ComparisonFilter {
        public LE(String name, String value) {
            super(name, value);
        }

        @Override
        public boolean accept(GamePiece piece) {
            return this.compareTo(piece) <= 0;
        }

        public String toString() {
            return "PropertiesPieceFilter[" + this.name + "<=" + this.value + "]";
        }

        @Override
        public String toBeanShellString() {
            return this.toBeanShellName() + "<=" + this.toBeanShellValue();
        }
    }

    private static class GE
    extends ComparisonFilter {
        public GE(String name, String value) {
            super(name, value);
        }

        @Override
        public boolean accept(GamePiece piece) {
            return this.compareTo(piece) >= 0;
        }

        public String toString() {
            return "PropertiesPieceFilter[" + this.name + ">=" + this.value + "]";
        }

        @Override
        public String toBeanShellString() {
            return this.toBeanShellName() + ">=" + this.toBeanShellValue();
        }
    }

    private static class GT
    extends ComparisonFilter {
        public GT(String name, String value) {
            super(name, value);
        }

        @Override
        public boolean accept(GamePiece piece) {
            return this.compareTo(piece) > 0;
        }

        public String toString() {
            return "PropertiesPieceFilter[" + this.name + ">" + this.value + "]";
        }

        @Override
        public String toBeanShellString() {
            return this.toBeanShellName() + ">" + this.toBeanShellValue();
        }
    }

    private static class LT
    extends ComparisonFilter {
        public LT(String name, String value) {
            super(name, value);
        }

        @Override
        public boolean accept(GamePiece piece) {
            return this.compareTo(piece) < 0;
        }

        public String toString() {
            return "PropertiesPieceFilter[" + this.name + "<" + this.value + "]";
        }

        @Override
        public String toBeanShellString() {
            return this.toBeanShellName() + "<" + this.toBeanShellValue();
        }
    }

    private static class MATCH
    extends ComparisonFilter {
        public MATCH(String name, String value) {
            super(name, value);
        }

        @Override
        public boolean accept(GamePiece piece) {
            String property = String.valueOf(piece.getProperty(this.name));
            return Pattern.matches(this.value, property);
        }

        public String toString() {
            return "PropertiesPieceFilter[" + this.name + "~" + this.value + "]";
        }

        @Override
        public String toBeanShellString() {
            return this.toBeanShellName() + "=~" + this.toBeanShellValue();
        }
    }

    private static class EQ
    extends ComparisonFilter {
        public EQ(String name, String value) {
            super(name, value);
        }

        @Override
        public boolean accept(GamePiece piece) {
            String property = String.valueOf(piece.getProperty(this.name));
            boolean retVal = this.value.equals(property);
            if (this.alternate != null) {
                retVal = retVal || this.alternate.equals(Boolean.parseBoolean(property));
            }
            return retVal;
        }

        public String toString() {
            return "PropertiesPieceFilter[" + this.name + "==" + this.value + "]";
        }

        @Override
        public String toBeanShellString() {
            return this.toBeanShellName() + "==" + this.toBeanShellValue();
        }
    }

    private static class NOT_MATCH
    extends MATCH {
        public NOT_MATCH(String name, String value) {
            super(name, value);
        }

        @Override
        public boolean accept(GamePiece piece) {
            return !super.accept(piece);
        }

        @Override
        public String toString() {
            return "PropertiesPieceFilter[" + this.name + "!~" + this.value + "]";
        }

        @Override
        public String toBeanShellString() {
            return this.toBeanShellName() + "!~" + this.toBeanShellValue();
        }
    }

    private static abstract class ComparisonFilter
    implements PieceFilter {
        protected String name;
        protected String value;
        protected Boolean alternate;

        public ComparisonFilter(String name, String value) {
            this.name = name;
            this.value = value;
            if ("true".equals(value)) {
                this.alternate = Boolean.TRUE;
            } else if ("false".equals(value)) {
                this.alternate = Boolean.FALSE;
            }
        }

        protected int compareTo(GamePiece piece) {
            String property = String.valueOf(piece.getProperty(this.name));
            try {
                return Integer.valueOf(property).compareTo(Integer.valueOf(this.value));
            }
            catch (NumberFormatException e) {
                return property.compareTo(this.value);
            }
        }

        public abstract String toBeanShellString();

        protected String toBeanShellName() {
            if (this.name.indexOf(36) >= 0) {
                return "GetProperty(" + new FormattedStringExpression(this.name).toBeanShellString() + ")";
            }
            return BeanShellExpression.convertProperty(this.name);
        }

        protected String toBeanShellValue() {
            return new FormattedStringExpression(this.value).toBeanShellString();
        }
    }
}

