/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.KeyCommandSubMenu;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class SubMenu
extends Decorator
implements TranslatablePiece {
    public static final String ID = "submenu;";
    private String subMenu;
    private KeyCommandSubMenu keyCommandSubMenu;
    private final KeyCommand[] keyCommands = new KeyCommand[1];

    public SubMenu() {
        this("submenu;Sub-Menu;", null);
    }

    public SubMenu(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public String getDescription() {
        if ("Sub-Menu".equals(this.getMenuName())) {
            return "Sub-Menu";
        }
        return "Sub-Menu:  " + this.getMenuName();
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("SubMenu.htm");
    }

    @Override
    public PieceEditor getEditor() {
        return new Editor(this);
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.subMenu = st.nextToken();
        this.keyCommandSubMenu = new KeyCommandSubMenu(this.subMenu, this, this);
        this.keyCommandSubMenu.setCommands(StringArrayConfigurer.stringToArray(st.nextToken()));
        this.keyCommands[0] = this.keyCommandSubMenu;
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return this.keyCommands;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.getMenuName()).append(StringArrayConfigurer.arrayToString(this.getSubcommands()));
        return ID + se.getValue();
    }

    public String[] getSubcommands() {
        ArrayList<String> l = new ArrayList<String>();
        Iterator<String> i = this.keyCommandSubMenu.getCommands();
        while (i.hasNext()) {
            l.add(i.next());
        }
        return l.toArray(new String[0]);
    }

    public String getMenuName() {
        return this.subMenu;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        return null;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Rectangle boundingBox() {
        return this.getInner().boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.getInner().draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.getInner().getName();
    }

    @Override
    public Shape getShape() {
        return this.getInner().getShape();
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.getMenuName(), "Sub Menu Name");
    }

    public static class Editor
    implements PieceEditor {
        private StringConfigurer nameConfig;
        private StringArrayConfigurer commandsConfig;
        private JPanel panel = new JPanel();

        public Editor(SubMenu p) {
            this.nameConfig = new StringConfigurer(null, "Menu name:  ", p.getMenuName());
            this.commandsConfig = new StringArrayConfigurer(null, "Sub-commands", p.getSubcommands());
            this.panel.setLayout((LayoutManager)new MigLayout("fill", "[]rel[]"));
            this.panel.add(this.nameConfig.getControls(), "growx,wrap");
            this.panel.add(this.commandsConfig.getControls(), "grow,push");
        }

        @Override
        public Component getControls() {
            return this.panel;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.nameConfig.getValueString()).append(this.commandsConfig.getValueString());
            return SubMenu.ID + se.getValue();
        }
    }
}

